/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.weaver.pe;

import ch.usi.dag.disl.weaver.pe.ClassHelper;
import ch.usi.dag.disl.weaver.pe.ConstValue;
import ch.usi.dag.disl.weaver.pe.Reference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationInterpreter {
    private HashSet<String> registeredMethods = new HashSet();
    private static InvocationInterpreter instance = new InvocationInterpreter();

    public Object execute(MethodInsnNode instr, List<? extends ConstValue> values) {
        int opcode = instr.getOpcode();
        if (opcode == 185) {
            return null;
        }
        if (!this.registeredMethods.contains(this.getMethodID(instr))) {
            return null;
        }
        if (opcode == 183 && instr.name.equals("<clinit>")) {
            if (!(values.get((int)0).cst instanceof Reference)) {
                return null;
            }
            for (int i = 1; i < values.size(); ++i) {
                if (ClassHelper.dereference(values.get(i)) != null) continue;
                return null;
            }
        } else {
            for (ConstValue constValue : values) {
                if (constValue.cst != null) continue;
                return null;
            }
        }
        try {
            Class<?> clazz = Class.forName(instr.owner.replace('/', '.'));
            Class<?>[] classArray = ClassHelper.getClasses(instr.desc);
            if (classArray == null) {
                return null;
            }
            Object[] args = ClassHelper.getArgs(instr, values, classArray);
            if (args == null) {
                return null;
            }
            if (instr.name.equals("<init>")) {
                Reference ref = (Reference)values.get((int)0).cst;
                ref.setObj(clazz.getConstructor(classArray).newInstance(args));
                return null;
            }
            if (!instr.name.equals("<clinit>")) {
                Object caller = ClassHelper.getCaller(instr, values);
                Class<?> retType = ClassHelper.getClassFromType(Type.getReturnType(instr.desc));
                if (retType == null) {
                    return null;
                }
                Object retValue = clazz.getMethod(instr.name, classArray).invoke(caller, args);
                return ClassHelper.address(retValue, retType);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void register(String owner, String name, String desc) {
        this.registeredMethods.add(owner + "." + name + desc);
    }

    public void register(Class<?> clazz) {
        String owner = Type.getInternalName(clazz);
        for (Constructor<?> constructor : clazz.getConstructors()) {
            this.register(owner, "<init>", Type.getConstructorDescriptor(constructor));
        }
        for (Executable executable : clazz.getMethods()) {
            this.register(owner, ((Method)executable).getName(), Type.getMethodDescriptor((Method)executable));
        }
    }

    private String getMethodID(MethodInsnNode min) {
        return min.owner + "." + min.name + min.desc;
    }

    public boolean isRegistered(MethodInsnNode min) {
        return this.registeredMethods.contains(this.getMethodID(min));
    }

    public static InvocationInterpreter getInstance() {
        return instance;
    }

    static {
        instance.register(Boolean.class);
        instance.register(Byte.class);
        instance.register(Character.class);
        instance.register(Double.class);
        instance.register(Float.class);
        instance.register(Integer.class);
        instance.register(Long.class);
        instance.register(Short.class);
        instance.register(String.class);
        instance.register(StringBuilder.class);
    }
}

