/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.weaver;

import ch.usi.dag.disl.exception.DiSLFatalException;
import ch.usi.dag.disl.util.AsmHelper;
import java.util.Collections;
import java.util.Comparator;
import org.objectweb.asm.commons.TryCatchBlockSorter;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class AdvancedSorter
extends TryCatchBlockSorter {
    public AdvancedSorter(MethodNode method) {
        super(null, method.access, method.name, method.desc, method.signature, null);
        this.instructions = method.instructions;
        this.tryCatchBlocks = method.tryCatchBlocks;
    }

    public void validate() {
        TryCatchBlockNode[] tcbs = new TryCatchBlockNode[this.tryCatchBlocks.size()];
        tcbs = this.tryCatchBlocks.toArray(tcbs);
        for (int i = 0; i < tcbs.length; ++i) {
            int istart = this.instructions.indexOf(AsmHelper.skipVirtualInsns(tcbs[i].start, true));
            int iend = this.instructions.indexOf(tcbs[i].end);
            for (int j = i; j < tcbs.length; ++j) {
                int jstart = this.instructions.indexOf(AsmHelper.skipVirtualInsns(tcbs[j].start, true));
                int jend = this.instructions.indexOf(tcbs[j].end);
                if ((!AsmHelper.offsetBefore(this.instructions, istart, jstart) || !AsmHelper.offsetBefore(this.instructions, jstart, iend) || !AsmHelper.offsetBefore(this.instructions, iend, jend)) && (!AsmHelper.offsetBefore(this.instructions, jstart, istart) || !AsmHelper.offsetBefore(this.instructions, istart, jend) || !AsmHelper.offsetBefore(this.instructions, jend, iend))) continue;
                throw new DiSLFatalException("Crossing exception handler.");
            }
        }
    }

    public void visitEnd() {
        Comparator<TryCatchBlockNode> comp = new Comparator<TryCatchBlockNode>(){

            @Override
            public int compare(TryCatchBlockNode t1, TryCatchBlockNode t2) {
                int len1 = this.blockLength(t1);
                int len2 = this.blockLength(t2);
                return len1 - len2;
            }

            private int blockLength(TryCatchBlockNode block) {
                int startidx = AdvancedSorter.this.instructions.indexOf(AsmHelper.skipVirtualInsns(block.start, true));
                int endidx = AdvancedSorter.this.instructions.indexOf(block.end);
                return endidx - startidx;
            }
        };
        Collections.sort(this.tryCatchBlocks, comp);
    }

    public static void sort(MethodNode method) {
        AdvancedSorter sorter = new AdvancedSorter(method);
        sorter.visitEnd();
        sorter.validate();
    }
}

