/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.utilinstr.codemerger;

import ch.usi.dag.disl.dynamicbypass.DynamicBypassCheck;
import ch.usi.dag.disl.exception.DiSLFatalException;
import ch.usi.dag.disl.util.AsmHelper;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.CodeSizeEvaluator;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CodeMerger {
    private static final String DBCHECK_CLASS = Type.getInternalName(DynamicBypassCheck.class);
    private static final String DBCHECK_METHOD = "executeUninstrumented";
    private static final String DBCHECK_DESC = "()Z";
    private static final int ALLOWED_SIZE = 65536;

    public static ClassNode mergeClasses(ClassNode originalCN, ClassNode instrumentedCN, Set<String> changedMethods, boolean splitLongMethods) {
        if (changedMethods == null) {
            throw new DiSLFatalException("Set of changed methods cannot be null");
        }
        if (changedMethods.isEmpty()) {
            return instrumentedCN;
        }
        for (MethodNode instrMN : instrumentedCN.methods) {
            if (!changedMethods.contains(instrMN.name + instrMN.desc)) continue;
            MethodNode origMN = CodeMerger.getMethodNode(originalCN, instrMN.name, instrMN.desc);
            InsnList ilist = instrMN.instructions;
            List<TryCatchBlockNode> tcblist = instrMN.tryCatchBlocks;
            AsmHelper.ClonedCode origCodeCopy = AsmHelper.ClonedCode.create(origMN.instructions, origMN.tryCatchBlocks);
            AsmHelper.ClonedCode splitCopy = null;
            if (splitLongMethods) {
                splitCopy = AsmHelper.ClonedCode.create(ilist, tcblist);
            }
            LabelNode origCodeL = new LabelNode();
            ilist.add(origCodeL);
            ilist.add(origCodeCopy.getInstructions());
            tcblist.addAll(origCodeCopy.getTryCatchBlocks());
            ilist.insert(new JumpInsnNode(154, origCodeL));
            ilist.insert(new MethodInsnNode(184, DBCHECK_CLASS, DBCHECK_METHOD, DBCHECK_DESC));
            CodeSizeEvaluator cse = new CodeSizeEvaluator(null);
            instrMN.accept(cse);
            if (cse.getMaxSize() <= 65536) continue;
            if (splitLongMethods) {
                instrMN.instructions = splitCopy.getInstructions();
                instrMN.tryCatchBlocks = splitCopy.getTryCatchBlocks();
                CodeMerger.splitLongMethods(instrumentedCN, origMN, instrMN);
                continue;
            }
            instrMN.instructions = origMN.instructions;
            instrMN.tryCatchBlocks = origMN.tryCatchBlocks;
            System.err.println("WARNING: code of the method " + instrumentedCN.name + "." + instrMN.name + " is larger (" + cse.getMaxSize() + ") then allowed size (" + 65536 + ") - skipping");
        }
        return instrumentedCN;
    }

    private static void splitLongMethods(ClassNode instrumentedCN, MethodNode origMN, MethodNode instrMN) {
    }

    private static MethodNode getMethodNode(ClassNode cnToSearch, String methodName, String methodDesc) {
        for (MethodNode mn : cnToSearch.methods) {
            if (!methodName.equals(mn.name) || !methodDesc.equals(mn.desc)) continue;
            return mn;
        }
        throw new RuntimeException("Code merger fatal error: method for merge not found");
    }
}

