/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.util.cfg;

import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.BasicBlockCalc;
import ch.usi.dag.disl.util.cfg.BasicBlock;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtrlFlowGraph {
    private static final int NOT_FOUND = -1;
    private static final int NEW = -2;
    private List<BasicBlock> nodes = new LinkedList<BasicBlock>();
    private List<BasicBlock> connected_nodes = new LinkedList<BasicBlock>();
    private int connected_size = 0;
    private Set<BasicBlock> method_exits = new HashSet<BasicBlock>();

    public CtrlFlowGraph(InsnList instructions, List<TryCatchBlockNode> tryCatchBlocks) {
        List<AbstractInsnNode> seperators = BasicBlockCalc.getAll(instructions, tryCatchBlocks, false);
        AbstractInsnNode last = instructions.getLast();
        seperators.add(last);
        for (int i = 0; i < seperators.size() - 1; ++i) {
            AbstractInsnNode start = seperators.get(i);
            AbstractInsnNode end = seperators.get(i + 1);
            if (i != seperators.size() - 2) {
                end = end.getPrevious();
            }
            end = AsmHelper.skipVirtualInsns(end, false);
            this.nodes.add(new BasicBlock(i, start, end));
        }
    }

    public CtrlFlowGraph(MethodNode method) {
        this(method.instructions, method.tryCatchBlocks);
    }

    public List<BasicBlock> getNodes() {
        return this.nodes;
    }

    public int getIndex(AbstractInsnNode instr) {
        BasicBlock bb = this.getBB(instr);
        if (bb == null) {
            return -1;
        }
        return bb.getIndex();
    }

    public BasicBlock getBB(AbstractInsnNode instr) {
        for (instr = AsmHelper.skipVirtualInsns(instr, true); instr != null; instr = instr.getPrevious()) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (!this.nodes.get(i).getEntrance().equals(instr)) continue;
                return this.nodes.get(i);
            }
        }
        return null;
    }

    private int tryVisit(BasicBlock current, AbstractInsnNode node) {
        BasicBlock bb = this.getBB(node);
        if (bb == null) {
            return -1;
        }
        if (this.connected_nodes.contains(bb)) {
            int index = this.connected_nodes.indexOf(bb);
            if (current != null) {
                if (index < this.connected_size) {
                    current.getJoins().add(bb);
                } else {
                    current.getSuccessors().add(bb);
                    bb.getPredecessors().add(current);
                }
            }
            return index;
        }
        if (current != null) {
            current.getSuccessors().add(bb);
            bb.getPredecessors().add(current);
        }
        this.connected_nodes.add(bb);
        return -2;
    }

    private void tryVisit(BasicBlock current, AbstractInsnNode node, AbstractInsnNode exit, List<AbstractInsnNode> joins) {
        int ret = this.tryVisit(current, node);
        if (ret >= 0 && ret < this.connected_size) {
            joins.add(exit);
        }
    }

    public List<AbstractInsnNode> visit(AbstractInsnNode root) {
        LinkedList<AbstractInsnNode> joins = new LinkedList<AbstractInsnNode>();
        if (this.tryVisit(null, root) == -1) {
            return joins;
        }
        block5: for (int i = this.connected_size; i < this.connected_nodes.size(); ++i) {
            BasicBlock current = this.connected_nodes.get(i);
            AbstractInsnNode exit = current.getExit();
            int opcode = exit.getOpcode();
            switch (exit.getType()) {
                case 7: {
                    this.tryVisit(current, ((JumpInsnNode)exit).label, exit, joins);
                    if (opcode == 167) continue block5;
                    this.tryVisit(current, exit.getNext(), exit, joins);
                    continue block5;
                }
                case 12: {
                    LookupSwitchInsnNode lsin = (LookupSwitchInsnNode)exit;
                    for (LabelNode label : lsin.labels) {
                        this.tryVisit(current, label, exit, joins);
                    }
                    this.tryVisit(current, lsin.dflt, exit, joins);
                    continue block5;
                }
                case 11: {
                    TableSwitchInsnNode tsin = (TableSwitchInsnNode)exit;
                    for (LabelNode label : tsin.labels) {
                        this.tryVisit(current, label, exit, joins);
                    }
                    this.tryVisit(current, tsin.dflt, exit, joins);
                    continue block5;
                }
                default: {
                    if (opcode >= 172 && opcode <= 177 || opcode == 191) {
                        this.method_exits.add(current);
                        continue block5;
                    }
                    this.tryVisit(current, exit.getNext(), exit, joins);
                }
            }
        }
        this.connected_size = this.connected_nodes.size();
        return joins;
    }

    public List<AbstractInsnNode> getEnds() {
        LinkedList<AbstractInsnNode> ends = new LinkedList<AbstractInsnNode>();
        for (BasicBlock bb : this.nodes) {
            if (bb.getSuccessors().size() != 0) continue;
            ends.add(bb.getExit());
        }
        return ends;
    }

    public static CtrlFlowGraph build(InsnList instructions, List<TryCatchBlockNode> tryCatchBlocks) {
        CtrlFlowGraph cfg = new CtrlFlowGraph(instructions, tryCatchBlocks);
        cfg.visit(instructions.getFirst());
        for (TryCatchBlockNode tcb : tryCatchBlocks) {
            cfg.visit(tcb.handler);
        }
        return cfg;
    }

    public static CtrlFlowGraph build(MethodNode method) {
        return CtrlFlowGraph.build(method.instructions, method.tryCatchBlocks);
    }
}

