/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.util.cfg;

import ch.usi.dag.disl.exception.DiSLFatalException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBlock
implements Iterable<AbstractInsnNode> {
    private int index;
    private AbstractInsnNode entrance;
    private AbstractInsnNode exit;
    private Set<BasicBlock> predecessors;
    private Set<BasicBlock> successors;
    private Set<BasicBlock> joins;

    public BasicBlock(int index, AbstractInsnNode entrance, AbstractInsnNode exit) {
        this.index = index;
        this.entrance = entrance;
        this.exit = exit;
        this.successors = new HashSet<BasicBlock>();
        this.predecessors = new HashSet<BasicBlock>();
        this.joins = new HashSet<BasicBlock>();
    }

    public int getIndex() {
        return this.index;
    }

    public AbstractInsnNode getEntrance() {
        return this.entrance;
    }

    public void setExit(AbstractInsnNode exit) {
        this.exit = exit;
    }

    public AbstractInsnNode getExit() {
        return this.exit;
    }

    public Set<BasicBlock> getPredecessors() {
        return this.predecessors;
    }

    public Set<BasicBlock> getSuccessors() {
        return this.successors;
    }

    public Set<BasicBlock> getJoins() {
        return this.joins;
    }

    @Override
    public Iterator<AbstractInsnNode> iterator() {
        return new BasicBlockIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BasicBlockIterator
    implements Iterator<AbstractInsnNode> {
        private AbstractInsnNode current;

        public BasicBlockIterator() {
            this.current = BasicBlock.this.entrance;
        }

        @Override
        public boolean hasNext() {
            return this.current != BasicBlock.this.exit.getNext();
        }

        @Override
        public AbstractInsnNode next() {
            AbstractInsnNode temp = this.current;
            this.current = this.current.getNext();
            return temp;
        }

        @Override
        public void remove() {
            throw new DiSLFatalException("Readonly iterator.");
        }
    }
}

