/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.util;

import ch.usi.dag.disl.exception.DiSLFatalException;
import ch.usi.dag.disl.util.AsmOpcodes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsmHelper {
    public static final Map<String, Type> PRIMITIVE_TYPES = new HashMap<String, Type>(){
        {
            this.put(Boolean.class, Type.BOOLEAN_TYPE);
            this.put(Byte.class, Type.BYTE_TYPE);
            this.put(Character.class, Type.CHAR_TYPE);
            this.put(Short.class, Type.SHORT_TYPE);
            this.put(Integer.class, Type.INT_TYPE);
            this.put(Float.class, Type.FLOAT_TYPE);
            this.put(Long.class, Type.LONG_TYPE);
            this.put(Double.class, Type.DOUBLE_TYPE);
        }

        @Override
        void put(Class<?> typeClass, Type type) {
            this.put(Type.getInternalName(typeClass), type);
        }
    };

    public static boolean offsetBefore(InsnList ilst, int from, int to) {
        if (from >= to) {
            return false;
        }
        for (int i = from; i < to; ++i) {
            if (ilst.get(i).getOpcode() == -1) continue;
            return true;
        }
        return false;
    }

    public static AbstractInsnNode loadConst(Object value) {
        if (value instanceof Boolean) {
            return new InsnNode((Boolean)value != false ? 4 : 3);
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            int intValue = 0;
            if (value instanceof Integer) {
                intValue = (Integer)value;
            } else if (value instanceof Short) {
                intValue = ((Short)value).intValue();
            } else if (value instanceof Byte) {
                intValue = ((Byte)value).intValue();
            }
            switch (intValue) {
                case -1: {
                    return new InsnNode(2);
                }
                case 0: {
                    return new InsnNode(3);
                }
                case 1: {
                    return new InsnNode(4);
                }
                case 2: {
                    return new InsnNode(5);
                }
                case 3: {
                    return new InsnNode(6);
                }
                case 4: {
                    return new InsnNode(7);
                }
                case 5: {
                    return new InsnNode(8);
                }
            }
            if (intValue >= -128 && intValue <= 127) {
                return new IntInsnNode(16, intValue);
            }
            if (intValue >= Short.MIN_VALUE && intValue <= Short.MAX_VALUE) {
                return new IntInsnNode(17, intValue);
            }
            return new LdcInsnNode((Object)intValue);
        }
        if (value instanceof Long) {
            long longValue = (Long)value;
            if (longValue == 0L) {
                return new InsnNode(9);
            }
            if (longValue == 1L) {
                return new InsnNode(10);
            }
        } else if (value instanceof Float) {
            float floatValue = ((Float)value).floatValue();
            if (floatValue == 0.0f) {
                return new InsnNode(11);
            }
            if (floatValue == 1.0f) {
                return new InsnNode(12);
            }
            if (floatValue == 2.0f) {
                return new InsnNode(13);
            }
        } else if (value instanceof Double) {
            double doubleValue = (Double)value;
            if (doubleValue == 0.0) {
                return new InsnNode(14);
            }
            if (doubleValue == 1.0) {
                return new InsnNode(15);
            }
        }
        return new LdcInsnNode(value);
    }

    public static String getStringConstOperand(AbstractInsnNode insn) {
        if (insn.getOpcode() == 18) {
            LdcInsnNode ldcNode = (LdcInsnNode)insn;
            if (ldcNode.cst instanceof String) {
                return (String)ldcNode.cst;
            }
            throw new DiSLFatalException("LDC operand is not a String");
        }
        throw new DiSLFatalException(String.format("Expected LdcInsnNode, found %s (%s)", new Object[]{insn.getClass().getSimpleName(), AsmOpcodes.valueOf(insn)}));
    }

    public static int getIntConstOperand(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 16: 
            case 17: {
                return ((IntInsnNode)insn).operand;
            }
            case 18: {
                LdcInsnNode ldc = (LdcInsnNode)insn;
                if (ldc.cst instanceof Integer) {
                    return (Integer)ldc.cst;
                }
                throw new DiSLFatalException("LDC operand is not an integer");
            }
        }
        throw new DiSLFatalException(String.format("Cannot extract integer constant operand from %s (%s)", new Object[]{insn.getClass().getSimpleName(), AsmOpcodes.valueOf(insn)}));
    }

    public static Type getTypeConstOperand(AbstractInsnNode insn) {
        if (insn.getOpcode() == 18) {
            LdcInsnNode ldcNode = (LdcInsnNode)insn;
            if (ldcNode.cst instanceof Type) {
                return (Type)ldcNode.cst;
            }
            throw new DiSLFatalException("LDC operand is not a Type");
        }
        if (insn.getOpcode() == 178) {
            FieldInsnNode fieldNode = (FieldInsnNode)insn;
            if ("TYPE".equals(fieldNode.name)) {
                Type result = PRIMITIVE_TYPES.get(fieldNode.owner);
                if (result == null) {
                    throw new DiSLFatalException(String.format("Expected primitive boxing class, found %s", fieldNode.owner));
                }
                return result;
            }
            throw new DiSLFatalException(String.format("Expected access to static TYPE field, found %s", fieldNode.name));
        }
        throw new DiSLFatalException(String.format("Expected LdcInsnNode, found %s (%s)", new Object[]{insn.getClass().getSimpleName(), AsmOpcodes.valueOf(insn)}));
    }

    public static boolean isTypeConstLoadInsn(AbstractInsnNode insn) {
        if (insn.getOpcode() == 18) {
            return ((LdcInsnNode)insn).cst instanceof Type;
        }
        if (insn.getOpcode() == 178) {
            FieldInsnNode fieldInsn = (FieldInsnNode)insn;
            Type type = PRIMITIVE_TYPES.get(fieldInsn.owner);
            return "TYPE".equals(fieldInsn.name) && type != null;
        }
        return false;
    }

    public static VarInsnNode loadThis() {
        return AsmHelper.loadObjectVar(0);
    }

    public static VarInsnNode loadObjectVar(int slot) {
        return AsmHelper.loadVar(Type.getType(Object.class), slot);
    }

    public static VarInsnNode loadVar(Type type, int slot) {
        return new VarInsnNode(type.getOpcode(21), slot);
    }

    public static VarInsnNode storeObjectVar(int slot) {
        return AsmHelper.storeVar(Type.getType(Object.class), slot);
    }

    public static VarInsnNode storeVar(Type type, int slot) {
        return new VarInsnNode(type.getOpcode(54), slot);
    }

    public static InsnNode loadDefault() {
        return AsmHelper.loadDefault(Type.getType(Object.class));
    }

    public static InsnNode loadDefault(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new InsnNode(3);
            }
            case 7: {
                return new InsnNode(9);
            }
            case 6: {
                return new InsnNode(11);
            }
            case 8: {
                return new InsnNode(14);
            }
            case 10: {
                return new InsnNode(1);
            }
        }
        throw new DiSLFatalException("No default value for type: " + type.getDescriptor());
    }

    public static TypeInsnNode checkCast(Type type) {
        return new TypeInsnNode(192, type.getDescriptor());
    }

    public static FieldInsnNode getField(String owner, String name, String desc) {
        return new FieldInsnNode(180, owner, name, desc);
    }

    public static FieldInsnNode putField(String owner, String name, String desc) {
        return new FieldInsnNode(181, owner, name, desc);
    }

    public static FieldInsnNode getStatic(String owner, String name, String desc) {
        return new FieldInsnNode(178, owner, name, desc);
    }

    public static FieldInsnNode putStatic(String owner, String name, String desc) {
        return new FieldInsnNode(179, owner, name, desc);
    }

    public static MethodInsnNode invokeStatic(Type ownerType, String methodName, Type methodType) {
        return new MethodInsnNode(184, ownerType.getInternalName(), methodName, methodType.getDescriptor());
    }

    public static int getInternalParamIndex(MethodNode method, int parIndex) {
        Type[] types = Type.getArgumentTypes(method.desc);
        if (parIndex >= types.length) {
            throw new DiSLFatalException("Parameter index out of bound");
        }
        int index = 0;
        for (int i = 0; i < parIndex; ++i) {
            index += types[i].getSize();
        }
        if ((method.access & 8) == 0) {
            ++index;
        }
        return index;
    }

    public static void replaceRetWithGoto(InsnList insnList) {
        LinkedList<AbstractInsnNode> returnInsns = new LinkedList<AbstractInsnNode>();
        for (AbstractInsnNode instr : AsmHelper.allInsnsFrom(insnList)) {
            if (!AsmHelper.isReturn(instr.getOpcode())) continue;
            returnInsns.add(instr);
        }
        if (returnInsns.size() > 1) {
            LabelNode endLabel = new LabelNode(new Label());
            for (AbstractInsnNode insn : returnInsns) {
                insnList.insertBefore(insn, new JumpInsnNode(167, endLabel));
                insnList.remove(insn);
            }
            insnList.add(endLabel);
        } else if (returnInsns.size() == 1) {
            insnList.remove((AbstractInsnNode)returnInsns.get(0));
        }
    }

    public static InsnList cloneInsnList(InsnList insnList) {
        return AsmHelper.cloneInsnList(insnList, AsmHelper.createReplacementLabelMap(insnList));
    }

    private static Map<LabelNode, LabelNode> createReplacementLabelMap(InsnList insnList) {
        HashMap<LabelNode, LabelNode> result = new HashMap<LabelNode, LabelNode>();
        for (AbstractInsnNode insn : AsmHelper.allInsnsFrom(insnList)) {
            if (!(insn instanceof LabelNode)) continue;
            LabelNode clone = new LabelNode(new Label());
            LabelNode original = (LabelNode)insn;
            result.put(original, clone);
        }
        return result;
    }

    private static InsnList cloneInsnList(InsnList insnList, Map<LabelNode, LabelNode> replacementLabels) {
        InsnList result = new InsnList();
        for (AbstractInsnNode insn : AsmHelper.allInsnsFrom(insnList)) {
            result.add(insn.clone(replacementLabels));
        }
        return result;
    }

    private static List<TryCatchBlockNode> cloneTryCatchBlocks(List<TryCatchBlockNode> tryCatchBlocks, Map<LabelNode, LabelNode> replacementLabels) {
        LinkedList<TryCatchBlockNode> result = new LinkedList<TryCatchBlockNode>();
        for (TryCatchBlockNode tcb : tryCatchBlocks) {
            TryCatchBlockNode tcbClone = new TryCatchBlockNode(replacementLabels.get(tcb.start), replacementLabels.get(tcb.end), replacementLabels.get(tcb.handler), tcb.type);
            result.add(tcbClone);
        }
        return result;
    }

    public static AbstractInsnNode skipVirtualInsnsForward(AbstractInsnNode instr) {
        return AsmHelper.skipVirtualInsns(instr, true);
    }

    public static AbstractInsnNode skipVirtualInsns(AbstractInsnNode instr, boolean isForward) {
        while (instr != null && AsmHelper.isVirtualInstr(instr)) {
            instr = isForward ? instr.getNext() : instr.getPrevious();
        }
        return instr;
    }

    public static AbstractInsnNode prevNonVirtualInsn(AbstractInsnNode startInsn) {
        AbstractInsnNode insn = startInsn;
        while (insn != null) {
            if (AsmHelper.isVirtualInstr(insn = insn.getPrevious())) continue;
            return insn;
        }
        return null;
    }

    public static AbstractInsnNode nextNonVirtualInsn(AbstractInsnNode start) {
        AbstractInsnNode insn = start;
        while (insn != null) {
            if (AsmHelper.isVirtualInstr(insn = insn.getNext())) continue;
            return insn;
        }
        return null;
    }

    public static boolean isReferenceType(Type type) {
        return type.getSort() == 10 || type.getSort() == 9;
    }

    public static boolean isVirtualInstr(AbstractInsnNode insn) {
        return insn.getOpcode() == -1;
    }

    public static boolean containsOnlyReturn(InsnList ilst) {
        AbstractInsnNode instr;
        for (instr = ilst.getFirst(); instr != null && AsmHelper.isVirtualInstr(instr); instr = instr.getNext()) {
        }
        if (instr == null) {
            throw new IllegalArgumentException("instr is null");
        }
        return AsmHelper.isReturn(instr.getOpcode());
    }

    public static boolean isStaticFieldAccess(int opcode) {
        return opcode == 178 || opcode == 179;
    }

    public static boolean isReturn(int opcode) {
        return opcode >= 172 && opcode <= 177;
    }

    public static boolean isBranch(AbstractInsnNode instruction) {
        int opcode = instruction.getOpcode();
        return instruction instanceof JumpInsnNode || instruction instanceof LookupSwitchInsnNode || instruction instanceof TableSwitchInsnNode || opcode == 191 || opcode == 169 || opcode >= 172 && opcode <= 177;
    }

    public static boolean isConditionalBranch(AbstractInsnNode instruction) {
        int opcode = instruction.getOpcode();
        return instruction instanceof JumpInsnNode && opcode != 167;
    }

    public static boolean mightThrowException(AbstractInsnNode instruction) {
        switch (instruction.getOpcode()) {
            case 18: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 197: {
                return true;
            }
        }
        return false;
    }

    private static MethodInsnNode constructValueOf(Class<?> boxClass, Class<?> primitiveClass) {
        Type boxType = Type.getType(boxClass);
        Type primitiveType = Type.getType(primitiveClass);
        Type methodType = Type.getMethodType(boxType, primitiveType);
        return AsmHelper.invokeStatic(boxType, "valueOf", methodType);
    }

    public static MethodInsnNode boxValueOnStack(Type valueType) {
        switch (valueType.getSort()) {
            case 1: {
                return AsmHelper.constructValueOf(Boolean.class, Boolean.TYPE);
            }
            case 3: {
                return AsmHelper.constructValueOf(Byte.class, Byte.TYPE);
            }
            case 2: {
                return AsmHelper.constructValueOf(Character.class, Character.TYPE);
            }
            case 8: {
                return AsmHelper.constructValueOf(Double.class, Double.TYPE);
            }
            case 6: {
                return AsmHelper.constructValueOf(Float.class, Float.TYPE);
            }
            case 5: {
                return AsmHelper.constructValueOf(Integer.class, Integer.TYPE);
            }
            case 7: {
                return AsmHelper.constructValueOf(Long.class, Long.TYPE);
            }
            case 4: {
                return AsmHelper.constructValueOf(Short.class, Short.TYPE);
            }
        }
        throw new DiSLFatalException("Impossible to box type: " + valueType.getDescriptor());
    }

    public static AbstractInsnNode findFirstValidMark(MethodNode method) {
        AbstractInsnNode first = method.instructions.getFirst();
        if (!method.name.equals("<init>")) {
            return first;
        }
        class DataHolder {
            boolean trigger = false;

            DataHolder() {
            }
        }
        final DataHolder dh = new DataHolder();
        MethodVisitor emptyVisitor = new MethodVisitor(262144){};
        AdviceAdapter adapter = new AdviceAdapter(262144, emptyVisitor, method.access, method.name, method.desc){
            {
                super(x0, x1, x2, x3, x4);
            }

            public void onMethodEnter() {
                dh.trigger = true;
            }
        };
        adapter.visitCode();
        for (AbstractInsnNode iterator : AsmHelper.allInsnsFrom(method.instructions)) {
            iterator.accept(adapter);
            if (!dh.trigger) continue;
            first = iterator.getNext();
            break;
        }
        return first;
    }

    public static final Iterable<AbstractInsnNode> allInsnsFrom(final InsnList list) {
        return new Iterable<AbstractInsnNode>(){

            @Override
            public Iterator<AbstractInsnNode> iterator() {
                return list.iterator();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClonedCode {
        private final InsnList instructions;
        private final List<TryCatchBlockNode> tryCatchBlocks;

        public ClonedCode(InsnList instructions, List<TryCatchBlockNode> tryCatchBlocks) {
            this.instructions = instructions;
            this.tryCatchBlocks = tryCatchBlocks;
        }

        public InsnList getInstructions() {
            return this.instructions;
        }

        public List<TryCatchBlockNode> getTryCatchBlocks() {
            return this.tryCatchBlocks;
        }

        public static ClonedCode create(InsnList instructions, List<TryCatchBlockNode> tryCatchBlocks) {
            Map replacementLabels = AsmHelper.createReplacementLabelMap(instructions);
            return new ClonedCode(AsmHelper.cloneInsnList(instructions, replacementLabels), AsmHelper.cloneTryCatchBlocks(tryCatchBlocks, replacementLabels));
        }
    }
}

