/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.snippet;

import ch.usi.dag.disl.exception.ProcessorException;
import ch.usi.dag.disl.exception.ReflectionException;
import ch.usi.dag.disl.exception.StaticContextGenException;
import ch.usi.dag.disl.localvar.LocalVars;
import ch.usi.dag.disl.marker.Marker;
import ch.usi.dag.disl.processor.Proc;
import ch.usi.dag.disl.scope.Scope;
import ch.usi.dag.disl.snippet.SnippetCode;
import ch.usi.dag.disl.snippet.SnippetUnprocessedCode;
import java.lang.reflect.Method;
import java.util.Map;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snippet
implements Comparable<Snippet> {
    private String originClassName;
    private String originMethodName;
    private Class<?> annotationClass;
    private Marker marker;
    private Scope scope;
    private Method guard;
    private int order;
    private SnippetUnprocessedCode unprocessedCode;
    private SnippetCode code;

    public Snippet(String originClassName, String originMethodName, Class<?> annotationClass, Marker marker, Scope scope, Method guard, int order, SnippetUnprocessedCode unprocessedCode) {
        this.originClassName = originClassName;
        this.originMethodName = originMethodName;
        this.annotationClass = annotationClass;
        this.marker = marker;
        this.scope = scope;
        this.guard = guard;
        this.order = order;
        this.unprocessedCode = unprocessedCode;
    }

    public String getOriginClassName() {
        return this.originClassName;
    }

    public String getOriginMethodName() {
        return this.originMethodName;
    }

    public Class<?> getAnnotationClass() {
        return this.annotationClass;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Method getGuard() {
        return this.guard;
    }

    public int getOrder() {
        return this.order;
    }

    public SnippetCode getCode() {
        return this.code;
    }

    @Override
    public int compareTo(Snippet o) {
        return o.getOrder() - this.order;
    }

    public void init(LocalVars allLVs, Map<Type, Proc> processors, boolean exceptHandler, boolean useDynamicBypass) throws StaticContextGenException, ReflectionException, ProcessorException {
        this.code = this.unprocessedCode.process(allLVs, processors, this.marker, exceptHandler, useDynamicBypass);
        this.unprocessedCode = null;
    }
}

