/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.scope;

import ch.usi.dag.disl.exception.ScopeParserException;
import ch.usi.dag.disl.scope.Scope;
import ch.usi.dag.disl.scope.WildCard;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.Type;

public class ScopeImpl
implements Scope {
    private final String PARAM_BEGIN = "(";
    private final String PARAM_END = ")";
    private final String PARAM_DELIM = ",";
    private final String METHOD_DELIM = ".";
    private final String PARAM_MATCH_REST = "..";
    private final String DEFAULT_PKG = "[default]";
    private final String RETURN_DELIM = " ";
    private String classWildCard;
    private String methodWildCard;
    private String returnWildCard;
    private List<String> paramsWildCard;

    private int lastWhitespace(String where) {
        char[] whereCharArray = where.toCharArray();
        for (int i = whereCharArray.length - 1; i >= 0; --i) {
            if (!Character.isWhitespace(whereCharArray[i])) continue;
            return i;
        }
        return -1;
    }

    private boolean containsWhiteSpace(String toCheck) {
        for (char c : toCheck.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    public ScopeImpl(String scopeExpression) throws ScopeParserException {
        int methodDelim;
        String restOfExpr = scopeExpression;
        int paramBegin = restOfExpr.lastIndexOf("(");
        if (paramBegin != -1) {
            int pmrIndex;
            String paramsStr = restOfExpr.substring(paramBegin + 1);
            restOfExpr = restOfExpr.substring(0, paramBegin);
            if (!(paramsStr = paramsStr.trim()).endsWith(")")) {
                throw new ScopeParserException("Scope \"" + scopeExpression + "\" should end with \"" + ")" + "\"");
            }
            int paramEnd = paramsStr.lastIndexOf(")");
            paramsStr = paramsStr.substring(0, paramEnd);
            this.paramsWildCard = new LinkedList<String>();
            if (!paramsStr.trim().isEmpty()) {
                String[] params = paramsStr.split(",");
                for (String param : Arrays.asList(params)) {
                    if ((param = param.trim()).isEmpty()) {
                        throw new ScopeParserException("Scope \"" + scopeExpression + "\" has bad parameter definition");
                    }
                    this.paramsWildCard.add(param);
                }
            }
            if ((pmrIndex = this.paramsWildCard.indexOf("..")) != -1 && pmrIndex != this.paramsWildCard.size() - 1) {
                throw new ScopeParserException("Scope \"" + scopeExpression + "\" should have \"" + ".." + "\"" + " only as last parameter");
            }
        }
        String returnExpr = "";
        if (restOfExpr.split(" ").length == 2) {
            returnExpr = restOfExpr.split(" ", 2)[0];
            restOfExpr = restOfExpr.split(" ", 2)[1];
        }
        if ((methodDelim = restOfExpr.lastIndexOf(".")) != -1) {
            this.methodWildCard = restOfExpr.substring(methodDelim + 1);
            restOfExpr = restOfExpr.substring(0, methodDelim);
        } else {
            this.methodWildCard = restOfExpr;
            restOfExpr = null;
        }
        this.methodWildCard = this.methodWildCard.trim();
        if (this.methodWildCard.isEmpty()) {
            throw new ScopeParserException("Scope \"" + scopeExpression + "\" should have defined method at least as \"*\"");
        }
        if (restOfExpr != null && !(restOfExpr = restOfExpr.trim()).isEmpty()) {
            int classDelim = this.lastWhitespace(restOfExpr);
            if (classDelim != -1) {
                this.classWildCard = restOfExpr.substring(classDelim + 1);
                restOfExpr = restOfExpr.substring(0, classDelim);
            } else {
                this.classWildCard = restOfExpr;
                restOfExpr = null;
            }
            if (this.classWildCard.indexOf(46) == -1 && !this.classWildCard.startsWith("*")) {
                this.classWildCard = "*." + this.classWildCard;
            }
        }
        if ((restOfExpr = returnExpr) != null && !(restOfExpr = restOfExpr.trim()).isEmpty()) {
            if (this.containsWhiteSpace(restOfExpr)) {
                throw new ScopeParserException("Cannot parse scope \"" + scopeExpression + "\"");
            }
            this.returnWildCard = restOfExpr;
        }
    }

    private static void write(String className, String methodName, String methodDesc) {
    }

    public boolean matches(String className, String methodName, String methodDesc) {
        Type returnType;
        String typeName;
        if ((className = className.replace('/', '.')).indexOf(46) == -1) {
            className = "[default]." + className;
        }
        if (this.classWildCard != null && !WildCard.match(className, this.classWildCard)) {
            return false;
        }
        if (this.methodWildCard != null && !WildCard.match(methodName, this.methodWildCard)) {
            return false;
        }
        if (this.paramsWildCard != null) {
            String paramWC;
            Type[] parameters = Type.getArgumentTypes(methodDesc);
            String lastParamWC = null;
            if (!this.paramsWildCard.isEmpty()) {
                lastParamWC = this.paramsWildCard.get(this.paramsWildCard.size() - 1);
            }
            if (!"..".equals(lastParamWC) && parameters.length != this.paramsWildCard.size()) {
                return false;
            }
            if ("..".equals(lastParamWC) && parameters.length < this.paramsWildCard.size() - 1) {
                return false;
            }
            for (int i = 0; i < parameters.length && !(paramWC = this.paramsWildCard.get(i)).equals(".."); ++i) {
                String typeName2 = parameters[i].getClassName();
                if (WildCard.match(typeName2, paramWC)) continue;
                return false;
            }
        }
        return this.returnWildCard == null || WildCard.match(typeName = (returnType = Type.getReturnType(methodDesc)).getClassName(), this.returnWildCard);
    }

    public String toString() {
        String p = "";
        if (this.paramsWildCard != null) {
            p = p + "(";
            for (String s : this.paramsWildCard) {
                p = p + s + ", ";
            }
            if (p.length() > 1) {
                p = p.substring(0, p.length() - 2);
            }
            p = p + ")";
        }
        return String.format("r=%s c=%s m=%s p=%s", this.returnWildCard, this.classWildCard, this.methodWildCard, p);
    }
}

