/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.resolver;

import ch.usi.dag.disl.exception.GuardException;
import ch.usi.dag.disl.resolver.GuardMethod;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuardResolver {
    private static GuardResolver instance = null;
    private Map<Class<?>, GuardMethod> guardToMethod = new HashMap();

    public synchronized GuardMethod getGuardMethod(Class<?> guardClass) throws GuardException {
        GuardMethod guardMethod = this.guardToMethod.get(guardClass);
        if (guardMethod != null) {
            return guardMethod;
        }
        for (Method method : guardClass.getMethods()) {
            if (!method.isAnnotationPresent(ch.usi.dag.disl.annotation.GuardMethod.class)) continue;
            if (guardMethod != null) {
                throw new GuardException("Detected several " + GuardMethod.class.getName() + " annotations on guard class " + guardClass.getName());
            }
            guardMethod = new GuardMethod(method);
        }
        if (guardMethod == null) {
            throw new GuardException("No " + ch.usi.dag.disl.annotation.GuardMethod.class.getName() + " annotation on some public method in guard class " + guardClass.getName());
        }
        guardMethod.getMethod().setAccessible(true);
        this.guardToMethod.put(guardClass, guardMethod);
        return guardMethod;
    }

    public static synchronized GuardResolver getInstance() {
        if (instance == null) {
            instance = new GuardResolver();
        }
        return instance;
    }
}

