/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.marker;

import ch.usi.dag.disl.exception.MarkerException;
import ch.usi.dag.disl.marker.AbstractInsnMarker;
import ch.usi.dag.disl.marker.Parameter;
import ch.usi.dag.disl.util.AsmOpcodes;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrictBytecodeMarker
extends AbstractInsnMarker {
    protected Set<Integer> searchedInstrNums = new HashSet<Integer>();

    public StrictBytecodeMarker(Parameter param) throws MarkerException {
        for (String instr : param.getMultipleValues()) {
            try {
                AsmOpcodes opcode = AsmOpcodes.valueOf(instr.trim().toUpperCase());
                this.searchedInstrNums.add(opcode.getNumber());
            }
            catch (IllegalArgumentException e) {
                throw new MarkerException("Instruction \"" + instr + "\" cannot be found. See " + AsmOpcodes.class.getName() + " enum for list of possible instructions");
            }
        }
        if (this.searchedInstrNums.isEmpty()) {
            throw new MarkerException("Bytecode marker cannot operate without selected instructions. Pass instruction list using \"param\" annotation attribute.");
        }
    }

    @Override
    public List<AbstractInsnNode> markInstruction(MethodNode method) {
        LinkedList<AbstractInsnNode> seleted = new LinkedList<AbstractInsnNode>();
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (!this.searchedInstrNums.contains(instruction.getOpcode())) continue;
            seleted.add(instruction);
        }
        return seleted;
    }
}

