/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.marker;

import ch.usi.dag.disl.exception.MarkerException;
import ch.usi.dag.disl.marker.AbstractInsnMarker;
import ch.usi.dag.disl.marker.Parameter;
import ch.usi.dag.disl.util.AsmHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsnNodeMarker
extends AbstractInsnMarker {
    protected Set<Class<? extends AbstractInsnNode>> classes = new HashSet<Class<? extends AbstractInsnNode>>();

    public InsnNodeMarker(Parameter param) throws MarkerException {
        for (String className : param.getMultipleValues()) {
            try {
                Class<?> clazz = Class.forName(className);
                this.classes.add(clazz.asSubclass(AbstractInsnNode.class));
            }
            catch (ClassNotFoundException e) {
                throw new MarkerException("Instruction Node Class \"" + className + "\" cannot be found.");
            }
            catch (ClassCastException e) {
                throw new MarkerException("Class \"" + className + "\" is not an instruction node class.");
            }
        }
        if (this.classes.isEmpty()) {
            throw new MarkerException("Instruction node class should be passed as a parameter.");
        }
    }

    @Override
    public List<AbstractInsnNode> markInstruction(MethodNode methodNode) {
        LinkedList<AbstractInsnNode> seleted = new LinkedList<AbstractInsnNode>();
        for (AbstractInsnNode instr : AsmHelper.allInsnsFrom(methodNode.instructions)) {
            for (Class<? extends AbstractInsnNode> clazz : this.classes) {
                if (!clazz.isInstance(instr)) continue;
                seleted.add(instr);
            }
        }
        return seleted;
    }
}

