/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.marker;

import ch.usi.dag.disl.exception.MarkerException;
import ch.usi.dag.disl.marker.AbstractDWRMarker;
import ch.usi.dag.disl.marker.AbstractMarker;
import ch.usi.dag.disl.marker.Parameter;
import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.AsmOpcodes;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeMarker
extends AbstractDWRMarker {
    protected static final String INSTR_DELIM = ",";
    protected Set<Integer> searchedInstrNums = new HashSet<Integer>();

    public BytecodeMarker(Parameter param) throws MarkerException {
        param.setMultipleValDelim(INSTR_DELIM);
        for (String instr : param.getMultipleValues()) {
            try {
                AsmOpcodes opcode = AsmOpcodes.valueOf(instr.trim().toUpperCase());
                this.searchedInstrNums.add(opcode.getNumber());
            }
            catch (IllegalArgumentException e) {
                throw new MarkerException("Instruction \"" + instr + "\" cannot be found. See " + AsmOpcodes.class.getName() + " enum for list of possible instructions");
            }
        }
        if (this.searchedInstrNums.isEmpty()) {
            throw new MarkerException("Bytecode marker cannot operate without selected instructions. Pass instruction list using \"param\" annotation attribute.");
        }
    }

    @Override
    public List<AbstractMarker.MarkedRegion> markWithDefaultWeavingReg(MethodNode method) {
        LinkedList<AbstractMarker.MarkedRegion> regions = new LinkedList<AbstractMarker.MarkedRegion>();
        for (AbstractInsnNode instruction : AsmHelper.allInsnsFrom(method.instructions)) {
            if (!this.searchedInstrNums.contains(instruction.getOpcode())) continue;
            regions.add(new AbstractMarker.MarkedRegion(instruction, instruction));
        }
        return regions;
    }
}

