/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.classparser;

import ch.usi.dag.disl.annotation.After;
import ch.usi.dag.disl.annotation.AfterReturning;
import ch.usi.dag.disl.annotation.AfterThrowing;
import ch.usi.dag.disl.annotation.Before;
import ch.usi.dag.disl.classcontext.ClassContext;
import ch.usi.dag.disl.classparser.AbstractParser;
import ch.usi.dag.disl.classparser.ParserHelper;
import ch.usi.dag.disl.dynamiccontext.DynamicContext;
import ch.usi.dag.disl.exception.DiSLFatalException;
import ch.usi.dag.disl.exception.GuardException;
import ch.usi.dag.disl.exception.MarkerException;
import ch.usi.dag.disl.exception.ParserException;
import ch.usi.dag.disl.exception.ReflectionException;
import ch.usi.dag.disl.exception.ScopeParserException;
import ch.usi.dag.disl.exception.SnippetParserException;
import ch.usi.dag.disl.exception.StaticContextGenException;
import ch.usi.dag.disl.guard.GuardHelper;
import ch.usi.dag.disl.marker.Marker;
import ch.usi.dag.disl.marker.Parameter;
import ch.usi.dag.disl.processorcontext.ArgumentProcessorContext;
import ch.usi.dag.disl.scope.ScopeImpl;
import ch.usi.dag.disl.snippet.Snippet;
import ch.usi.dag.disl.snippet.SnippetUnprocessedCode;
import ch.usi.dag.disl.staticcontext.StaticContext;
import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SnippetParser
extends AbstractParser {
    private List<Snippet> snippets = new LinkedList<Snippet>();

    SnippetParser() {
    }

    public List<Snippet> getSnippets() {
        return this.snippets;
    }

    public void parse(ClassNode classNode) throws ParserException, SnippetParserException, ReflectionException, ScopeParserException, StaticContextGenException, MarkerException, GuardException {
        this.processLocalVars(classNode);
        for (MethodNode method : classNode.methods) {
            if (method.name.equals("<init>") || method.name.equals("<clinit>")) continue;
            this.snippets.add(this.parseSnippet(classNode.name, method));
        }
    }

    private Snippet parseSnippet(String className, MethodNode method) throws SnippetParserException, ReflectionException, ScopeParserException, StaticContextGenException, MarkerException, GuardException, ParserException {
        if (method.invisibleAnnotations == null) {
            throw new SnippetParserException("DiSL anottation for method " + className + "." + method.name + " is missing");
        }
        if (method.invisibleAnnotations.size() > 1) {
            throw new SnippetParserException("Method " + className + "." + method.name + " can have only one DiSL anottation");
        }
        if ((method.access & 8) == 0) {
            throw new SnippetParserException("Method " + className + "." + method.name + " should be declared as static");
        }
        if (!Type.getReturnType(method.desc).equals(Type.VOID_TYPE)) {
            throw new SnippetParserException("Method " + className + "." + method.name + " cannot return value");
        }
        if (!method.exceptions.isEmpty()) {
            throw new SnippetParserException("Method " + className + "." + method.name + " cannot throw any exception");
        }
        AnnotationNode annotation = method.invisibleAnnotations.get(0);
        SnippetAnnotationData annotData = this.parseMethodAnnotation(className + "." + method.name, annotation);
        Marker marker = this.getMarker(annotData.marker, annotData.args);
        ScopeImpl scope = new ScopeImpl(annotData.scope);
        Class<?> guardClass = ParserHelper.getGuard(annotData.guard);
        Method guardMethod = GuardHelper.findAndValidateGuardMethod(guardClass, GuardHelper.snippetContextSet());
        Contexts context = this.parseUsedContexts(method.desc);
        if (AsmHelper.containsOnlyReturn(method.instructions)) {
            throw new SnippetParserException("Method " + className + "." + method.name + " cannot be empty");
        }
        ParserHelper.usesContextProperly(className, method.name, method.desc, method.instructions);
        SnippetUnprocessedCode uscd = new SnippetUnprocessedCode(className, method.name, method.instructions, method.tryCatchBlocks, context.getStaticContexts(), context.usesDynamicContext(), annotData.dynamicBypass, context.usesClassContext(), context.usesProcessorContext());
        return new Snippet(className, method.name, annotData.type, marker, scope, guardMethod, annotData.order, uscd);
    }

    private SnippetAnnotationData parseMethodAnnotation(String fullMethodName, AnnotationNode annotation) throws SnippetParserException {
        Type annotationType = Type.getType(annotation.desc);
        if (annotationType.equals(Type.getType(After.class))) {
            return this.parseMethodAnnotFields(After.class, annotation);
        }
        if (annotationType.equals(Type.getType(AfterReturning.class))) {
            return this.parseMethodAnnotFields(AfterReturning.class, annotation);
        }
        if (annotationType.equals(Type.getType(AfterThrowing.class))) {
            return this.parseMethodAnnotFields(AfterThrowing.class, annotation);
        }
        if (annotationType.equals(Type.getType(Before.class))) {
            return this.parseMethodAnnotFields(Before.class, annotation);
        }
        throw new SnippetParserException("Method " + fullMethodName + " has unsupported DiSL annotation");
    }

    private SnippetAnnotationData parseMethodAnnotFields(Class<?> type, AnnotationNode annotation) {
        SnippetAnnotationData sad = new SnippetAnnotationData(type);
        ParserHelper.parseAnnotation(sad, annotation);
        if (sad.marker == null) {
            throw new DiSLFatalException("Missing attribute in annotation " + type.toString() + ". This may happen if annotation class is changed but" + " data holder class is not.");
        }
        return sad;
    }

    private Marker getMarker(Type markerType, String markerParam) throws ReflectionException, MarkerException {
        Class<?> genMarkerClass = ReflectionHelper.resolveClass(markerType);
        Class<Marker> markerClass = genMarkerClass.asSubclass(Marker.class);
        if (markerParam == null) {
            try {
                return ReflectionHelper.createInstance(markerClass, new Object[0]);
            }
            catch (ReflectionException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    throw new MarkerException("Marker " + markerClass.getName() + " requires \"param\" annotation attribute" + " declared", e);
                }
                throw e;
            }
        }
        try {
            return ReflectionHelper.createInstance(markerClass, new Parameter(markerParam));
        }
        catch (ReflectionException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                throw new MarkerException("Marker " + markerClass.getName() + " does not support \"param\" attribute", e);
            }
            throw e;
        }
    }

    private Contexts parseUsedContexts(String methodDesc) throws ReflectionException, StaticContextGenException {
        HashSet<String> knownStCo = new HashSet<String>();
        boolean usesDynamicContext = false;
        boolean usesClassContext = false;
        boolean usesArgProcContext = false;
        for (Type argType : Type.getArgumentTypes(methodDesc)) {
            if (argType.equals(Type.getType(DynamicContext.class))) {
                usesDynamicContext = true;
                continue;
            }
            if (argType.equals(Type.getType(ClassContext.class))) {
                usesClassContext = true;
                continue;
            }
            if (argType.equals(Type.getType(ArgumentProcessorContext.class))) {
                usesArgProcContext = true;
                continue;
            }
            Class<?> argClass = ReflectionHelper.resolveClass(argType);
            if (!ReflectionHelper.implementsInterface(argClass, StaticContext.class)) {
                throw new StaticContextGenException(argClass.getName() + " does not implement StaticContext interface and" + " cannot be used as snippet method parameter");
            }
            knownStCo.add(argType.getInternalName());
        }
        return new Contexts(knownStCo, usesDynamicContext, usesClassContext, usesArgProcContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Contexts {
        private Set<String> staticContexts;
        private boolean usesDynamicContext;
        private boolean usesClassContext;
        private boolean usesProcessorContext;

        public Contexts(Set<String> staticContexts, boolean usesDynamicContext, boolean usesClassContext, boolean usesProcessorContext) {
            this.staticContexts = staticContexts;
            this.usesDynamicContext = usesDynamicContext;
            this.usesClassContext = usesClassContext;
            this.usesProcessorContext = usesProcessorContext;
        }

        public Set<String> getStaticContexts() {
            return this.staticContexts;
        }

        public boolean usesDynamicContext() {
            return this.usesDynamicContext;
        }

        public boolean usesClassContext() {
            return this.usesClassContext;
        }

        public boolean usesProcessorContext() {
            return this.usesProcessorContext;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SnippetAnnotationData {
        public Class<?> type;
        public Type marker = null;
        public String args = null;
        public String scope = "*";
        public Type guard = null;
        public int order = 100;
        public boolean dynamicBypass = true;

        public SnippetAnnotationData(Class<?> type) {
            this.type = type;
        }
    }
}

