/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.classparser;

import ch.usi.dag.disl.annotation.Guarded;
import ch.usi.dag.disl.annotation.ProcessAlso;
import ch.usi.dag.disl.classcontext.ClassContext;
import ch.usi.dag.disl.classparser.AbstractParser;
import ch.usi.dag.disl.classparser.ParserHelper;
import ch.usi.dag.disl.dynamiccontext.DynamicContext;
import ch.usi.dag.disl.exception.DiSLFatalException;
import ch.usi.dag.disl.exception.GuardException;
import ch.usi.dag.disl.exception.ParserException;
import ch.usi.dag.disl.exception.ProcessorParserException;
import ch.usi.dag.disl.exception.ReflectionException;
import ch.usi.dag.disl.exception.StaticContextGenException;
import ch.usi.dag.disl.guard.GuardHelper;
import ch.usi.dag.disl.processor.Proc;
import ch.usi.dag.disl.processor.ProcArgType;
import ch.usi.dag.disl.processor.ProcMethod;
import ch.usi.dag.disl.processor.ProcUnprocessedCode;
import ch.usi.dag.disl.processorcontext.ArgumentContext;
import ch.usi.dag.disl.staticcontext.StaticContext;
import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessorParser
extends AbstractParser {
    private Map<Type, Proc> processors = new HashMap<Type, Proc>();

    ProcessorParser() {
    }

    public Map<Type, Proc> getProcessors() {
        return this.processors;
    }

    public void parse(ClassNode classNode) throws ParserException, ProcessorParserException, ReflectionException, StaticContextGenException, GuardException {
        this.processLocalVars(classNode);
        LinkedList<ProcMethod> methods = new LinkedList<ProcMethod>();
        for (MethodNode method : classNode.methods) {
            if (method.name.equals("<init>") || method.name.equals("<clinit>")) continue;
            methods.add(this.parseProcessorMethod(classNode.name, method));
        }
        if (methods.isEmpty()) {
            throw new ProcessorParserException("ArgumentProcessor class " + classNode.name + " should contain methods");
        }
        Type processorClassType = Type.getType("L" + classNode.name + ";");
        this.processors.put(processorClassType, new Proc(classNode.name, methods));
    }

    private ProcMethod parseProcessorMethod(String className, MethodNode method) throws ProcessorParserException, ReflectionException, StaticContextGenException, GuardException, ParserException {
        String fullMethodName = className + "." + method.name;
        if ((method.access & 8) == 0) {
            throw new ProcessorParserException("Method " + fullMethodName + " should be declared as static");
        }
        if (!Type.getReturnType(method.desc).equals(Type.VOID_TYPE)) {
            throw new ProcessorParserException("Method " + fullMethodName + " cannot return value");
        }
        if (AsmHelper.containsOnlyReturn(method.instructions)) {
            throw new ProcessorParserException("Method " + fullMethodName + " cannot be empty");
        }
        if (!method.exceptions.isEmpty()) {
            throw new ProcessorParserException("Method " + fullMethodName + " cannot throw any exception");
        }
        PMArgData pmArgData = this.parseProcMethodArgs(className + "." + method.name, method.desc);
        EnumSet<ProcArgType> allProcessedTypes = EnumSet.of(pmArgData.getType());
        ProcMethodAnnotationsData pmad = this.parseMethodAnnotations(fullMethodName, method.invisibleAnnotations);
        this.checkProcessAlsoSetValidity(fullMethodName, pmArgData.getType(), pmad.processAlsoTypes);
        allProcessedTypes.addAll(pmad.processAlsoTypes);
        Class<?> guardClass = ParserHelper.getGuard(pmad.guard);
        Method guardMethod = GuardHelper.findAndValidateGuardMethod(guardClass, GuardHelper.processorContextSet());
        if (AsmHelper.containsOnlyReturn(method.instructions)) {
            throw new ProcessorParserException("Method " + className + "." + method.name + " cannot be empty");
        }
        ParserHelper.usesContextProperly(className, method.name, method.desc, method.instructions);
        ProcUnprocessedCode ucd = new ProcUnprocessedCode(method.instructions, method.tryCatchBlocks, pmArgData.getStaticContexts(), pmArgData.usesDynamicContext(), pmArgData.usesClassContext(), pmArgData.usesArgumentContext());
        return new ProcMethod(className, method.name, allProcessedTypes, guardMethod, ucd);
    }

    private PMArgData parseProcMethodArgs(String methodID, String methodDesc) throws ProcessorParserException, StaticContextGenException, ReflectionException {
        Type[] argTypes = Type.getArgumentTypes(methodDesc);
        ProcArgType procArgType = ProcArgType.valueOf(argTypes[0]);
        if (procArgType == ProcArgType.OBJECT && !Type.getType(Object.class).equals(argTypes[0])) {
            throw new ProcessorParserException("In method " + methodID + ": " + "Only basic types and Object are allowed as the" + " first (type) parameter");
        }
        HashSet<String> knownStCo = new HashSet<String>();
        boolean usesDynamicContext = false;
        boolean usesClassContext = false;
        boolean usesArgumentContext = false;
        for (int i = 1; i < argTypes.length; ++i) {
            Type argType = argTypes[i];
            if (argType.equals(Type.getType(DynamicContext.class))) {
                usesDynamicContext = true;
                continue;
            }
            if (argType.equals(Type.getType(ClassContext.class))) {
                usesClassContext = true;
                continue;
            }
            if (argType.equals(Type.getType(ArgumentContext.class))) {
                usesArgumentContext = true;
                continue;
            }
            Class<?> argClass = ReflectionHelper.resolveClass(argType);
            if (!ReflectionHelper.implementsInterface(argClass, StaticContext.class)) {
                throw new StaticContextGenException(argClass.getName() + " does not implement StaticContext interface and" + " cannot be used as snippet method parameter");
            }
            knownStCo.add(argType.getInternalName());
        }
        return new PMArgData(procArgType, knownStCo, usesDynamicContext, usesClassContext, usesArgumentContext);
    }

    private ProcMethodAnnotationsData parseMethodAnnotations(String fullMethodName, List<AnnotationNode> invisibleAnnotations) throws ProcessorParserException {
        ProcMethodAnnotationsData pmad = new ProcMethodAnnotationsData();
        if (invisibleAnnotations == null) {
            return pmad;
        }
        for (AnnotationNode annotation : invisibleAnnotations) {
            Type annotationType = Type.getType(annotation.desc);
            if (annotationType.equals(Type.getType(Guarded.class))) {
                this.parseGuardedAnnotation(pmad, annotation);
                continue;
            }
            if (annotationType.equals(Type.getType(ProcessAlso.class))) {
                this.parseProcessAlsoAnnotation(pmad, annotation);
                continue;
            }
            throw new ProcessorParserException("Method " + fullMethodName + " has unsupported DiSL annotation");
        }
        return pmad;
    }

    private void parseGuardedAnnotation(ProcMethodAnnotationsData pmad, AnnotationNode annotation) {
        ParserHelper.parseAnnotation(pmad, annotation);
        if (pmad.guard == null) {
            throw new DiSLFatalException("Missing attribute in annotation " + Type.getType(annotation.desc).toString() + ". This may happen if annotation class is changed but" + " data holder class is not.");
        }
    }

    private void parseProcessAlsoAnnotation(ProcMethodAnnotationsData pmad, AnnotationNode annotation) {
        ProcessAlsoAnnotationData paData = new ProcessAlsoAnnotationData();
        ParserHelper.parseAnnotation(paData, annotation);
        if (paData.types == null) {
            throw new DiSLFatalException("Missing attribute in annotation " + Type.getType(annotation.desc).toString() + ". This may happen if annotation class is changed but" + " data holder class is not.");
        }
        for (String[] enumType : paData.types) {
            ProcessAlso.Type paType = ProcessAlso.Type.valueOf(enumType[1]);
            pmad.processAlsoTypes.add(ProcArgType.valueOf(paType));
        }
    }

    private void checkProcessAlsoSetValidity(String fullMethodName, ProcArgType methodArgType, EnumSet<ProcArgType> processAlsoTypes) throws ProcessorParserException {
        EnumSet<ProcArgType> validSet;
        switch (methodArgType) {
            case INT: {
                validSet = EnumSet.of(ProcArgType.BOOLEAN, ProcArgType.BYTE, ProcArgType.SHORT);
                break;
            }
            case SHORT: {
                validSet = EnumSet.of(ProcArgType.BOOLEAN, ProcArgType.BYTE);
                break;
            }
            case BYTE: {
                validSet = EnumSet.of(ProcArgType.BOOLEAN);
                break;
            }
            default: {
                validSet = EnumSet.noneOf(ProcArgType.class);
            }
        }
        Object nonValidTypes = processAlsoTypes.clone();
        ((AbstractSet)nonValidTypes).removeAll(validSet);
        if (!((AbstractCollection)nonValidTypes).isEmpty()) {
            StringBuilder strNonValidTypes = new StringBuilder();
            String STR_DELIM = ", ";
            Iterator i$ = ((AbstractCollection)nonValidTypes).iterator();
            while (i$.hasNext()) {
                ProcArgType paType = (ProcArgType)((Object)i$.next());
                strNonValidTypes.append(paType.toString() + ", ");
            }
            int delimSize = ", ".length();
            strNonValidTypes.delete(strNonValidTypes.length() - delimSize, strNonValidTypes.length());
            throw new ProcessorParserException(methodArgType.toString() + " processor in method " + fullMethodName + " cannot process " + strNonValidTypes.toString());
        }
    }

    private static class ProcessAlsoAnnotationData {
        public Collection<String[]> types = null;

        private ProcessAlsoAnnotationData() {
        }
    }

    private static class ProcMethodAnnotationsData {
        public EnumSet<ProcArgType> processAlsoTypes = EnumSet.noneOf(ProcArgType.class);
        public Type guard = null;

        private ProcMethodAnnotationsData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PMArgData {
        private ProcArgType type;
        private Set<String> staticContexts;
        private boolean usesDynamicContext;
        private boolean usesClassContext;
        private boolean usesArgumentContext;

        public PMArgData(ProcArgType type, Set<String> staticContexts, boolean usesDynamicContext, boolean usesClassContext, boolean usesArgumentContext) {
            this.type = type;
            this.staticContexts = staticContexts;
            this.usesDynamicContext = usesDynamicContext;
            this.usesClassContext = usesClassContext;
            this.usesArgumentContext = usesArgumentContext;
        }

        public ProcArgType getType() {
            return this.type;
        }

        public Set<String> getStaticContexts() {
            return this.staticContexts;
        }

        public boolean usesDynamicContext() {
            return this.usesDynamicContext;
        }

        public boolean usesClassContext() {
            return this.usesClassContext;
        }

        public boolean usesArgumentContext() {
            return this.usesArgumentContext;
        }
    }
}

