/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.classparser;

import ch.usi.dag.disl.exception.DiSLFatalException;
import ch.usi.dag.disl.exception.ParserException;
import ch.usi.dag.disl.exception.ReflectionException;
import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Iterator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ParserHelper {
    ParserHelper() {
    }

    public static Class<?> getGuard(Type guardType) throws ReflectionException {
        if (guardType == null) {
            return null;
        }
        return ReflectionHelper.resolveClass(guardType);
    }

    public static <T> void parseAnnotation(T parsedDataObject, AnnotationNode annotation) {
        try {
            if (annotation.values == null) {
                return;
            }
            Iterator<Object> it = annotation.values.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Field attr = parsedDataObject.getClass().getField(name);
                if (attr == null) {
                    throw new DiSLFatalException("Unknow attribute " + name + " in annotation " + Type.getType(annotation.desc).toString() + ". This may happen if annotation class is changed" + "  but parser class is not.");
                }
                attr.set(parsedDataObject, it.next());
            }
        }
        catch (Exception e) {
            throw new DiSLFatalException("Reflection error wihle parsing annotation", e);
        }
    }

    public static void usesContextProperly(String className, String methodName, String methodDescriptor, InsnList instructions) throws ParserException {
        Type[] types = Type.getArgumentTypes(methodDescriptor);
        int maxArgIndex = 0;
        for (int i = 0; i < types.length; ++i) {
            maxArgIndex += types[i].getSize();
        }
        for (AbstractInsnNode instr : AsmHelper.allInsnsFrom(instructions)) {
            switch (instr.getOpcode()) {
                case 25: {
                    int local = ((VarInsnNode)instr).var;
                    if (local >= maxArgIndex || instr.getNext().getOpcode() != 58) break;
                    throw new ParserException("In method " + className + "." + methodName + " - method parameter" + " (context) cannot be stored into local" + " variable");
                }
                case 58: {
                    int local = ((VarInsnNode)instr).var;
                    if (local >= maxArgIndex) break;
                    throw new ParserException("In method " + className + "." + methodName + " - method parameter" + " (context) cannot be overwritten");
                }
            }
        }
    }
}

