/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.classparser;

import ch.usi.dag.disl.annotation.ArgumentProcessor;
import ch.usi.dag.disl.classparser.ProcessorParser;
import ch.usi.dag.disl.classparser.SnippetParser;
import ch.usi.dag.disl.exception.GuardException;
import ch.usi.dag.disl.exception.MarkerException;
import ch.usi.dag.disl.exception.ParserException;
import ch.usi.dag.disl.exception.ProcessorParserException;
import ch.usi.dag.disl.exception.ReflectionException;
import ch.usi.dag.disl.exception.ScopeParserException;
import ch.usi.dag.disl.exception.SnippetParserException;
import ch.usi.dag.disl.exception.StaticContextGenException;
import ch.usi.dag.disl.localvar.LocalVars;
import ch.usi.dag.disl.processor.Proc;
import ch.usi.dag.disl.snippet.Snippet;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassParser {
    SnippetParser snippetParser = new SnippetParser();
    ProcessorParser processorParser = new ProcessorParser();

    public void parse(InputStream is) throws ParserException, SnippetParserException, ReflectionException, ScopeParserException, StaticContextGenException, ProcessorParserException, MarkerException, GuardException {
        ClassReader cr;
        try {
            cr = new ClassReader(is);
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
        ClassNode classNode = new ClassNode();
        cr.accept(classNode, 6);
        if (classNode.invisibleAnnotations == null) {
            this.snippetParser.parse(classNode);
            return;
        }
        if (classNode.invisibleAnnotations.size() > 1) {
            throw new ParserException("Class " + classNode.name + " may have only one anotation");
        }
        AnnotationNode annotation = classNode.invisibleAnnotations.get(0);
        Type annotationType = Type.getType(annotation.desc);
        if (!annotationType.equals(Type.getType(ArgumentProcessor.class))) {
            throw new ParserException("Class " + classNode.name + " may have only ArgumentProcessor anotation");
        }
        this.processorParser.parse(classNode);
    }

    public LocalVars getAllLocalVars() {
        LocalVars merged = new LocalVars();
        merged.putAll(this.snippetParser.getAllLocalVars());
        merged.putAll(this.processorParser.getAllLocalVars());
        return merged;
    }

    public List<Snippet> getSnippets() {
        return this.snippetParser.getSnippets();
    }

    public Map<Type, Proc> getProcessors() {
        return this.processorParser.getProcessors();
    }
}

