/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.cbloader;

import ch.usi.dag.disl.exception.ManifestInfoException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestHelper {
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    public static final String ATTR_DISL_CLASSES = "DiSL-Classes";
    public static final String ATTR_DISL_TRANSFORMER = "DiSL-Transformer";
    private static ManifestInfo cachedMI = null;
    private static boolean cacheValid = false;

    public static ManifestInfo getDiSLManifestInfo() throws ManifestInfoException {
        if (!cacheValid) {
            cachedMI = ManifestHelper.resolveDiSLManifestInfo();
            cacheValid = true;
        }
        return cachedMI;
    }

    private static ManifestInfo resolveDiSLManifestInfo() throws ManifestInfoException {
        try {
            ClassLoader cl = ManifestInfo.class.getClassLoader();
            Enumeration<URL> resources = cl.getResources(MANIFEST);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                Manifest manifest = new Manifest(resource.openStream());
                Attributes attrs = manifest.getMainAttributes();
                if (attrs == null) continue;
                String dislClasses = attrs.getValue(ATTR_DISL_CLASSES);
                String dislTrans = attrs.getValue(ATTR_DISL_TRANSFORMER);
                if (dislClasses == null) continue;
                return new ManifestInfo(resource, manifest, dislClasses, dislTrans);
            }
        }
        catch (IOException e) {
            throw new ManifestInfoException(e);
        }
        return null;
    }

    public static class ManifestInfo {
        private URL resource;
        private Manifest manifest;
        private String dislClasses;
        private String dislTransformer;

        public ManifestInfo(URL resource, Manifest manifest, String dislClasses, String dislTransformer) {
            this.resource = resource;
            this.manifest = manifest;
            this.dislClasses = dislClasses;
            this.dislTransformer = dislTransformer;
        }

        public URL getResource() {
            return this.resource;
        }

        public Manifest getManifest() {
            return this.manifest;
        }

        public String getDislClasses() {
            return this.dislClasses;
        }

        public String getDislTransformer() {
            return this.dislTransformer;
        }
    }
}

