/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl;

import ch.usi.dag.disl.ROClassWriter;
import ch.usi.dag.disl.cbloader.ClassByteLoader;
import ch.usi.dag.disl.cbloader.ManifestHelper;
import ch.usi.dag.disl.classparser.ClassParser;
import ch.usi.dag.disl.exception.DiSLException;
import ch.usi.dag.disl.exception.DiSLIOException;
import ch.usi.dag.disl.exception.DiSLInMethodException;
import ch.usi.dag.disl.exception.DynamicContextException;
import ch.usi.dag.disl.exception.InitException;
import ch.usi.dag.disl.exception.ManifestInfoException;
import ch.usi.dag.disl.exception.MarkerException;
import ch.usi.dag.disl.exception.ProcessorException;
import ch.usi.dag.disl.exception.ReflectionException;
import ch.usi.dag.disl.exception.StaticContextGenException;
import ch.usi.dag.disl.exception.TransformerException;
import ch.usi.dag.disl.exclusion.ExclusionSet;
import ch.usi.dag.disl.guard.GuardHelper;
import ch.usi.dag.disl.localvar.SyntheticLocalVar;
import ch.usi.dag.disl.localvar.ThreadLocalVar;
import ch.usi.dag.disl.processor.Proc;
import ch.usi.dag.disl.processor.generator.PIResolver;
import ch.usi.dag.disl.processor.generator.ProcGenerator;
import ch.usi.dag.disl.processor.generator.ProcInstance;
import ch.usi.dag.disl.processor.generator.ProcMethodInstance;
import ch.usi.dag.disl.scope.Scope;
import ch.usi.dag.disl.snippet.Shadow;
import ch.usi.dag.disl.snippet.Snippet;
import ch.usi.dag.disl.staticcontext.generator.SCGenerator;
import ch.usi.dag.disl.transformer.Transformer;
import ch.usi.dag.disl.utilinstr.codemerger.CodeMerger;
import ch.usi.dag.disl.utilinstr.tlvinserter.TLVInserter;
import ch.usi.dag.disl.weaver.Weaver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiSL {
    private static final String PROP_TRACE = "trace";
    public static final boolean trace = Boolean.getBoolean("trace");
    private static final String PROP_DEBUG = "debug";
    public static final boolean debug = trace || Boolean.getBoolean("debug");
    private final String PROP_NO_EXCEPT_HANDLER = "disl.noexcepthandler";
    private final boolean exceptHandler = !Boolean.getBoolean("disl.noexcepthandler");
    private final String PROP_SPLIT_LONG_METHODS = "disl.splitmethods";
    private final boolean splitLongMethods = Boolean.getBoolean("disl.splitmethods");
    private final boolean useDynamicBypass;
    private final Transformer transformer;
    private final boolean transPropagateUninstr;
    private final Set<Scope> exclusionSet;
    private final List<Snippet> snippets;

    public DiSL(boolean useDynamicBypass) throws DiSLException {
        this.useDynamicBypass = useDynamicBypass;
        this.transformer = this.resolveTransformer();
        this.transPropagateUninstr = this.transformer == null ? false : this.transformer.propagateUninstrumentedClasses();
        this.exclusionSet = ExclusionSet.prepare();
        List<InputStream> dislClasses = ClassByteLoader.loadDiSLClasses();
        if (dislClasses == null) {
            throw new InitException("Cannot load DiSL classes. Please set the property disl.classes or supply jar with DiSL classes and proper manifest");
        }
        ClassParser parser = new ClassParser();
        for (InputStream classIS : dislClasses) {
            parser.parse(classIS);
        }
        Map<Type, Proc> processors = parser.getProcessors();
        for (Proc processor : processors.values()) {
            processor.init(parser.getAllLocalVars());
        }
        List<Snippet> parsedSnippets = parser.getSnippets();
        for (Snippet snippet : parsedSnippets) {
            snippet.init(parser.getAllLocalVars(), processors, this.exceptHandler, useDynamicBypass);
        }
        this.snippets = parsedSnippets;
    }

    private Transformer resolveTransformer() throws ManifestInfoException, ReflectionException {
        ManifestHelper.ManifestInfo mi = ManifestHelper.getDiSLManifestInfo();
        if (mi == null) {
            return null;
        }
        String transformerClsName = mi.getDislTransformer();
        if (transformerClsName == null) {
            return null;
        }
        try {
            Class<?> transformerCls = Class.forName(transformerClsName);
            return (Transformer)transformerCls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("DiSL transformer " + transformerClsName + " cannot be resolved", e);
        }
        catch (InstantiationException e) {
            throw new ReflectionException("DiSL transformer " + transformerClsName + " cannot be instantiated", e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("DiSL transformer " + transformerClsName + " cannot be instantiated", e);
        }
        catch (ClassCastException e) {
            throw new ReflectionException("DiSL transformer " + transformerClsName + " does not implement Transformer interface", e);
        }
    }

    private boolean instrumentMethod(ClassNode classNode, MethodNode methodNode) throws ReflectionException, StaticContextGenException, ProcessorException, DynamicContextException, MarkerException {
        if ((methodNode.access & 0x400) != 0) {
            return false;
        }
        if ((methodNode.access & 0x100) != 0) {
            return false;
        }
        String className = classNode.name;
        String methodName = methodNode.name;
        String methodDesc = methodNode.desc;
        for (Scope exclScope : this.exclusionSet) {
            if (!exclScope.matches(className, methodName, methodDesc)) continue;
            this.__debug("DiSL: excluding method: %s.%s(%s)\n", className, methodName, methodDesc);
            return false;
        }
        LinkedList<Snippet> matchedSnippets = new LinkedList<Snippet>();
        for (Snippet snippet : this.snippets) {
            if (!snippet.getScope().matches(className, methodName, methodDesc)) continue;
            matchedSnippets.add(snippet);
        }
        if (matchedSnippets.isEmpty()) {
            this.__debug("DiSL: skipping unaffected method: %s.%s(%s)\n", className, methodName, methodDesc);
            return false;
        }
        this.__trace("DiSL: processing method: %s.%s(%s)\n", className, methodName, methodDesc);
        HashMap<Snippet, List<Shadow>> snippetMarkings = new HashMap<Snippet, List<Shadow>>();
        for (Snippet snippet : matchedSnippets) {
            this.__trace("DiSL:     snippet: %s.%s()\n", snippet.getOriginClassName(), snippet.getOriginMethodName());
            List<Shadow> shadows = snippet.getMarker().mark(classNode, methodNode, snippet);
            List<Shadow> selectedShadows = this.selectShadowsWithGuard(snippet.getGuard(), shadows);
            this.__trace("DiSL:         selected shadows: %d\n", selectedShadows.size());
            if (selectedShadows.isEmpty()) continue;
            snippetMarkings.put(snippet, selectedShadows);
        }
        SCGenerator staticInfo = new SCGenerator(snippetMarkings);
        HashSet<SyntheticLocalVar> usedSLVs = new HashSet<SyntheticLocalVar>();
        for (Snippet snippet : snippetMarkings.keySet()) {
            usedSLVs.addAll(snippet.getCode().getReferencedSLVs());
        }
        PIResolver piResolver = new ProcGenerator().compute(snippetMarkings);
        for (ProcInstance pi : piResolver.getAllProcInstances()) {
            for (ProcMethodInstance pmi : pi.getMethods()) {
                usedSLVs.addAll(pmi.getCode().getReferencedSLVs());
            }
        }
        this.__trace("DiSL:     snippet markings: %d\n", snippetMarkings.size());
        if (snippetMarkings.size() > 0) {
            this.__debug("DiSL: instrumenting method: %s.%s(%s)\n", className, methodName, methodDesc);
            Weaver.instrument(classNode, methodNode, snippetMarkings, new LinkedList<SyntheticLocalVar>(usedSLVs), staticInfo, piResolver);
            return true;
        }
        this.__debug("DiSL: skipping unaffected method: %s.%s(%s)\n", className, methodName, methodDesc);
        return false;
    }

    private List<Shadow> selectShadowsWithGuard(Method guard, List<Shadow> marking) {
        if (guard == null) {
            return marking;
        }
        LinkedList<Shadow> selectedMarking = new LinkedList<Shadow>();
        for (Shadow shadow : marking) {
            if (!GuardHelper.guardApplicable(guard, shadow)) continue;
            selectedMarking.add(shadow);
        }
        return selectedMarking;
    }

    private InstrumentedClass instrumentClass(ClassNode classNode) throws DiSLException {
        boolean classChanged = false;
        HashSet<String> changedMethods = new HashSet<String>();
        for (MethodNode methodNode : classNode.methods) {
            boolean methodChanged = false;
            try {
                methodChanged = this.instrumentMethod(classNode, methodNode);
            }
            catch (DiSLException e) {
                throw new DiSLInMethodException(classNode.name + "." + methodNode.name, e);
            }
            if (!methodChanged) continue;
            changedMethods.add(methodNode.name + methodNode.desc);
            classChanged = true;
        }
        if (Type.getInternalName(Thread.class).equals(classNode.name)) {
            HashSet<ThreadLocalVar> insertTLVs = new HashSet<ThreadLocalVar>();
            if (this.useDynamicBypass) {
                ThreadLocalVar tlv = new ThreadLocalVar(null, "bypass", Type.getType(Boolean.TYPE), false);
                tlv.setDefaultValue(0);
                insertTLVs.add(tlv);
            }
            for (Snippet snippet : this.snippets) {
                insertTLVs.addAll(snippet.getCode().getReferencedTLVs());
            }
            if (!insertTLVs.isEmpty()) {
                ClassNode cnWithFields = new ClassNode(262144);
                classNode.accept(new TLVInserter(cnWithFields, insertTLVs));
                classNode = cnWithFields;
                classChanged = true;
            }
        }
        if (classChanged) {
            return new InstrumentedClass(classNode, changedMethods);
        }
        return null;
    }

    public synchronized byte[] instrument(byte[] classAsBytes) throws DiSLException {
        if (debug) {
            this.__dumpClassToFile(classAsBytes, "err.class");
        }
        if (this.transformer != null) {
            try {
                classAsBytes = this.transformer.transform(classAsBytes);
            }
            catch (Exception e) {
                throw new TransformerException("Transformer error", e);
            }
        }
        ClassReader classReader = new ClassReader(classAsBytes);
        ClassNode classNode = new ClassNode(262144);
        classReader.accept(classNode, 8);
        InstrumentedClass instrClass = this.instrumentClass(classNode);
        if (instrClass == null) {
            if (this.transPropagateUninstr) {
                return classAsBytes;
            }
            return null;
        }
        ClassNode instrCN = instrClass.getClassNode();
        if (this.useDynamicBypass) {
            ClassReader origCR = new ClassReader(classAsBytes);
            ClassNode origCN = new ClassNode();
            origCR.accept(origCN, 8);
            instrCN = CodeMerger.mergeClasses(origCN, instrCN, instrClass.getChangedMethods(), this.splitLongMethods);
        }
        int REQUIRED_VERSION = 49;
        int MAJOR_V_MASK = 65535;
        int classMajorVersion = instrCN.version & 0xFFFF;
        int requiredMajorVersion = 49;
        if (classMajorVersion < requiredMajorVersion) {
            instrCN.version = 49;
        }
        int COMPUTEFRAMES_VERSION = 51;
        ROClassWriter cw = null;
        cw = classMajorVersion >= 51 ? new ROClassWriter(2) : new ROClassWriter(1);
        instrCN.accept(cw);
        return cw.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __dumpClassToFile(byte[] classBytes, String fileName) throws DiSLIOException {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            try {
                fos.write(classBytes);
            }
            finally {
                fos.close();
            }
        }
        catch (IOException ioe) {
            throw new DiSLIOException(ioe);
        }
    }

    public void terminate() {
    }

    private void __debug(String format, Object ... args) {
        if (debug) {
            System.out.printf(format, args);
        }
    }

    private void __trace(String format, Object ... args) {
        if (trace) {
            System.out.printf(format, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstrumentedClass {
        private ClassNode classNode;
        private Set<String> changedMethods;

        public InstrumentedClass(ClassNode classNode, Set<String> changedMethods) {
            this.classNode = classNode;
            this.changedMethods = changedMethods;
        }

        public ClassNode getClassNode() {
            return this.classNode;
        }

        public Set<String> getChangedMethods() {
            return this.changedMethods;
        }
    }
}

