/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import kieker.tools.traceAnalysis.gui.AbstractStep;

public class AdditionalOptionsStep
extends AbstractStep {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_KEY_IDENTIFIER = AdditionalOptionsStep.class.getSimpleName();
    private static final String PROPERTY_KEY_VERBOSE = PROPERTY_KEY_IDENTIFIER + ".verbose";
    private static final String PROPERTY_KEY_IGNORE_INVALID_TRACES = PROPERTY_KEY_IDENTIFIER + ".ignoreInvalidTraces";
    private static final String PROPERTY_KEY_IGNORE_ASSUMED_CALLS = PROPERTY_KEY_IDENTIFIER + ".ignoreAssumedCalls";
    private static final String PROPERTY_KEY_USE_SHORT_LABELS = PROPERTY_KEY_IDENTIFIER + ".useShortLabels";
    private static final String PROPERTY_KEY_INCLUDE_SELF_LOOPS = PROPERTY_KEY_IDENTIFIER + ".includeSelfLoops";
    private static final String PROPERTY_KEY_MAX_TRACE_DURATION = PROPERTY_KEY_IDENTIFIER + ".maxTraceDurationMS";
    private static final String PROPERTY_KEY_MAX_TRACE_DURATION_INPUT = PROPERTY_KEY_IDENTIFIER + ".maxTraceDurationMSInput";
    private static final String PROPERTY_KEY_TRACE_COLORING_MAP = PROPERTY_KEY_IDENTIFIER + ".traceColoringMap";
    private static final String PROPERTY_KEY_TRACE_COLORING_MAP_INPUT = PROPERTY_KEY_IDENTIFIER + ".traceColoringMapInput";
    private static final String PROPERTY_KEY_DESCRIPTION = PROPERTY_KEY_IDENTIFIER + ".description";
    private static final String PROPERTY_KEY_DESCRIPTION_INPUT = PROPERTY_KEY_IDENTIFIER + ".descriptionInput";
    private final JLabel infoLabel = new JLabel("<html>In this step you manage additional options for the trace analysis.</html>");
    private final JPanel expandingPanel = new JPanel();
    private final JCheckBox verbose = new JCheckBox("Verbosely list used parameters and processed traces");
    private final JCheckBox ignoreInvalidTraces = new JCheckBox("Ignore Invalid Traces");
    private final JCheckBox ignoreAssumedCalls = new JCheckBox("Draw Assumed Calls As Usual Calls");
    private final JCheckBox useShortLabels = new JCheckBox("Use Short Labels");
    private final JCheckBox includeSelfLoops = new JCheckBox("Include Self Loops");
    private final JCheckBox maxTraceDurationMS = new JCheckBox("Maximal Duration of Traces in Milliseconds:");
    private final JSpinner maxTraceDurationMSInput = new JSpinner();
    private final JCheckBox traceColoringMap = new JCheckBox("Use Trace Coloring Map File:");
    private final JTextField traceColoringMapInput = new JTextField(".");
    private final JButton traceColoringMapChooseButton = new JButton("Choose");
    private final JCheckBox description = new JCheckBox("Use Description File:");
    private final JTextField descriptionInput = new JTextField(".");
    private final JButton descriptionChooseButton = new JButton("Choose");

    public AdditionalOptionsStep() {
        this.addAndLayoutComponents();
        this.addLogicToComponents();
    }

    private void addAndLayoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.infoLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(5, 5, 0, 0);
        this.add((Component)this.verbose, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(0, 5, 0, 0);
        this.add((Component)this.ignoreAssumedCalls, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(0, 5, 0, 0);
        this.add((Component)this.ignoreInvalidTraces, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(0, 5, 0, 0);
        this.add((Component)this.useShortLabels, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(0, 5, 0, 0);
        this.add((Component)this.includeSelfLoops, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.maxTraceDurationMS, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.maxTraceDurationMSInput, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.traceColoringMap, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.traceColoringMapInput, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.traceColoringMapChooseButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.description, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.descriptionInput, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.descriptionChooseButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.expandingPanel, gridBagConstraints);
    }

    @Override
    public void addSelectedTraceAnalysisParameters(Collection<String> parameters) {
        if (this.verbose.isSelected()) {
            parameters.add("--verbose");
        }
        if (this.ignoreInvalidTraces.isSelected()) {
            parameters.add("--ignore-invalid-traces");
        }
        if (this.useShortLabels.isSelected()) {
            parameters.add("--short-labels");
        }
        if (this.includeSelfLoops.isSelected()) {
            parameters.add("--include-self-loops");
        }
        if (this.maxTraceDurationMS.isSelected()) {
            parameters.add("--max-trace-duration");
            parameters.add(this.maxTraceDurationMSInput.getValue().toString());
        }
        if (this.ignoreAssumedCalls.isSelected()) {
            parameters.add("--ignore-assumed-calls");
        }
        if (this.description.isSelected()) {
            parameters.add("--addDescriptions");
            parameters.add(this.descriptionInput.getText());
        }
        if (this.traceColoringMap.isSelected()) {
            parameters.add("--traceColoring");
            parameters.add(this.traceColoringMapInput.getText());
        }
    }

    private void addLogicToComponents() {
        this.descriptionChooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(AdditionalOptionsStep.this.descriptionInput.getText());
                fileChooser.setFileSelectionMode(0);
                if (fileChooser.showOpenDialog(AdditionalOptionsStep.this) == 0) {
                    AdditionalOptionsStep.this.descriptionInput.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.traceColoringMapChooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(AdditionalOptionsStep.this.traceColoringMapInput.getText());
                fileChooser.setFileSelectionMode(0);
                if (fileChooser.showOpenDialog(AdditionalOptionsStep.this) == 0) {
                    AdditionalOptionsStep.this.traceColoringMapInput.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.description.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdditionalOptionsStep.this.descriptionInput.setEnabled(AdditionalOptionsStep.this.description.isSelected());
                AdditionalOptionsStep.this.descriptionChooseButton.setEnabled(AdditionalOptionsStep.this.description.isSelected());
            }
        });
        this.traceColoringMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdditionalOptionsStep.this.traceColoringMapInput.setEnabled(AdditionalOptionsStep.this.traceColoringMap.isSelected());
                AdditionalOptionsStep.this.traceColoringMapChooseButton.setEnabled(AdditionalOptionsStep.this.traceColoringMap.isSelected());
            }
        });
        this.maxTraceDurationMS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdditionalOptionsStep.this.maxTraceDurationMSInput.setEnabled(AdditionalOptionsStep.this.maxTraceDurationMS.isSelected());
            }
        });
    }

    @Override
    public void loadDefaultConfiguration() {
        this.maxTraceDurationMSInput.setValue(600000);
        this.traceColoringMapInput.setEnabled(false);
        this.descriptionInput.setEnabled(false);
        this.descriptionChooseButton.setEnabled(false);
        this.traceColoringMapInput.setEnabled(false);
        this.traceColoringMapChooseButton.setEnabled(false);
        this.maxTraceDurationMSInput.setEnabled(false);
    }

    @Override
    public void saveCurrentConfiguration(Properties properties) {
        properties.setProperty(PROPERTY_KEY_VERBOSE, Boolean.toString(this.verbose.isSelected()));
        properties.setProperty(PROPERTY_KEY_IGNORE_INVALID_TRACES, Boolean.toString(this.ignoreInvalidTraces.isSelected()));
        properties.setProperty(PROPERTY_KEY_USE_SHORT_LABELS, Boolean.toString(this.useShortLabels.isSelected()));
        properties.setProperty(PROPERTY_KEY_INCLUDE_SELF_LOOPS, Boolean.toString(this.includeSelfLoops.isSelected()));
        properties.setProperty(PROPERTY_KEY_MAX_TRACE_DURATION, Boolean.toString(this.maxTraceDurationMS.isSelected()));
        properties.setProperty(PROPERTY_KEY_MAX_TRACE_DURATION_INPUT, Integer.toString((Integer)this.maxTraceDurationMSInput.getValue()));
        properties.setProperty(PROPERTY_KEY_IGNORE_ASSUMED_CALLS, Boolean.toString(this.ignoreAssumedCalls.isSelected()));
        properties.setProperty(PROPERTY_KEY_TRACE_COLORING_MAP, Boolean.toString(this.traceColoringMap.isSelected()));
        properties.setProperty(PROPERTY_KEY_TRACE_COLORING_MAP_INPUT, this.traceColoringMapInput.getText());
        properties.setProperty(PROPERTY_KEY_DESCRIPTION, Boolean.toString(this.description.isSelected()));
        properties.setProperty(PROPERTY_KEY_DESCRIPTION_INPUT, this.descriptionInput.getText());
    }

    @Override
    public void loadCurrentConfiguration(Properties properties) {
        this.verbose.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_VERBOSE)));
        this.ignoreInvalidTraces.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_IGNORE_INVALID_TRACES)));
        this.useShortLabels.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_USE_SHORT_LABELS)));
        this.includeSelfLoops.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_INCLUDE_SELF_LOOPS)));
        this.maxTraceDurationMS.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_MAX_TRACE_DURATION)));
        this.ignoreAssumedCalls.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_IGNORE_ASSUMED_CALLS)));
        this.traceColoringMap.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_TRACE_COLORING_MAP)));
        this.description.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_DESCRIPTION)));
        this.descriptionInput.setText(properties.getProperty(PROPERTY_KEY_DESCRIPTION_INPUT));
        this.traceColoringMapInput.setText(properties.getProperty(PROPERTY_KEY_TRACE_COLORING_MAP_INPUT));
        this.maxTraceDurationMSInput.setValue(Integer.parseInt(properties.getProperty(PROPERTY_KEY_MAX_TRACE_DURATION_INPUT)));
        this.descriptionInput.setEnabled(this.description.isSelected());
        this.descriptionChooseButton.setEnabled(this.description.isSelected());
        this.traceColoringMapInput.setEnabled(this.traceColoringMap.isSelected());
        this.traceColoringMapChooseButton.setEnabled(this.traceColoringMap.isSelected());
        this.maxTraceDurationMSInput.setEnabled(this.maxTraceDurationMS.isSelected());
    }

    @Override
    public boolean isNextStepAllowed() {
        return true;
    }
}

