/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.flow;

import java.util.Stack;
import kieker.analysis.IProjectContext;
import kieker.analysis.analysisComponent.AbstractAnalysisComponent;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.analysis.plugin.filter.flow.TraceEventRecords;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.concurrency.SplitEvent;
import kieker.common.record.flow.trace.operation.AbstractOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.flow.trace.operation.CallOperationEvent;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorEvent;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorFailedEvent;
import kieker.common.record.flow.trace.operation.constructor.BeforeConstructorEvent;
import kieker.common.record.flow.trace.operation.constructor.CallConstructorEvent;
import kieker.common.util.signature.ClassOperationSignaturePair;
import kieker.common.util.signature.Signature;
import kieker.tools.traceAnalysis.filter.AbstractTraceAnalysisFilter;
import kieker.tools.traceAnalysis.filter.AbstractTraceProcessingFilter;
import kieker.tools.traceAnalysis.filter.traceReconstruction.InvalidTraceException;
import kieker.tools.traceAnalysis.systemModel.Execution;
import kieker.tools.traceAnalysis.systemModel.ExecutionTrace;
import kieker.tools.traceAnalysis.systemModel.InvalidExecutionTrace;
import kieker.tools.traceAnalysis.systemModel.MessageTrace;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

@Plugin(description="Transforms incoming TraceEventRecords into execution and message traces", outputPorts={@OutputPort(name="executionTrace", description="Outputs transformed execution traces", eventTypes={ExecutionTrace.class}), @OutputPort(name="messageTrace", description="Outputs transformed message traces", eventTypes={MessageTrace.class}), @OutputPort(name="invalidTrace", description="Invalid Execution Traces", eventTypes={InvalidExecutionTrace.class})}, repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="enhanceJavaConstructors", defaultValue="true"), @Property(name="enhanceCallDetection", defaultValue="true"), @Property(name="ignoreAssumed", defaultValue="false")})
public class TraceEventRecords2ExecutionAndMessageTraceFilter
extends AbstractTraceProcessingFilter {
    public static final String INPUT_PORT_NAME_EVENT_TRACE = "traceEvents";
    public static final String OUTPUT_PORT_NAME_EXECUTION_TRACE = "executionTrace";
    public static final String OUTPUT_PORT_NAME_MESSAGE_TRACE = "messageTrace";
    public static final String OUTPUT_PORT_NAME_INVALID_EXECUTION_TRACE = "invalidTrace";
    public static final String CONFIG_IGNORE_ASSUMED = "ignoreAssumed";
    public static final String CONFIG_ENHANCE_JAVA_CONSTRUCTORS = "enhanceJavaConstructors";
    public static final String CONFIG_ENHANCE_CALL_DETECTION = "enhanceCallDetection";
    private final boolean enhanceJavaConstructors;
    private final boolean enhanceCallDetection;
    private final boolean ignoreAssumedCalls;

    public TraceEventRecords2ExecutionAndMessageTraceFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.enhanceJavaConstructors = configuration.getBooleanProperty(CONFIG_ENHANCE_JAVA_CONSTRUCTORS);
        this.enhanceCallDetection = configuration.getBooleanProperty(CONFIG_ENHANCE_CALL_DETECTION);
        this.ignoreAssumedCalls = configuration.getBooleanProperty(CONFIG_IGNORE_ASSUMED);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = super.getCurrentConfiguration();
        configuration.setProperty(CONFIG_ENHANCE_JAVA_CONSTRUCTORS, String.valueOf(this.enhanceJavaConstructors));
        configuration.setProperty(CONFIG_ENHANCE_CALL_DETECTION, String.valueOf(this.enhanceCallDetection));
        configuration.setProperty(CONFIG_IGNORE_ASSUMED, String.valueOf(this.ignoreAssumedCalls));
        return configuration;
    }

    @InputPort(name="traceEvents", description="Receives TraceEvents to be transformed", eventTypes={TraceEventRecords.class})
    public void inputTraceEvents(TraceEventRecords traceEventRecords) {
        TraceMetadata trace = traceEventRecords.getTraceMetadata();
        if (trace == null) {
            this.log.error("Trace is missing from TraceEvents");
            return;
        }
        long traceId = trace.getTraceId();
        ExecutionTrace executionTrace = new ExecutionTrace(traceId, trace.getSessionId());
        TraceEventRecordHandler traceEventRecordHandler = new TraceEventRecordHandler(trace, executionTrace, this.getSystemEntityFactory(), this.enhanceJavaConstructors, this.enhanceCallDetection, this.ignoreAssumedCalls);
        int expectedOrderIndex = -1;
        for (AbstractTraceEvent event : traceEventRecords.getTraceEvents()) {
            if (event.getOrderIndex() != ++expectedOrderIndex) {
                this.log.error("Found event with wrong orderIndex. Found: " + event.getOrderIndex() + " expected: " + (expectedOrderIndex - 1));
                continue;
            }
            if (event.getTraceId() != traceId) {
                this.log.error("Found event with wrong traceId. Found: " + event.getTraceId() + " expected: " + traceId);
                continue;
            }
            try {
                if (BeforeConstructorEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleBeforeConstructorEvent((BeforeConstructorEvent)event);
                    continue;
                }
                if (BeforeOperationEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleBeforeOperationEvent((BeforeOperationEvent)event);
                    continue;
                }
                if (AfterConstructorFailedEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleAfterConstructorFailedEvent((AfterConstructorFailedEvent)event);
                    continue;
                }
                if (AfterOperationFailedEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleAfterOperationFailedEvent((AfterOperationFailedEvent)event);
                    continue;
                }
                if (AfterConstructorEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleAfterConstructorEvent((AfterConstructorEvent)event);
                    continue;
                }
                if (AfterOperationEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleAfterOperationEvent((AfterOperationEvent)event);
                    continue;
                }
                if (CallConstructorEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleCallConstructorEvent((CallConstructorEvent)event);
                    continue;
                }
                if (CallOperationEvent.class.isAssignableFrom(event.getClass())) {
                    traceEventRecordHandler.handleCallOperationEvent((CallOperationEvent)event);
                    continue;
                }
                if (SplitEvent.class.isAssignableFrom(event.getClass())) {
                    this.log.warn("Events of type 'SplitEvent' are currently not handled and ignored.");
                    continue;
                }
                this.log.warn("Events of type '" + event.getClass().getName() + "' are currently not handled and ignored.");
            }
            catch (InvalidTraceException ex) {
                this.log.error("Failed to reconstruct trace.", ex);
                super.deliver(OUTPUT_PORT_NAME_INVALID_EXECUTION_TRACE, new InvalidExecutionTrace(executionTrace));
                return;
            }
        }
        try {
            traceEventRecordHandler.finish();
            MessageTrace messageTrace = executionTrace.toMessageTrace(SystemModelRepository.ROOT_EXECUTION);
            super.deliver(OUTPUT_PORT_NAME_EXECUTION_TRACE, executionTrace);
            super.deliver(OUTPUT_PORT_NAME_MESSAGE_TRACE, messageTrace);
            super.reportSuccess(executionTrace.getTraceId());
        }
        catch (InvalidTraceException ex) {
            this.log.warn("Failed to convert to message trace: " + ex.getMessage());
            super.deliver(OUTPUT_PORT_NAME_INVALID_EXECUTION_TRACE, new InvalidExecutionTrace(executionTrace));
        }
    }

    protected static Log getLOG() {
        return AbstractAnalysisComponent.LOG;
    }

    private static class TraceEventRecordHandler {
        private final SystemModelRepository systemModelRepository;
        private final TraceMetadata trace;
        private final ExecutionTrace executionTrace;
        private final Stack<AbstractTraceEvent> eventStack = new Stack();
        private final Stack<ExecutionInformation> executionStack = new Stack();
        private final boolean enhanceJavaConstructors;
        private final boolean enhanceCallDetection;
        private int orderindex;
        private final boolean ignoreAssumedCalls;

        public TraceEventRecordHandler(TraceMetadata trace, ExecutionTrace executionTrace, SystemModelRepository systemModelRepository, boolean enhanceJavaConstructors, boolean enhanceCallDetection, boolean ignoreAssumedCalls) {
            this.trace = trace;
            this.executionTrace = executionTrace;
            this.systemModelRepository = systemModelRepository;
            this.enhanceJavaConstructors = enhanceJavaConstructors;
            this.enhanceCallDetection = enhanceCallDetection;
            this.ignoreAssumedCalls = ignoreAssumedCalls;
        }

        public void finish() throws InvalidTraceException {
            Stack<AbstractTraceEvent> tmpEventStack = new Stack<AbstractTraceEvent>();
            Stack<ExecutionInformation> tmpExecutionStack = new Stack<ExecutionInformation>();
            if (!this.eventStack.isEmpty()) {
                long lastTimeStamp = this.eventStack.peek().getTimestamp();
                while (!this.eventStack.isEmpty()) {
                    tmpEventStack.push(this.eventStack.pop());
                    tmpExecutionStack.push(this.executionStack.pop());
                }
                while (!tmpEventStack.isEmpty()) {
                    AbstractTraceEvent currentEvent = (AbstractTraceEvent)tmpEventStack.pop();
                    ExecutionInformation executionInformation = (ExecutionInformation)tmpExecutionStack.pop();
                    if (currentEvent instanceof CallOperationEvent) {
                        this.finishExecution(((CallOperationEvent)currentEvent).getCalleeOperationSignature(), ((CallOperationEvent)currentEvent).getCalleeClassSignature(), this.trace.getTraceId(), this.trace.getSessionId(), this.trace.getHostname(), executionInformation.getEoi(), executionInformation.getEss(), currentEvent.getTimestamp(), lastTimeStamp, !this.ignoreAssumedCalls, currentEvent instanceof CallConstructorEvent);
                        continue;
                    }
                    throw new InvalidTraceException("Only CallOperationEvents are expected to be remaining, but found: " + currentEvent.getClass().getSimpleName());
                }
            }
        }

        private AbstractTraceEvent peekEvent() {
            if (this.eventStack.isEmpty()) {
                return null;
            }
            return this.eventStack.peek();
        }

        private void registerExecution(AbstractTraceEvent cause) {
            this.eventStack.push(cause);
            ExecutionInformation executionInformation = new ExecutionInformation(this.orderindex++, this.executionStack.size());
            this.executionStack.push(executionInformation);
        }

        private void finishExecution(String operationSignature, String classSignature, long traceId, String sessionId, String hostname, int eoi, int ess, long tin, long tout, boolean assumed, boolean constructor) throws InvalidTraceException {
            ClassOperationSignaturePair fqComponentNameSignaturePair = ClassOperationSignaturePair.splitOperationSignatureStr(operationSignature, constructor && this.enhanceJavaConstructors);
            String executionContext = classSignature.length() == 0 ? fqComponentNameSignaturePair.getFqClassname() : classSignature;
            Execution execution = AbstractTraceAnalysisFilter.createExecutionByEntityNames(this.systemModelRepository, hostname, executionContext, fqComponentNameSignaturePair.getFqClassname(), fqComponentNameSignaturePair.getSignature(), traceId, sessionId, eoi, ess, tin, tout, assumed);
            try {
                this.executionTrace.add(execution);
            }
            catch (InvalidTraceException ex) {
                throw new InvalidTraceException("Failed to add execution " + execution + " to trace " + this.executionTrace + ".", ex);
            }
        }

        private void closeOpenCalls(AbstractOperationEvent lastEvent) throws InvalidTraceException {
            AbstractTraceEvent prevEvent;
            Stack<CallOperationEvent> tmpEventStack = new Stack<CallOperationEvent>();
            Stack<ExecutionInformation> tmpExecutionStack = new Stack<ExecutionInformation>();
            while (!this.eventStack.isEmpty() && (prevEvent = this.eventStack.peek()) instanceof CallOperationEvent) {
                tmpEventStack.push((CallOperationEvent)this.eventStack.pop());
                tmpExecutionStack.push(this.executionStack.pop());
                if (!lastEvent.getOperationSignature().equals(((CallOperationEvent)prevEvent).getOperationSignature())) continue;
                while (!tmpEventStack.isEmpty()) {
                    CallOperationEvent currentCallEvent = (CallOperationEvent)tmpEventStack.pop();
                    ExecutionInformation executionInformation = (ExecutionInformation)tmpExecutionStack.pop();
                    this.finishExecution(currentCallEvent.getCalleeOperationSignature(), currentCallEvent.getCalleeClassSignature(), this.trace.getTraceId(), this.trace.getSessionId(), this.trace.getHostname(), executionInformation.getEoi(), executionInformation.getEss(), currentCallEvent.getTimestamp(), lastEvent.getTimestamp(), !this.ignoreAssumedCalls, currentCallEvent instanceof CallConstructorEvent);
                }
                return;
            }
            while (!tmpEventStack.isEmpty()) {
                this.eventStack.push((AbstractTraceEvent)tmpEventStack.pop());
                this.executionStack.push((ExecutionInformation)tmpExecutionStack.pop());
            }
        }

        private void handleBeforeEvent(BeforeOperationEvent beforeOperationEvent, Class<? extends CallOperationEvent> callClass) throws InvalidTraceException {
            AbstractTraceEvent prevEvent = this.peekEvent();
            if (this.isPrevEventMatchingCall(beforeOperationEvent, prevEvent, callClass)) {
                this.eventStack.push(beforeOperationEvent);
            } else {
                this.closeOpenCalls(beforeOperationEvent);
                this.registerExecution(beforeOperationEvent);
            }
        }

        public void handleBeforeOperationEvent(BeforeOperationEvent beforeOperationEvent) throws InvalidTraceException {
            this.handleBeforeEvent(beforeOperationEvent, CallOperationEvent.class);
        }

        public void handleBeforeConstructorEvent(BeforeConstructorEvent beforeConstructorEvent) throws InvalidTraceException {
            this.handleBeforeEvent(beforeConstructorEvent, CallConstructorEvent.class);
        }

        private boolean isPrevEventMatchingCall(BeforeOperationEvent beforeOperationEvent, AbstractTraceEvent prevEvent, Class<? extends CallOperationEvent> callClass) {
            if (prevEvent != null && callClass.isAssignableFrom(prevEvent.getClass()) && prevEvent.getOrderIndex() == beforeOperationEvent.getOrderIndex() - 1) {
                if (this.callsReferencedOperationOf((CallOperationEvent)prevEvent, beforeOperationEvent)) {
                    return true;
                }
                if (this.enhanceCallDetection) {
                    Signature afterSignature;
                    boolean isConstructor = beforeOperationEvent instanceof BeforeConstructorEvent;
                    CallOperationEvent callEvent = (CallOperationEvent)prevEvent;
                    Signature callSignature = ClassOperationSignaturePair.splitOperationSignatureStr(callEvent.getCalleeOperationSignature(), isConstructor && this.enhanceJavaConstructors).getSignature();
                    if (callSignature.equals(afterSignature = ClassOperationSignaturePair.splitOperationSignatureStr(beforeOperationEvent.getOperationSignature(), isConstructor && this.enhanceJavaConstructors).getSignature()) && callEvent.getCalleeClassSignature().equals(beforeOperationEvent.getClassSignature())) {
                        if (TraceEventRecords2ExecutionAndMessageTraceFilter.getLOG().isDebugEnabled()) {
                            TraceEventRecords2ExecutionAndMessageTraceFilter.getLOG().debug("Guessed call of \n\t" + callEvent + "\n\t" + beforeOperationEvent);
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean callsReferencedOperationOf(CallOperationEvent prevEvent, BeforeOperationEvent presentEvent) {
            return prevEvent.getCalleeOperationSignature().equals(presentEvent.getOperationSignature()) && prevEvent.getCalleeClassSignature().equals(presentEvent.getClassSignature());
        }

        private void handleAfterEvent(AfterOperationEvent afterOperationEvent, Class<? extends BeforeOperationEvent> beforeClass, Class<? extends CallOperationEvent> callClass) throws InvalidTraceException {
            boolean definiteCall;
            this.closeOpenCalls(afterOperationEvent);
            AbstractTraceEvent potentialBeforeEvent = this.peekEvent();
            if (potentialBeforeEvent == null || !beforeClass.isAssignableFrom(potentialBeforeEvent.getClass())) {
                throw new InvalidTraceException("Didn't find corresponding " + beforeClass.getName() + " for " + afterOperationEvent.getClass().getName() + " " + afterOperationEvent.toString() + " (found: " + potentialBeforeEvent + ").");
            }
            if (!this.refersToSameOperationAs(afterOperationEvent, (BeforeOperationEvent)potentialBeforeEvent)) {
                throw new InvalidTraceException("Components of before (" + potentialBeforeEvent + ") " + "and after (" + afterOperationEvent + ") events do not match.");
            }
            BeforeOperationEvent beforeOperationEvent = (BeforeOperationEvent)this.eventStack.pop();
            AbstractTraceEvent prevEvent = this.peekEvent();
            boolean bl = definiteCall = prevEvent == null || this.isPrevEventMatchingCall(beforeOperationEvent, prevEvent, callClass);
            if (definiteCall && !this.eventStack.isEmpty()) {
                this.eventStack.pop();
            }
            ExecutionInformation executionInformation = this.executionStack.pop();
            this.finishExecution(beforeOperationEvent.getOperationSignature(), beforeOperationEvent.getClassSignature(), this.trace.getTraceId(), this.trace.getSessionId(), this.trace.getHostname(), executionInformation.getEoi(), executionInformation.getEss(), beforeOperationEvent.getTimestamp(), afterOperationEvent.getTimestamp(), !definiteCall && !this.ignoreAssumedCalls, beforeOperationEvent instanceof BeforeConstructorEvent);
        }

        private boolean refersToSameOperationAs(AfterOperationEvent afterOperationEvent, BeforeOperationEvent potentialBeforeEvent) {
            return afterOperationEvent.getOperationSignature().equals(potentialBeforeEvent.getOperationSignature()) && afterOperationEvent.getClassSignature().equals(potentialBeforeEvent.getClassSignature());
        }

        public void handleAfterOperationEvent(AfterOperationEvent afterOperationEvent) throws InvalidTraceException {
            this.handleAfterEvent(afterOperationEvent, BeforeOperationEvent.class, CallOperationEvent.class);
        }

        public void handleAfterOperationFailedEvent(AfterOperationFailedEvent afterOperationEvent) throws InvalidTraceException {
            this.handleAfterEvent(afterOperationEvent, BeforeOperationEvent.class, CallOperationEvent.class);
        }

        public void handleAfterConstructorEvent(AfterConstructorEvent afterConstructorEvent) throws InvalidTraceException {
            this.handleAfterEvent(afterConstructorEvent, BeforeConstructorEvent.class, CallConstructorEvent.class);
        }

        public void handleAfterConstructorFailedEvent(AfterConstructorFailedEvent afterConstructorEvent) throws InvalidTraceException {
            this.handleAfterEvent(afterConstructorEvent, BeforeConstructorEvent.class, CallConstructorEvent.class);
        }

        public void handleCallOperationEvent(CallOperationEvent callOperationEvent) throws InvalidTraceException {
            this.closeOpenCalls(callOperationEvent);
            this.registerExecution(callOperationEvent);
        }

        public void handleCallConstructorEvent(CallConstructorEvent callConstructorEvent) throws InvalidTraceException {
            this.handleCallOperationEvent(callConstructorEvent);
        }

        private static class ExecutionInformation {
            private final int eoi;
            private final int ess;

            public ExecutionInformation(int executionIndex, int stackDepth) {
                this.eoi = executionIndex;
                this.ess = stackDepth;
            }

            public int getEoi() {
                return this.eoi;
            }

            public int getEss() {
                return this.ess;
            }
        }
    }
}

