/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem.async;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.RegistryRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.AbstractAsyncThread;
import kieker.monitoring.writer.filesystem.map.StringMappingFileWriter;

public abstract class AbstractZipWriterThread
extends AbstractAsyncThread {
    private static final Log LOG = LogFactory.getLog(AbstractZipWriterThread.class);
    protected String fileExtension = ".dat";
    protected final ZipOutputStream zipOutputStream;
    private final StringMappingFileWriter mappingFileWriter;
    private final String zipFileName;
    private final int maxEntriesInFile;
    private final DateFormat dateFormat;
    private int entriesInCurrentFileCounter;
    private long previousFileDate;
    private long sameFilenameCounter;

    public AbstractZipWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, StringMappingFileWriter mappingFileWriter, String path, int maxEntriesInFile, int level) throws IOException {
        super(monitoringController, writeQueue);
        this.mappingFileWriter = mappingFileWriter;
        this.maxEntriesInFile = maxEntriesInFile;
        this.entriesInCurrentFileCounter = maxEntriesInFile;
        this.dateFormat = new SimpleDateFormat("yyyyMMdd'-'HHmmssSSS", Locale.US);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.zipFileName = new File(path).getAbsolutePath() + File.separatorChar + "kieker" + '-' + this.dateFormat.format(new Date(System.currentTimeMillis())) + "-UTC-" + monitoringController.getHostname() + "-" + monitoringController.getName() + "-" + this.getName() + ".zip";
        this.zipOutputStream = new ZipOutputStream(new FileOutputStream(this.zipFileName));
        this.zipOutputStream.setLevel(level);
        this.zipOutputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void cleanup() {
        PrintWriter pw = null;
        try {
            this.cleanupForNextEntry();
            this.zipOutputStream.putNextEntry(new ZipEntry("kieker.map"));
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.zipOutputStream, "UTF-8"));
            pw.print(this.mappingFileWriter.toString());
            pw.flush();
            this.cleanupFinal();
            this.zipOutputStream.close();
        }
        catch (IOException ex) {
            LOG.error("Error finalizing logging zip file: " + this.zipFileName, ex);
        }
        finally {
            if (null != pw) {
                pw.close();
            }
        }
    }

    protected final String getFilename() {
        long date = System.currentTimeMillis();
        if (this.previousFileDate == date) {
            ++this.sameFilenameCounter;
        } else {
            this.sameFilenameCounter = 0L;
            this.previousFileDate = date;
        }
        StringBuilder sb = new StringBuilder("kieker".length() + this.fileExtension.length() + 27);
        sb.append("kieker").append('-').append(this.dateFormat.format(new Date(date))).append("-UTC-").append(String.format("%03d", this.sameFilenameCounter)).append(this.fileExtension);
        return sb.toString();
    }

    @Override
    protected final void consume(IMonitoringRecord monitoringRecord) throws Exception {
        if (monitoringRecord instanceof RegistryRecord) {
            this.mappingFileWriter.write((RegistryRecord)monitoringRecord);
        } else {
            if (++this.entriesInCurrentFileCounter > this.maxEntriesInFile) {
                this.entriesInCurrentFileCounter = 1;
                this.cleanupForNextEntry();
                this.zipOutputStream.putNextEntry(new ZipEntry(this.getFilename()));
            }
            this.write(monitoringRecord);
        }
    }

    protected abstract void write(IMonitoringRecord var1) throws IOException;

    protected abstract void cleanupForNextEntry() throws IOException;

    protected abstract void cleanupFinal() throws IOException;

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.toString());
        sb.append("; Writing to File: '");
        sb.append(this.zipFileName);
        sb.append('\'');
        return sb.toString();
    }
}

