/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.registry;

import java.security.SecureRandom;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.SessionRegistry;

public enum TraceRegistry {
    INSTANCE;

    private static final Log LOG;
    private final AtomicInteger nextTraceId = new AtomicInteger(0);
    private final long unique = MonitoringController.getInstance().isDebug() ? 0L : (long)new SecureRandom().nextInt() << 32;
    private final String hostname = MonitoringController.getInstance().getHostname();
    private final ThreadLocal<TraceMetadata> traceStorage = new ThreadLocal();
    private final ThreadLocal<Stack<TraceMetadata>> enclosingTraceStack = new ThreadLocal();
    private final WeakHashMap<Thread, TracePoint> parentTrace = new WeakHashMap();

    private final long getId() {
        return this.unique | (long)this.nextTraceId.getAndIncrement();
    }

    public final TraceMetadata getTrace() {
        return this.traceStorage.get();
    }

    public final TraceMetadata registerTrace() {
        int parentOrderId;
        long parentTraceId;
        TraceMetadata enclosingTrace = this.traceStorage.get();
        if (enclosingTrace != null) {
            Stack<TraceMetadata> localTraceStack = this.enclosingTraceStack.get();
            if (localTraceStack == null) {
                localTraceStack = new Stack();
                this.enclosingTraceStack.set(localTraceStack);
            }
            localTraceStack.push(enclosingTrace);
        }
        Thread thread = Thread.currentThread();
        TracePoint tp = this.getAndRemoveParentTraceId(thread);
        long traceId = this.getId();
        if (tp != null) {
            if (enclosingTrace != null && enclosingTrace.getTraceId() != tp.traceId) {
                LOG.error("Enclosing trace does not match split point. Found: " + enclosingTrace.getTraceId() + " expected: " + tp.traceId);
            }
            parentTraceId = tp.traceId;
            parentOrderId = tp.orderId;
        } else if (enclosingTrace != null) {
            parentTraceId = enclosingTrace.getTraceId();
            parentOrderId = -1;
        } else {
            parentTraceId = traceId;
            parentOrderId = -1;
        }
        String sessionId = SessionRegistry.INSTANCE.recallThreadLocalSessionId();
        TraceMetadata trace = new TraceMetadata(traceId, thread.getId(), sessionId, this.hostname, parentTraceId, parentOrderId);
        this.traceStorage.set(trace);
        return trace;
    }

    public final void unregisterTrace() {
        Stack<TraceMetadata> localTraceStack = this.enclosingTraceStack.get();
        if (localTraceStack != null) {
            if (!localTraceStack.isEmpty()) {
                this.traceStorage.set(localTraceStack.pop());
            } else {
                this.enclosingTraceStack.remove();
                this.traceStorage.remove();
            }
        } else {
            this.traceStorage.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TracePoint getAndRemoveParentTraceId(Thread t) {
        TraceRegistry traceRegistry = this;
        synchronized (traceRegistry) {
            return this.parentTrace.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setParentTraceId(Thread t, long traceId, int orderId) {
        TraceRegistry traceRegistry = this;
        synchronized (traceRegistry) {
            this.parentTrace.put(t, new TracePoint(traceId, orderId));
        }
    }

    static {
        LOG = LogFactory.getLog(TraceRegistry.class);
    }

    private static final class TracePoint {
        public final long traceId;
        public final int orderId;

        public TracePoint(long traceId, int orderId) {
            this.traceId = traceId;
            this.orderId = orderId;
        }
    }
}

