/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util.filesystem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public enum BinaryCompressionMethod {
    NONE(".bin"){

        @Override
        public DataOutputStream getDataOutputStream(File outputFile, int bufferSize) throws IOException {
            return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile), bufferSize));
        }

        @Override
        public DataInputStream getDataInputStream(File inputFile, int bufferSize) throws IOException {
            return new DataInputStream(new BufferedInputStream(new FileInputStream(inputFile), bufferSize));
        }
    }
    ,
    DEFLATE(".bin.df"){

        @Override
        public DataOutputStream getDataOutputStream(File outputFile, int bufferSize) throws IOException {
            return new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(new FileOutputStream(outputFile)), bufferSize));
        }

        @Override
        public DataInputStream getDataInputStream(File inputFile, int bufferSize) throws IOException {
            return new DataInputStream(new BufferedInputStream(new InflaterInputStream(new FileInputStream(inputFile)), bufferSize));
        }
    }
    ,
    GZIP(".bin.gz"){

        @Override
        public DataOutputStream getDataOutputStream(File outputFile, int bufferSize) throws IOException {
            return new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(outputFile)), bufferSize));
        }

        @Override
        public DataInputStream getDataInputStream(File inputFile, int bufferSize) throws IOException {
            return new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(inputFile)), bufferSize));
        }
    }
    ,
    ZIP(".bin.zip"){

        @Override
        public DataOutputStream getDataOutputStream(File outputFile, int bufferSize) throws IOException {
            ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(outputFile));
            String shortname = outputFile.getName();
            shortname = shortname.substring(0, shortname.length() - 4);
            zipStream.putNextEntry(new ZipEntry(shortname));
            return new DataOutputStream(new BufferedOutputStream(zipStream, bufferSize));
        }

        @Override
        public DataInputStream getDataInputStream(File inputFile, int bufferSize) throws IOException {
            ZipInputStream zipStream = new ZipInputStream(new FileInputStream(inputFile));
            zipStream.getNextEntry();
            return new DataInputStream(new BufferedInputStream(zipStream, bufferSize));
        }
    };

    private final String fileExtension;

    private BinaryCompressionMethod(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public final String getFileExtension() {
        return this.fileExtension;
    }

    public abstract DataOutputStream getDataOutputStream(File var1, int var2) throws IOException;

    public abstract DataInputStream getDataInputStream(File var1, int var2) throws IOException;

    public static final boolean hasValidFileExtension(String name) {
        for (BinaryCompressionMethod method : BinaryCompressionMethod.values()) {
            if (!name.endsWith(method.getFileExtension())) continue;
            return true;
        }
        return false;
    }

    public static final BinaryCompressionMethod getByFileExtension(String name) throws IllegalArgumentException {
        for (BinaryCompressionMethod method : BinaryCompressionMethod.values()) {
            if (!name.endsWith(method.getFileExtension())) continue;
            return method;
        }
        throw new IllegalArgumentException();
    }
}

