/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.controlflow;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;

public class BranchingRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    public static final int SIZE = 16;
    private static final long serialVersionUID = -2795856778019853382L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    public static final long TIMESTAMP = 0L;
    public static final int BRANCH_ID = 0;
    public static final int BRANCHING_OUTCOME = 0;
    private final long timestamp;
    private final int branchID;
    private final int branchingOutcome;

    public BranchingRecord(long timestamp, int branchID, int branchingOutcome) {
        this.timestamp = timestamp;
        this.branchID = branchID;
        this.branchingOutcome = branchingOutcome;
    }

    public BranchingRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.timestamp = (Long)values[0];
        this.branchID = (Integer)values[1];
        this.branchingOutcome = (Integer)values[2];
    }

    protected BranchingRecord(Object[] values, Class<?>[] valueTypes) {
        AbstractMonitoringRecord.checkArray(values, valueTypes);
        this.timestamp = (Long)values[0];
        this.branchID = (Integer)values[1];
        this.branchingOutcome = (Integer)values[2];
    }

    public BranchingRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.timestamp = buffer.getLong();
        this.branchID = buffer.getInt();
        this.branchingOutcome = buffer.getInt();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getBranchID(), this.getBranchingOutcome()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putInt(this.getBranchID());
        buffer.putInt(this.getBranchingOutcome());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 16;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final int getBranchID() {
        return this.branchID;
    }

    public final int getBranchingOutcome() {
        return this.branchingOutcome;
    }
}

