/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.repository;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.repository.AbstractRepository;
import kieker.analysis.repository.annotation.Repository;
import kieker.common.configuration.Configuration;

@Repository(name="Description repository", description="Stores descriptions for names", configuration={@Property(name="descriptionFileName", defaultValue="")})
public class DescriptionRepository
extends AbstractRepository {
    public static final String CONFIG_PROPERTY_NAME_DESCRIPTION_FILE_NAME = "descriptionFileName";
    private static final char DELIMITER = '=';
    private static final String ENCODING = "UTF-8";
    private final ConcurrentMap<String, String> descriptionMap;

    public DescriptionRepository(Configuration configuration, IProjectContext projectContext) throws IOException {
        this(configuration, DescriptionRepository.readDataFromFile(configuration.getStringProperty(CONFIG_PROPERTY_NAME_DESCRIPTION_FILE_NAME)), projectContext);
    }

    public DescriptionRepository(Configuration configuration, DescriptionRepositoryData descriptionData, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.descriptionMap = descriptionData.getDescriptionMap();
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return this.configuration;
    }

    public Map<String, String> getDescriptionMap() {
        return Collections.unmodifiableMap(this.descriptionMap);
    }

    private static String[] splitLine(String inputLine) {
        int delimiterIndex = inputLine.indexOf(61);
        if (delimiterIndex < 0) {
            return null;
        }
        String[] returnValue = new String[]{inputLine.substring(0, delimiterIndex), inputLine.substring(delimiterIndex + 1)};
        return returnValue;
    }

    public static DescriptionRepository createFromFile(String fileName, IProjectContext projectContext) throws IOException {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_DESCRIPTION_FILE_NAME, fileName);
        return new DescriptionRepository(configuration, DescriptionRepository.readDataFromFile(fileName), projectContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DescriptionRepositoryData readDataFromFile(String fileName) throws IOException {
        BufferedReader reader = null;
        try {
            String currentLine;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), ENCODING));
            ConcurrentHashMap<String, String> descriptionMap = new ConcurrentHashMap<String, String>();
            while ((currentLine = reader.readLine()) != null) {
                String[] parts = DescriptionRepository.splitLine(currentLine);
                if (parts == null) continue;
                String key = parts[0];
                String description = parts[1];
                descriptionMap.put(key, description);
            }
            DescriptionRepositoryData descriptionRepositoryData = new DescriptionRepositoryData(descriptionMap);
            return descriptionRepositoryData;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static class DescriptionRepositoryData {
        private final ConcurrentMap<String, String> descriptionMap;

        public DescriptionRepositoryData(ConcurrentMap<String, String> descriptionMap) {
            this.descriptionMap = descriptionMap;
        }

        ConcurrentMap<String, String> getDescriptionMap() {
            return this.descriptionMap;
        }
    }
}

