/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.RegistryRecord;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import kieker.monitoring.writer.filesystem.map.MappingFileWriter;

public final class SyncFsWriter
extends AbstractMonitoringWriter {
    private static final String PREFIX = SyncFsWriter.class.getName() + ".";
    public static final String CONFIG_PATH = PREFIX + "customStoragePath";
    public static final String CONFIG_MAXENTRIESINFILE = PREFIX + "maxEntriesInFile";
    public static final String CONFIG_MAXLOGSIZE = PREFIX + "maxLogSize";
    public static final String CONFIG_MAXLOGFILES = PREFIX + "maxLogFiles";
    public static final String CONFIG_FLUSH = PREFIX + "flush";
    public static final String CONFIG_BUFFER = PREFIX + "bufferSize";
    private static final String CONFIG_TEMP = PREFIX + "storeInJavaIoTmpdir";
    private static final Log LOG = LogFactory.getLog(SyncFsWriter.class);
    private final boolean autoflush;
    private final int bufferSize;
    private final int maxEntriesInFile;
    private final long maxLogSize;
    private final int maxLogFiles;
    private final String configPath;
    private int entriesInCurrentFileCounter;
    private final LinkedList<FileNameSize> listOfLogFiles;
    private long totalLogSize;
    private String path;
    private MappingFileWriter mappingFileWriter;
    private PrintWriter pos;
    private final DateFormat dateFormat;
    private long previousFileDate;
    private long sameFilenameCounter;

    public SyncFsWriter(Configuration configuration) throws IllegalArgumentException {
        super(configuration);
        String pathTmp;
        this.autoflush = configuration.getBooleanProperty(CONFIG_FLUSH);
        this.bufferSize = configuration.getIntProperty(CONFIG_BUFFER);
        this.maxEntriesInFile = configuration.getIntProperty(CONFIG_MAXENTRIESINFILE);
        if (this.maxEntriesInFile < 1) {
            throw new IllegalArgumentException(CONFIG_MAXENTRIESINFILE + " must be greater than 0 but is '" + this.maxEntriesInFile + "'");
        }
        int configMaxLogSize = configuration.getIntProperty(CONFIG_MAXLOGSIZE);
        int configMaxLogFiles = configuration.getIntProperty(CONFIG_MAXLOGFILES);
        if (configMaxLogSize > 0 || configMaxLogFiles > 0) {
            this.maxLogSize = (long)configMaxLogSize * 1024L * 1024L;
            this.maxLogFiles = configMaxLogFiles;
            this.listOfLogFiles = new LinkedList();
        } else {
            this.maxLogSize = -1L;
            this.maxLogFiles = -1;
            this.listOfLogFiles = null;
        }
        this.entriesInCurrentFileCounter = this.maxEntriesInFile;
        this.dateFormat = new SimpleDateFormat("yyyyMMdd'-'HHmmssSSS", Locale.US);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (configuration.getBooleanProperty(CONFIG_TEMP)) {
            LOG.warn("Using deprecated configuration property " + CONFIG_TEMP + ". Instead use empty value for " + CONFIG_PATH);
        }
        if ((pathTmp = configuration.getStringProperty(CONFIG_PATH)).length() == 0) {
            pathTmp = System.getProperty("java.io.tmpdir");
        }
        if (!new File(pathTmp).isDirectory()) {
            throw new IllegalArgumentException("'" + pathTmp + "' is not a directory.");
        }
        this.configPath = pathTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() throws IllegalArgumentException, IOException {
        String ctrlName = this.monitoringController.getHostname() + "-" + this.monitoringController.getName();
        String dateStr = this.dateFormat.format(new Date());
        StringBuffer sb = new StringBuffer(this.configPath.length() + "kieker".length() + ctrlName.length() + 26);
        sb.append(this.configPath).append(File.separatorChar).append("kieker").append('-').append(dateStr).append("-UTC-").append(ctrlName).append(File.separatorChar);
        String pathTmp = sb.toString();
        File f = new File(pathTmp);
        if (!f.mkdir()) {
            throw new IllegalArgumentException("Failed to create directory '" + pathTmp + "'");
        }
        SyncFsWriter syncFsWriter = this;
        synchronized (syncFsWriter) {
            this.path = f.getAbsolutePath();
            this.mappingFileWriter = new MappingFileWriter(this.path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean newMonitoringRecord(IMonitoringRecord monitoringRecord) {
        if (monitoringRecord instanceof RegistryRecord) {
            try {
                this.mappingFileWriter.write((RegistryRecord)monitoringRecord);
            }
            catch (IOException ex) {
                LOG.error("Failed to write monitoring record", ex);
                return false;
            }
        }
        Object[] recordFields = monitoringRecord.toArray();
        StringBuilder sb = new StringBuilder(256);
        sb.append('$');
        sb.append(this.monitoringController.getUniqueIdForString(monitoringRecord.getClass().getName()));
        sb.append(';');
        sb.append(monitoringRecord.getLoggingTimestamp());
        for (Object recordField : recordFields) {
            sb.append(';');
            sb.append(recordField);
        }
        try {
            SyncFsWriter syncFsWriter = this;
            synchronized (syncFsWriter) {
                if (++this.entriesInCurrentFileCounter > this.maxEntriesInFile) {
                    String filename = this.getFilename();
                    this.prepareFile(filename);
                    if (this.listOfLogFiles != null) {
                        if (!this.listOfLogFiles.isEmpty()) {
                            long filesize;
                            FileNameSize fns = this.listOfLogFiles.getLast();
                            fns.size = filesize = new File(fns.name).length();
                            this.totalLogSize += filesize;
                        }
                        this.listOfLogFiles.add(new FileNameSize(filename));
                        if (this.maxLogFiles > 0 && this.listOfLogFiles.size() > this.maxLogFiles) {
                            FileNameSize removeFile = this.listOfLogFiles.removeFirst();
                            if (!new File(removeFile.name).delete()) {
                                throw new IOException("Failed to delete file " + removeFile.name);
                            }
                            this.totalLogSize -= removeFile.size;
                        }
                        if (this.maxLogSize > 0L) {
                            while (this.listOfLogFiles.size() > 1 && this.totalLogSize > this.maxLogSize) {
                                FileNameSize removeFile = this.listOfLogFiles.removeFirst();
                                if (!new File(removeFile.name).delete()) {
                                    throw new IOException("Failed to delete file " + removeFile.name);
                                }
                                this.totalLogSize -= removeFile.size;
                            }
                        }
                    }
                }
                this.pos.println(sb.toString());
            }
        }
        catch (IOException iOException) {
            LOG.error("Failed to write monitoring record", iOException);
            return false;
        }
        return true;
    }

    private final void prepareFile(String filename) throws FileNotFoundException, UnsupportedEncodingException {
        this.entriesInCurrentFileCounter = 1;
        if (this.pos != null) {
            this.pos.close();
        }
        this.pos = this.autoflush ? new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"), true) : new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"), this.bufferSize), false);
        this.pos.flush();
    }

    private final String getFilename() {
        long date = System.currentTimeMillis();
        if (this.previousFileDate == date) {
            ++this.sameFilenameCounter;
        } else {
            this.sameFilenameCounter = 0L;
            this.previousFileDate = date;
        }
        StringBuilder sb = new StringBuilder(this.path.length() + "kieker".length() + 31);
        sb.append(this.path).append(File.separatorChar).append("kieker").append(this.dateFormat.format(new Date(date))).append("-UTC-").append(String.format("%03d", this.sameFilenameCounter)).append(".dat");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void terminate() {
        SyncFsWriter syncFsWriter = this;
        synchronized (syncFsWriter) {
            if (this.pos != null) {
                this.pos.close();
            }
        }
        LOG.info("Writer: SyncFsWriter shutdown complete");
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.toString());
        sb.append("\n\tWriting to Directory: '");
        sb.append(this.path);
        sb.append('\'');
        return sb.toString();
    }

    private static final class FileNameSize {
        public final String name;
        public long size;

        public FileNameSize(String name) {
            this.name = name;
        }
    }
}

