/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import kieker.common.configuration.Configuration;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.AbstractAsyncWriter;
import kieker.monitoring.writer.filesystem.async.AbstractFsWriterThread;
import kieker.monitoring.writer.filesystem.map.MappingFileWriter;

public abstract class AbstractAsyncFSWriter
extends AbstractAsyncWriter {
    public static final String CONFIG_PATH = "customStoragePath";
    public static final String CONFIG_MAXENTRIESINFILE = "maxEntriesInFile";
    public static final String CONFIG_MAXLOGSIZE = "maxLogSize";
    public static final String CONFIG_MAXLOGFILES = "maxLogFiles";
    private static final String CONFIG_TEMP = "storeInJavaIoTmpdir";
    private final String configPath;
    private final int configMaxEntriesInFile;
    private final int configMaxlogSize;
    private final int configMaxLogFiles;

    protected AbstractAsyncFSWriter(Configuration configuration) {
        super(configuration);
        String path;
        String prefix = this.getClass().getName() + '.';
        if (configuration.getBooleanProperty(prefix + CONFIG_TEMP)) {
            LogFactory.getLog(this.getClass()).warn("Using deprecated configuration property " + prefix + CONFIG_TEMP + ". Instead use empty value for " + prefix + CONFIG_PATH);
        }
        if ((path = configuration.getStringProperty(prefix + CONFIG_PATH)).length() == 0) {
            path = System.getProperty("java.io.tmpdir");
        }
        if (!new File(path).isDirectory()) {
            throw new IllegalArgumentException("'" + path + "' is not a directory.");
        }
        this.configPath = path;
        this.configMaxEntriesInFile = configuration.getIntProperty(prefix + CONFIG_MAXENTRIESINFILE);
        if (this.configMaxEntriesInFile < 1) {
            throw new IllegalArgumentException(prefix + CONFIG_MAXENTRIESINFILE + " must be greater than 0 but is '" + this.configMaxEntriesInFile + "'");
        }
        this.configMaxlogSize = configuration.getIntProperty(prefix + CONFIG_MAXLOGSIZE);
        this.configMaxLogFiles = configuration.getIntProperty(prefix + CONFIG_MAXLOGFILES);
    }

    @Override
    protected Configuration getDefaultConfiguration() {
        Configuration configuration = new Configuration(super.getDefaultConfiguration());
        String prefix = this.getClass().getName() + ".";
        configuration.setProperty(prefix + CONFIG_PATH, "");
        configuration.setProperty(prefix + CONFIG_MAXENTRIESINFILE, "25000");
        configuration.setProperty(prefix + CONFIG_MAXLOGSIZE, "-1");
        configuration.setProperty(prefix + CONFIG_MAXLOGFILES, "-1");
        return configuration;
    }

    @Override
    protected final void init() throws Exception {
        String ctrlName = this.monitoringController.getHostname() + "-" + this.monitoringController.getName();
        SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd'-'HHmmssSSS", Locale.US);
        date.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateStr = date.format(new Date());
        StringBuffer sb = new StringBuffer(this.configPath.length() + "kieker".length() + ctrlName.length() + 26);
        sb.append(this.configPath).append(File.separatorChar).append("kieker").append('-').append(dateStr).append("-UTC-").append(ctrlName).append(File.separatorChar);
        String path = sb.toString();
        File f = new File(path);
        if (!f.mkdir()) {
            throw new IllegalArgumentException("Failed to create directory '" + path + "'");
        }
        MappingFileWriter mappingFileWriter = new MappingFileWriter(path);
        this.addWorker(this.initWorker(this.monitoringController, this.blockingQueue, mappingFileWriter, path, this.configMaxEntriesInFile, this.configMaxlogSize, this.configMaxLogFiles));
        this.addWorker(this.initWorker(this.monitoringController, this.prioritizedBlockingQueue, mappingFileWriter, path, this.configMaxEntriesInFile, this.configMaxlogSize, this.configMaxLogFiles));
    }

    protected abstract AbstractFsWriterThread initWorker(IMonitoringController var1, BlockingQueue<IMonitoringRecord> var2, MappingFileWriter var3, String var4, int var5, int var6, int var7);
}

