/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import java.util.concurrent.atomic.AtomicLong;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.RegistryRecord;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.IWriterController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.writer.IMonitoringWriter;

public final class WriterController
extends AbstractController
implements IWriterController {
    private static final Log LOG = LogFactory.getLog(WriterController.class);
    private final AtomicLong numberOfInserts = new AtomicLong(0L);
    private final IMonitoringWriter monitoringWriter;
    private final boolean autoSetLoggingTimestamp;
    private final boolean logMetadataRecord;

    public WriterController(Configuration configuration) {
        super(configuration);
        this.logMetadataRecord = configuration.getBooleanProperty("kieker.monitoring.metadata");
        this.autoSetLoggingTimestamp = configuration.getBooleanProperty("kieker.monitoring.setLoggingTimestamp");
        this.monitoringWriter = AbstractController.createAndInitialize(IMonitoringWriter.class, configuration.getStringProperty("kieker.monitoring.writer"), configuration);
        if (this.monitoringWriter == null) {
            this.terminate();
            return;
        }
    }

    @Override
    protected final void init() {
        if (this.monitoringWriter != null) {
            try {
                this.monitoringWriter.setController(this.monitoringController);
            }
            catch (Exception e) {
                LOG.error("Error initializing writer", e);
                this.terminate();
            }
        }
    }

    @Override
    protected final void cleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutting down Writer Controller");
        }
        if (this.monitoringWriter != null) {
            this.monitoringWriter.terminate();
        }
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("WriterController:\n\tNumber of Inserts: '");
        sb.append(this.getNumberOfInserts());
        sb.append("'\n\tAutomatic assignment of logging timestamps: '");
        sb.append(this.autoSetLoggingTimestamp);
        sb.append("'\n");
        if (this.monitoringWriter != null) {
            sb.append(((Object)this.monitoringWriter).toString());
        } else {
            sb.append("\tNo Monitoring Writer available");
        }
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public final boolean newMonitoringRecord(IMonitoringRecord record) {
        try {
            if (!(record instanceof RegistryRecord)) {
                MonitoringController monitoringController = this.monitoringController;
                if (!monitoringController.isMonitoringEnabled()) {
                    return false;
                }
                if (this.autoSetLoggingTimestamp) {
                    record.setLoggingTimestamp(monitoringController.getTimeSource().getTime());
                }
                if (0L == this.numberOfInserts.getAndIncrement() && this.logMetadataRecord) {
                    this.monitoringController.sendMetadataAsRecord();
                }
                if (!this.monitoringWriter.newMonitoringRecord(record)) {
                    LOG.error("Error writing the monitoring data. Will terminate monitoring!");
                    this.terminate();
                    return false;
                }
            } else if (!this.monitoringWriter.newMonitoringRecordNonBlocking(record)) {
                LOG.error("Error writing the monitoring data. Will terminate monitoring!");
                this.terminate();
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            LOG.error("Exception detected. Will terminate monitoring", ex);
            this.terminate();
            return false;
        }
    }

    @Override
    public final long getNumberOfInserts() {
        return this.numberOfInserts.longValue();
    }
}

