/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.monitoring.core.controller.MonitoringController;

public abstract class AbstractController {
    private static final Log LOG = LogFactory.getLog(AbstractController.class);
    protected volatile MonitoringController monitoringController;
    private final AtomicBoolean terminated = new AtomicBoolean(false);

    protected AbstractController(Configuration configuration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setMonitoringController(MonitoringController monitoringController) {
        AbstractController abstractController = this;
        synchronized (abstractController) {
            if (this.monitoringController == null) {
                this.monitoringController = monitoringController;
                if (!this.monitoringController.isTerminated()) {
                    this.init();
                }
            }
        }
    }

    protected final boolean terminate() {
        if (!this.terminated.getAndSet(true)) {
            this.cleanup();
            if (this.monitoringController != null) {
                this.monitoringController.terminate();
            }
            return true;
        }
        return false;
    }

    protected final boolean isTerminated() {
        return this.terminated.get();
    }

    protected abstract void init();

    protected abstract void cleanup();

    public abstract String toString();

    protected static final <C> C createAndInitialize(Class<C> c, String classname, Configuration configuration) {
        C createdClass = null;
        try {
            Class<?> clazz = Class.forName(classname);
            if (c.isAssignableFrom(clazz)) {
                createdClass = (C)clazz.getConstructor(Configuration.class).newInstance(configuration.getPropertiesStartingWith(classname));
            } else {
                LOG.error("Class '" + classname + "' has to implement '" + c.getSimpleName() + "'");
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error(c.getSimpleName() + ": Class '" + classname + "' not found", e);
        }
        catch (NoSuchMethodException e) {
            LOG.error(c.getSimpleName() + ": Class '" + classname + "' has to implement a (public) constructor that accepts a single Configuration", e);
        }
        catch (Exception e) {
            LOG.error(c.getSimpleName() + ": Failed to load class for name '" + classname + "'", e);
        }
        return createdClass;
    }
}

