/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.forward;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;

@Plugin(programmaticOnly=true, description="A filter collecting incoming objects in a list (mostly used in testing scenarios)", outputPorts={@OutputPort(name="outputObjects", eventTypes={Object.class}, description="Provides each incoming object")}, configuration={@Property(name="maxNumberOfEntries", defaultValue="-1", description="Sets the maximum number of stored values."), @Property(name="listFullBehavior", defaultValue="dropOldest", description="Determines what happens to new objects when the list is full.")})
public class ListCollectionFilter<T>
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME = "inputObject";
    public static final String OUTPUT_PORT_NAME = "outputObjects";
    public static final String CONFIG_PROPERTY_NAME_MAX_NUMBER_OF_ENTRIES = "maxNumberOfEntries";
    public static final String CONFIG_PROPERTY_VALUE_NUMBER_OF_ENTRIES = "-1";
    public static final String CONFIG_PROPERTY_NAME_LIST_FULL_BEHAVIOR = "listFullBehavior";
    public static final String CONFIG_PROPERTY_VALUE_LIST_FULL_BEHAVIOR = "dropOldest";
    private final LinkedList<T> list;
    private final int maxNumberOfEntries;
    private final boolean unboundedList;
    private final ListFullBehavior listFullBehavior;

    public ListCollectionFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        ListFullBehavior tmpListFullBehavior;
        this.maxNumberOfEntries = configuration.getIntProperty(CONFIG_PROPERTY_NAME_MAX_NUMBER_OF_ENTRIES);
        this.unboundedList = this.maxNumberOfEntries < 0;
        String strListFullBehavior = configuration.getStringProperty(CONFIG_PROPERTY_NAME_LIST_FULL_BEHAVIOR);
        try {
            tmpListFullBehavior = ListFullBehavior.valueOf(strListFullBehavior);
        }
        catch (IllegalArgumentException ex) {
            this.log.warn(strListFullBehavior + " is no valid list full behavior! Using 'ignore' instead.");
            tmpListFullBehavior = ListFullBehavior.ignore;
        }
        this.listFullBehavior = tmpListFullBehavior;
        this.list = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputPort(name="inputObject")
    public void input(T data) {
        if (this.unboundedList) {
            LinkedList<T> linkedList = this.list;
            synchronized (linkedList) {
                this.list.add(data);
            }
        } else {
            switch (this.listFullBehavior) {
                case dropOldest: {
                    LinkedList<T> linkedList = this.list;
                    synchronized (linkedList) {
                        this.list.add(data);
                        if (this.list.size() > this.maxNumberOfEntries) {
                            this.list.removeFirst();
                        }
                        break;
                    }
                }
                case ignore: {
                    LinkedList<T> linkedList = this.list;
                    synchronized (linkedList) {
                        if (this.maxNumberOfEntries > this.list.size()) {
                            this.list.add(data);
                        }
                        break;
                    }
                }
                case error: {
                    LinkedList<T> linkedList = this.list;
                    synchronized (linkedList) {
                        if (this.maxNumberOfEntries <= this.list.size()) {
                            throw new RuntimeException("Too many records for ListCollectionFilter, it was initialized with capacity: " + this.maxNumberOfEntries);
                        }
                        this.list.add(data);
                        break;
                    }
                }
            }
        }
        super.deliver(OUTPUT_PORT_NAME, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<T> linkedList = this.list;
        synchronized (linkedList) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getList() {
        LinkedList<T> linkedList = this.list;
        synchronized (linkedList) {
            return new CopyOnWriteArrayList<T>(this.list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList<T> linkedList = this.list;
        synchronized (linkedList) {
            return this.list.size();
        }
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_MAX_NUMBER_OF_ENTRIES, String.valueOf(this.maxNumberOfEntries));
        configuration.setProperty(CONFIG_PROPERTY_NAME_LIST_FULL_BEHAVIOR, this.listFullBehavior.name());
        return configuration;
    }

    public static enum ListFullBehavior {
        dropOldest,
        ignore,
        error;

    }
}

