/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.LogFactoryImpl;

public final class Jdk14LoggerPatched
extends Jdk14Logger {
    private static final long serialVersionUID = 1L;

    public Jdk14LoggerPatched(String name) {
        super(name);
    }

    public static final Log getLog(String name) {
        LogFactory commonsFactory = LogFactory.getFactory();
        try {
            LogFactoryImpl commonsFactoryImpl;
            if (commonsFactory instanceof LogFactoryImpl && "org.apache.commons.logging.impl.Jdk14Logger".equals((commonsFactoryImpl = (LogFactoryImpl)commonsFactory).getLogClassName()) && commonsFactoryImpl.instances.get(name) == null) {
                Jdk14LoggerPatched instance = new Jdk14LoggerPatched(name);
                commonsFactoryImpl.instances.put(name, instance);
                return instance;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return commonsFactory.getInstance(name);
    }

    private final void logpatched(Level level, String msg, Throwable ex) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(level)) {
            String cname = this.name;
            StackTraceElement[] locations = new Throwable().getStackTrace();
            String method = locations.length > 3 ? locations[3].getMethodName() : "unknown";
            if (ex == null) {
                logger.logp(level, cname, method, msg);
            } else {
                logger.logp(level, cname, method, msg, ex);
            }
        }
    }

    public final void debug(Object message) {
        this.logpatched(Level.FINE, String.valueOf(message), null);
    }

    public final void debug(Object message, Throwable exception) {
        this.logpatched(Level.FINE, String.valueOf(message), exception);
    }

    public final void info(Object message) {
        this.logpatched(Level.INFO, String.valueOf(message), null);
    }

    public final void info(Object message, Throwable exception) {
        this.logpatched(Level.INFO, String.valueOf(message), exception);
    }

    public final void warn(Object message) {
        this.logpatched(Level.WARNING, String.valueOf(message), null);
    }

    public final void warn(Object message, Throwable exception) {
        this.logpatched(Level.WARNING, String.valueOf(message), exception);
    }

    public final void error(Object message) {
        this.logpatched(Level.SEVERE, String.valueOf(message), null);
    }

    public final void error(Object message, Throwable exception) {
        this.logpatched(Level.SEVERE, String.valueOf(message), exception);
    }
}

