/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import kieker.tools.traceAnalysis.gui.AbstractStep;
import kieker.tools.traceAnalysis.gui.util.AllSelectionBindingItemListener;
import kieker.tools.traceAnalysis.gui.util.SelectionBindingItemListener;

public class PlotStep
extends AbstractStep {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_KEY_IDENTIFIER = PlotStep.class.getSimpleName();
    private static final String PROPERTY_KEY_DEPLOYMENT_SEQUENCE_DIAGRAMS = PROPERTY_KEY_IDENTIFIER + ".deploymentSequenceDiagrams";
    private static final String PROPERTY_KEY_ASSEMBLY_SEQUENCE_DIAGRAMS = PROPERTY_KEY_IDENTIFIER + ".assemblySequenceDiagrams";
    private static final String PROPERTY_KEY_DEPLOYMENT_COMPONENT_DEPENDENCY_GRAPH = PROPERTY_KEY_IDENTIFIER + ".deploymentComponentDependencyGraph";
    private static final String PROPERTY_KEY_DEPLOYMENT_COMPONENT_DEPENDENCY_GRAPH_RT = PROPERTY_KEY_IDENTIFIER + ".deploymentComponentDependencyGraphResponseTime";
    private static final String PROPERTY_KEY_DEPLOYMENT_COMPONENT_DEPENDENCY_GRAPH_RT_CB = PROPERTY_KEY_IDENTIFIER + ".deploymentComponentDependencyGraphResponseTimeComboBox";
    private static final String PROPERTY_KEY_ASSEMBLY_COMPONENT_DEPENDENCY_GRAPH = PROPERTY_KEY_IDENTIFIER + ".assemblyComponentDependencyGraph";
    private static final String PROPERTY_KEY_ASSEMBLY_COMPONENT_DEPENDENCY_GRAPH_RT = PROPERTY_KEY_IDENTIFIER + ".assemblyComponentDependencyGraphResponseTime";
    private static final String PROPERTY_KEY_ASSEMBLY_COMPONENT_DEPENDENCY_GRAPH_RT_CB = PROPERTY_KEY_IDENTIFIER + ".assemblyComponentDependencyGraphResponseTimeComboBox";
    private static final String PROPERTY_KEY_CONTAINER_DEPENDENCY_GRAPH = PROPERTY_KEY_IDENTIFIER + ".containerDependencyGraph";
    private static final String PROPERTY_KEY_DEPLOYMENT_OPERATION_DEPENDENCY_GRAPH = PROPERTY_KEY_IDENTIFIER + ".deploymentOperationDependencyGraph";
    private static final String PROPERTY_KEY_DEPLOYMENT_OPERATION_DEPENDENCY_GRAPH_RT = PROPERTY_KEY_IDENTIFIER + ".deploymentOperationDependencyGraphResponseTime";
    private static final String PROPERTY_KEY_DEPLOYMENT_OPERATION_DEPENDENCY_GRAPH_RT_CB = PROPERTY_KEY_IDENTIFIER + ".deploymentOperationDependencyGraphResponseTimeComboBox";
    private static final String PROPERTY_KEY_ASSEMBLY_OPERATION_DEPENDENCY_GRAPH = PROPERTY_KEY_IDENTIFIER + ".assemblyOperationDependencyGraph";
    private static final String PROPERTY_KEY_ASSEMBLY_OPERATION_DEPENDENCY_GRAPH_RT = PROPERTY_KEY_IDENTIFIER + ".assemblyOperationDependencyGraphResponseTime";
    private static final String PROPERTY_KEY_ASSEMBLY_OPERATION_DEPENDENCY_GRAPH_RT_CB = PROPERTY_KEY_IDENTIFIER + ".assemblyOperationDependencyGraphResponseTimeCOmboBox";
    private static final String PROPERTY_KEY_AGGREGATED_DEPLOYMENT_CALL_TREE = PROPERTY_KEY_IDENTIFIER + ".aggregatedDeploymentCallTree";
    private static final String PROPERTY_KEY_AGGREGATED_ASSEMBLY_CALL_TREE = PROPERTY_KEY_IDENTIFIER + ".aggregatedAssemblyCallTree";
    private static final String PROPERTY_KEY_CALL_TREES = PROPERTY_KEY_IDENTIFIER + ".callTrees";
    private final JLabel infoLabel = new JLabel("In this step you choose plots to be generated by the trace analysis.");
    private final JCheckBox deploymentSequenceDiagrams = new JCheckBox("Deployment Sequence Diagrams");
    private final JCheckBox assemblySequenceDiagrams = new JCheckBox("Assembly Sequence Diagrams");
    private final JCheckBox deploymentComponentDependencyGraph = new JCheckBox("Deployment Component Dependency Graph");
    private final JCheckBox deploymentComponentDependencyGraphResponseTime = new JCheckBox("Response Times");
    private final JCheckBox assemblyComponentDependencyGraph = new JCheckBox("Assembly Component Dependency Graph");
    private final JCheckBox assemblyComponentDependencyGraphResponseTime = new JCheckBox("Response Times");
    private final JCheckBox containerDependencyGraph = new JCheckBox("Plot Container Dependency Graph");
    private final JCheckBox deploymentOperationDependencyGraph = new JCheckBox("Deployment Operation Dependency Graph");
    private final JCheckBox deploymentOperationDependencyGraphResponseTime = new JCheckBox("Response Times");
    private final JCheckBox assemblyOperationDependencyGraph = new JCheckBox("Assembly Operation Dependency Graph");
    private final JCheckBox assemblyOperationDependencyGraphResponseTime = new JCheckBox("Response Times");
    private final JCheckBox aggregatedDeploymentCallTree = new JCheckBox("Aggregated Deployment Call Tree");
    private final JCheckBox aggregatedAssemblyCallTree = new JCheckBox("Aggregated Assembly Call Tree");
    private final JCheckBox callTrees = new JCheckBox("Call Trees");
    private final JCheckBox allGraphs = new JCheckBox("Select All");
    private final JPanel expandingPanel = new JPanel();
    private final String[] responseTimeStrings = new String[]{"ns", "us", "ms", "s"};
    private final JComboBox deploymentComponentDependencyGraphResponseTimeComboBox = new JComboBox<String>(this.responseTimeStrings);
    private final JComboBox assemblyComponentDependencyGraphResponseTimeComboBox = new JComboBox<String>(this.responseTimeStrings);
    private final JComboBox deploymentOperationDependencyGraphResponseTimeComboBox = new JComboBox<String>(this.responseTimeStrings);
    private final JComboBox assemblyOperationDependencyGraphResponseTimeComboBox = new JComboBox<String>(this.responseTimeStrings);

    public PlotStep() {
        this.addAndLayoutComponents();
        this.addLogicToComponents();
    }

    private void addAndLayoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints infoLabelConstraints = new GridBagConstraints();
        infoLabelConstraints.gridwidth = 0;
        infoLabelConstraints.anchor = 18;
        infoLabelConstraints.insets.set(5, 5, 5, 5);
        infoLabelConstraints.weightx = 1.0;
        infoLabelConstraints.fill = 1;
        this.add((Component)this.infoLabel, infoLabelConstraints);
        GridBagConstraints deploymentSequenceDiagramsConstraints = new GridBagConstraints();
        deploymentSequenceDiagramsConstraints.gridwidth = 0;
        deploymentSequenceDiagramsConstraints.insets.set(5, 5, 0, 0);
        deploymentSequenceDiagramsConstraints.weightx = 0.0;
        deploymentSequenceDiagramsConstraints.fill = 1;
        this.add((Component)this.deploymentSequenceDiagrams, deploymentSequenceDiagramsConstraints);
        GridBagConstraints assemblySequenceDiagramsConstraints = new GridBagConstraints();
        assemblySequenceDiagramsConstraints.gridwidth = 0;
        assemblySequenceDiagramsConstraints.insets.set(0, 5, 0, 0);
        assemblySequenceDiagramsConstraints.fill = 1;
        this.add((Component)this.assemblySequenceDiagrams, assemblySequenceDiagramsConstraints);
        GridBagConstraints deploymentComponentDependencyGraphConstraints = new GridBagConstraints();
        deploymentComponentDependencyGraphConstraints.insets.set(0, 5, 0, 0);
        deploymentComponentDependencyGraphConstraints.fill = 1;
        deploymentComponentDependencyGraphConstraints.gridx = 1;
        deploymentComponentDependencyGraphConstraints.gridy = 4;
        this.add((Component)this.deploymentComponentDependencyGraph, deploymentComponentDependencyGraphConstraints);
        GridBagConstraints deploymentComponentDependencyGraphResponseTimeConstraints = new GridBagConstraints();
        deploymentComponentDependencyGraphResponseTimeConstraints.insets.set(0, 5, 0, 0);
        deploymentComponentDependencyGraphResponseTimeConstraints.fill = 1;
        deploymentComponentDependencyGraphResponseTimeConstraints.gridx = 2;
        deploymentComponentDependencyGraphResponseTimeConstraints.gridy = 4;
        this.add((Component)this.deploymentComponentDependencyGraphResponseTime, deploymentComponentDependencyGraphResponseTimeConstraints);
        GridBagConstraints responseTimeComboBoxConstraints = new GridBagConstraints();
        responseTimeComboBoxConstraints.gridwidth = 0;
        responseTimeComboBoxConstraints.anchor = 21;
        responseTimeComboBoxConstraints.insets.set(0, 5, 0, 0);
        responseTimeComboBoxConstraints.fill = 0;
        responseTimeComboBoxConstraints.gridx = 3;
        responseTimeComboBoxConstraints.gridy = 4;
        this.add((Component)this.deploymentComponentDependencyGraphResponseTimeComboBox, responseTimeComboBoxConstraints);
        GridBagConstraints assemblyComponentDependencyGraphConstraints = new GridBagConstraints();
        assemblyComponentDependencyGraphConstraints.insets.set(0, 5, 0, 0);
        assemblyComponentDependencyGraphConstraints.fill = 1;
        assemblyComponentDependencyGraphConstraints.gridx = 1;
        assemblyComponentDependencyGraphConstraints.gridy = 5;
        this.add((Component)this.assemblyComponentDependencyGraph, assemblyComponentDependencyGraphConstraints);
        GridBagConstraints assemblyComponentDependencyGraphResponseTimeConstraints = new GridBagConstraints();
        assemblyComponentDependencyGraphResponseTimeConstraints.insets.set(0, 5, 0, 0);
        assemblyComponentDependencyGraphResponseTimeConstraints.fill = 1;
        assemblyComponentDependencyGraphResponseTimeConstraints.gridx = 2;
        assemblyComponentDependencyGraphResponseTimeConstraints.gridy = 5;
        this.add((Component)this.assemblyComponentDependencyGraphResponseTime, assemblyComponentDependencyGraphResponseTimeConstraints);
        responseTimeComboBoxConstraints.gridy = 5;
        this.add((Component)this.assemblyComponentDependencyGraphResponseTimeComboBox, responseTimeComboBoxConstraints);
        GridBagConstraints containerDependencyGraphConstraints = new GridBagConstraints();
        containerDependencyGraphConstraints.gridwidth = 0;
        containerDependencyGraphConstraints.insets.set(0, 5, 0, 0);
        containerDependencyGraphConstraints.fill = 1;
        this.add((Component)this.containerDependencyGraph, containerDependencyGraphConstraints);
        GridBagConstraints deploymentOperationDependencyGraphConstraints = new GridBagConstraints();
        deploymentOperationDependencyGraphConstraints.insets.set(0, 5, 0, 0);
        deploymentOperationDependencyGraphConstraints.fill = 1;
        deploymentOperationDependencyGraphConstraints.gridx = 1;
        deploymentOperationDependencyGraphConstraints.gridy = 7;
        this.add((Component)this.deploymentOperationDependencyGraph, deploymentOperationDependencyGraphConstraints);
        GridBagConstraints deploymentOperationDependencyGraphResponseTimeConstraints = new GridBagConstraints();
        deploymentOperationDependencyGraphResponseTimeConstraints.insets.set(0, 5, 0, 0);
        deploymentOperationDependencyGraphResponseTimeConstraints.fill = 1;
        deploymentOperationDependencyGraphResponseTimeConstraints.gridx = 2;
        deploymentOperationDependencyGraphResponseTimeConstraints.gridy = 7;
        this.add((Component)this.deploymentOperationDependencyGraphResponseTime, deploymentOperationDependencyGraphResponseTimeConstraints);
        responseTimeComboBoxConstraints.gridy = 7;
        this.add((Component)this.deploymentOperationDependencyGraphResponseTimeComboBox, responseTimeComboBoxConstraints);
        GridBagConstraints assemblyOperationDependencyGraphConstraints = new GridBagConstraints();
        assemblyOperationDependencyGraphConstraints.insets.set(0, 5, 0, 0);
        assemblyOperationDependencyGraphConstraints.fill = 1;
        assemblyOperationDependencyGraphConstraints.gridx = 1;
        assemblyOperationDependencyGraphConstraints.gridy = 8;
        this.add((Component)this.assemblyOperationDependencyGraph, assemblyOperationDependencyGraphConstraints);
        GridBagConstraints assemblyOperationDependencyGraphResponseTimeConstraints = new GridBagConstraints();
        assemblyOperationDependencyGraphResponseTimeConstraints.insets.set(0, 5, 0, 0);
        assemblyOperationDependencyGraphResponseTimeConstraints.fill = 1;
        assemblyOperationDependencyGraphResponseTimeConstraints.gridx = 2;
        assemblyOperationDependencyGraphResponseTimeConstraints.gridy = 8;
        this.add((Component)this.assemblyOperationDependencyGraphResponseTime, assemblyOperationDependencyGraphResponseTimeConstraints);
        responseTimeComboBoxConstraints.gridy = 8;
        this.add((Component)this.assemblyOperationDependencyGraphResponseTimeComboBox, responseTimeComboBoxConstraints);
        GridBagConstraints aggregatedDeploymentCallTreeConstraints = new GridBagConstraints();
        aggregatedDeploymentCallTreeConstraints.gridwidth = 0;
        aggregatedDeploymentCallTreeConstraints.insets.set(0, 5, 0, 0);
        aggregatedDeploymentCallTreeConstraints.fill = 1;
        this.add((Component)this.aggregatedDeploymentCallTree, aggregatedDeploymentCallTreeConstraints);
        GridBagConstraints aggregatedAssemblyCallTreeConstraints = new GridBagConstraints();
        aggregatedAssemblyCallTreeConstraints.gridwidth = 0;
        aggregatedAssemblyCallTreeConstraints.insets.set(0, 5, 0, 0);
        aggregatedAssemblyCallTreeConstraints.fill = 1;
        this.add((Component)this.aggregatedAssemblyCallTree, aggregatedAssemblyCallTreeConstraints);
        GridBagConstraints callTreesConstraints = new GridBagConstraints();
        callTreesConstraints.gridwidth = 0;
        callTreesConstraints.insets.set(0, 5, 0, 0);
        callTreesConstraints.fill = 1;
        this.add((Component)this.callTrees, callTreesConstraints);
        GridBagConstraints allGraphsConstraints = new GridBagConstraints();
        allGraphsConstraints.gridwidth = 0;
        allGraphsConstraints.insets.set(10, 5, 5, 5);
        allGraphsConstraints.fill = 1;
        this.add((Component)this.allGraphs, allGraphsConstraints);
        GridBagConstraints expandingPanelConstraints = new GridBagConstraints();
        expandingPanelConstraints.gridwidth = 0;
        expandingPanelConstraints.weighty = 1.0;
        expandingPanelConstraints.fill = 3;
        this.add((Component)this.expandingPanel, expandingPanelConstraints);
    }

    private void addLogicToComponents() {
        this.allGraphs.addItemListener(new AllSelectionBindingItemListener(this.deploymentSequenceDiagrams, this.assemblySequenceDiagrams, this.deploymentComponentDependencyGraph, this.deploymentComponentDependencyGraphResponseTime, this.assemblyComponentDependencyGraph, this.assemblyComponentDependencyGraphResponseTime, this.assemblyComponentDependencyGraphResponseTime, this.containerDependencyGraph, this.deploymentOperationDependencyGraph, this.deploymentOperationDependencyGraphResponseTime, this.assemblyOperationDependencyGraph, this.assemblyOperationDependencyGraph, this.assemblyOperationDependencyGraphResponseTime, this.aggregatedDeploymentCallTree, this.aggregatedAssemblyCallTree, this.callTrees));
        this.deploymentComponentDependencyGraph.addItemListener(new SelectionBindingItemListener(this.deploymentComponentDependencyGraphResponseTime, true));
        this.deploymentComponentDependencyGraphResponseTime.addItemListener(new SelectionBindingItemListener(this.deploymentComponentDependencyGraph, false));
        this.deploymentComponentDependencyGraphResponseTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotStep.this.deploymentComponentDependencyGraphResponseTimeComboBox.setEnabled(PlotStep.this.deploymentComponentDependencyGraphResponseTime.isSelected());
            }
        });
        this.assemblyComponentDependencyGraph.addItemListener(new SelectionBindingItemListener(this.assemblyComponentDependencyGraphResponseTime, true));
        this.assemblyComponentDependencyGraphResponseTime.addItemListener(new SelectionBindingItemListener(this.assemblyComponentDependencyGraph, false));
        this.assemblyComponentDependencyGraphResponseTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotStep.this.assemblyComponentDependencyGraphResponseTimeComboBox.setEnabled(PlotStep.this.assemblyComponentDependencyGraphResponseTime.isSelected());
            }
        });
        this.deploymentOperationDependencyGraph.addItemListener(new SelectionBindingItemListener(this.deploymentOperationDependencyGraphResponseTime, true));
        this.deploymentOperationDependencyGraphResponseTime.addItemListener(new SelectionBindingItemListener(this.deploymentOperationDependencyGraph, false));
        this.deploymentOperationDependencyGraphResponseTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotStep.this.deploymentOperationDependencyGraphResponseTimeComboBox.setEnabled(PlotStep.this.deploymentOperationDependencyGraphResponseTime.isSelected());
            }
        });
        this.assemblyOperationDependencyGraph.addItemListener(new SelectionBindingItemListener(this.assemblyOperationDependencyGraphResponseTime, true));
        this.assemblyOperationDependencyGraphResponseTime.addItemListener(new SelectionBindingItemListener(this.assemblyOperationDependencyGraph, false));
        this.assemblyOperationDependencyGraphResponseTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotStep.this.assemblyOperationDependencyGraphResponseTimeComboBox.setEnabled(PlotStep.this.assemblyOperationDependencyGraphResponseTime.isSelected());
            }
        });
    }

    @Override
    public boolean isNextStepAllowed() {
        boolean nothingSelected;
        boolean bl = nothingSelected = !this.deploymentSequenceDiagrams.isSelected() && !this.assemblySequenceDiagrams.isSelected() && !this.deploymentComponentDependencyGraph.isSelected() && !this.assemblyComponentDependencyGraph.isSelected() && !this.containerDependencyGraph.isSelected() && !this.deploymentOperationDependencyGraph.isSelected() && !this.assemblyOperationDependencyGraph.isSelected() && !this.aggregatedDeploymentCallTree.isSelected() && !this.aggregatedAssemblyCallTree.isSelected() && !this.callTrees.isSelected();
        if (nothingSelected) {
            int result = JOptionPane.showConfirmDialog(this, "No plots have been selected. Continue?", "No Plots Selected", 0, 2);
            return 0 == result;
        }
        return true;
    }

    @Override
    public void addSelectedTraceAnalysisParameters(Collection<String> parameters) {
        if (this.deploymentSequenceDiagrams.isSelected()) {
            parameters.add("--plot-Deployment-Sequence-Diagrams");
        }
        if (this.assemblySequenceDiagrams.isSelected()) {
            parameters.add("--plot-Assembly-Sequence-Diagrams");
        }
        if (this.deploymentComponentDependencyGraph.isSelected()) {
            parameters.add("--plot-Deployment-Component-Dependency-Graph");
            if (this.deploymentComponentDependencyGraphResponseTime.isSelected()) {
                switch (this.deploymentComponentDependencyGraphResponseTimeComboBox.getSelectedIndex()) {
                    case 0: {
                        parameters.add("responseTimes-ns");
                        break;
                    }
                    case 1: {
                        parameters.add("responseTimes-us");
                        break;
                    }
                    case 2: {
                        parameters.add("responseTimes-ms");
                        break;
                    }
                    case 3: {
                        parameters.add("responseTimes-s");
                        break;
                    }
                }
            }
        }
        if (this.assemblyComponentDependencyGraph.isSelected()) {
            parameters.add("--plot-Assembly-Component-Dependency-Graph");
            if (this.assemblyComponentDependencyGraphResponseTime.isSelected()) {
                switch (this.assemblyComponentDependencyGraphResponseTimeComboBox.getSelectedIndex()) {
                    case 0: {
                        parameters.add("responseTimes-ns");
                        break;
                    }
                    case 1: {
                        parameters.add("responseTimes-us");
                        break;
                    }
                    case 2: {
                        parameters.add("responseTimes-ms");
                        break;
                    }
                    case 3: {
                        parameters.add("responseTimes-s");
                        break;
                    }
                }
            }
        }
        if (this.containerDependencyGraph.isSelected()) {
            parameters.add("--plot-Container-Dependency-Graph");
        }
        if (this.deploymentOperationDependencyGraph.isSelected()) {
            parameters.add("--plot-Deployment-Operation-Dependency-Graph");
            if (this.deploymentOperationDependencyGraphResponseTime.isSelected()) {
                switch (this.deploymentOperationDependencyGraphResponseTimeComboBox.getSelectedIndex()) {
                    case 0: {
                        parameters.add("responseTimes-ns");
                        break;
                    }
                    case 1: {
                        parameters.add("responseTimes-us");
                        break;
                    }
                    case 2: {
                        parameters.add("responseTimes-ms");
                        break;
                    }
                    case 3: {
                        parameters.add("responseTimes-s");
                        break;
                    }
                }
            }
        }
        if (this.assemblyOperationDependencyGraph.isSelected()) {
            parameters.add("--plot-Assembly-Operation-Dependency-Graph");
            if (this.assemblyOperationDependencyGraphResponseTime.isSelected()) {
                switch (this.assemblyOperationDependencyGraphResponseTimeComboBox.getSelectedIndex()) {
                    case 0: {
                        parameters.add("responseTimes-ns");
                        break;
                    }
                    case 1: {
                        parameters.add("responseTimes-us");
                        break;
                    }
                    case 2: {
                        parameters.add("responseTimes-ms");
                        break;
                    }
                    case 3: {
                        parameters.add("responseTimes-s");
                        break;
                    }
                }
            }
        }
        if (this.aggregatedDeploymentCallTree.isSelected()) {
            parameters.add("--plot-Aggregated-Deployment-Call-Tree");
        }
        if (this.aggregatedAssemblyCallTree.isSelected()) {
            parameters.add("--plot-Aggregated-Assembly-Call-Tree");
        }
        if (this.callTrees.isSelected()) {
            parameters.add("--plot-Call-Trees");
        }
    }

    @Override
    public void saveCurrentConfiguration(Properties properties) {
        properties.setProperty(PROPERTY_KEY_DEPLOYMENT_SEQUENCE_DIAGRAMS, Boolean.toString(this.deploymentSequenceDiagrams.isSelected()));
        properties.setProperty(PROPERTY_KEY_ASSEMBLY_SEQUENCE_DIAGRAMS, Boolean.toString(this.assemblySequenceDiagrams.isSelected()));
        properties.setProperty(PROPERTY_KEY_DEPLOYMENT_COMPONENT_DEPENDENCY_GRAPH, Boolean.toString(this.deploymentComponentDependencyGraph.isSelected()));
        properties.setProperty(PROPERTY_KEY_DEPLOYMENT_COMPONENT_DEPENDENCY_GRAPH_RT, Boolean.toString(this.deploymentComponentDependencyGraphResponseTime.isSelected()));
        properties.setProperty(PROPERTY_KEY_DEPLOYMENT_COMPONENT_DEPENDENCY_GRAPH_RT_CB, Integer.toString(this.deploymentComponentDependencyGraphResponseTimeComboBox.getSelectedIndex()));
        properties.setProperty(PROPERTY_KEY_ASSEMBLY_COMPONENT_DEPENDENCY_GRAPH, Boolean.toString(this.assemblyComponentDependencyGraph.isSelected()));
        properties.setProperty(PROPERTY_KEY_ASSEMBLY_COMPONENT_DEPENDENCY_GRAPH_RT, Boolean.toString(this.assemblyComponentDependencyGraphResponseTime.isSelected()));
        properties.setProperty(PROPERTY_KEY_ASSEMBLY_COMPONENT_DEPENDENCY_GRAPH_RT_CB, Integer.toString(this.assemblyComponentDependencyGraphResponseTimeComboBox.getSelectedIndex()));
        properties.setProperty(PROPERTY_KEY_CONTAINER_DEPENDENCY_GRAPH, Boolean.toString(this.containerDependencyGraph.isSelected()));
        properties.setProperty(PROPERTY_KEY_DEPLOYMENT_OPERATION_DEPENDENCY_GRAPH, Boolean.toString(this.deploymentOperationDependencyGraph.isSelected()));
        properties.setProperty(PROPERTY_KEY_DEPLOYMENT_OPERATION_DEPENDENCY_GRAPH_RT, Boolean.toString(this.deploymentOperationDependencyGraphResponseTime.isSelected()));
        properties.setProperty(PROPERTY_KEY_DEPLOYMENT_OPERATION_DEPENDENCY_GRAPH_RT_CB, Integer.toString(this.deploymentOperationDependencyGraphResponseTimeComboBox.getSelectedIndex()));
        properties.setProperty(PROPERTY_KEY_ASSEMBLY_OPERATION_DEPENDENCY_GRAPH, Boolean.toString(this.assemblyOperationDependencyGraph.isSelected()));
        properties.setProperty(PROPERTY_KEY_ASSEMBLY_OPERATION_DEPENDENCY_GRAPH_RT, Boolean.toString(this.assemblyOperationDependencyGraphResponseTime.isSelected()));
        properties.setProperty(PROPERTY_KEY_ASSEMBLY_OPERATION_DEPENDENCY_GRAPH_RT_CB, Integer.toString(this.assemblyOperationDependencyGraphResponseTimeComboBox.getSelectedIndex()));
        properties.setProperty(PROPERTY_KEY_AGGREGATED_DEPLOYMENT_CALL_TREE, Boolean.toString(this.aggregatedDeploymentCallTree.isSelected()));
        properties.setProperty(PROPERTY_KEY_AGGREGATED_ASSEMBLY_CALL_TREE, Boolean.toString(this.aggregatedAssemblyCallTree.isSelected()));
        properties.setProperty(PROPERTY_KEY_CALL_TREES, Boolean.toString(this.callTrees.isSelected()));
    }

    @Override
    public void loadCurrentConfiguration(Properties properties) {
        this.deploymentSequenceDiagrams.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_DEPLOYMENT_SEQUENCE_DIAGRAMS)));
        this.assemblySequenceDiagrams.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_ASSEMBLY_SEQUENCE_DIAGRAMS)));
        this.deploymentComponentDependencyGraph.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_DEPLOYMENT_COMPONENT_DEPENDENCY_GRAPH)));
        this.deploymentComponentDependencyGraphResponseTime.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_DEPLOYMENT_COMPONENT_DEPENDENCY_GRAPH_RT)));
        this.deploymentComponentDependencyGraphResponseTimeComboBox.setSelectedIndex(Integer.parseInt(properties.getProperty(PROPERTY_KEY_DEPLOYMENT_COMPONENT_DEPENDENCY_GRAPH_RT_CB)));
        this.assemblyComponentDependencyGraph.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_ASSEMBLY_COMPONENT_DEPENDENCY_GRAPH)));
        this.assemblyComponentDependencyGraphResponseTime.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_ASSEMBLY_COMPONENT_DEPENDENCY_GRAPH_RT)));
        this.assemblyComponentDependencyGraphResponseTimeComboBox.setSelectedIndex(Integer.parseInt(properties.getProperty(PROPERTY_KEY_ASSEMBLY_COMPONENT_DEPENDENCY_GRAPH_RT_CB)));
        this.containerDependencyGraph.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_CONTAINER_DEPENDENCY_GRAPH)));
        this.deploymentOperationDependencyGraph.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_DEPLOYMENT_OPERATION_DEPENDENCY_GRAPH)));
        this.deploymentOperationDependencyGraphResponseTime.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_DEPLOYMENT_OPERATION_DEPENDENCY_GRAPH_RT)));
        this.deploymentOperationDependencyGraphResponseTimeComboBox.setSelectedIndex(Integer.parseInt(properties.getProperty(PROPERTY_KEY_DEPLOYMENT_OPERATION_DEPENDENCY_GRAPH_RT_CB)));
        this.assemblyOperationDependencyGraph.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_ASSEMBLY_OPERATION_DEPENDENCY_GRAPH)));
        this.assemblyOperationDependencyGraphResponseTime.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_ASSEMBLY_OPERATION_DEPENDENCY_GRAPH_RT)));
        this.assemblyOperationDependencyGraphResponseTimeComboBox.setSelectedIndex(Integer.parseInt(properties.getProperty(PROPERTY_KEY_ASSEMBLY_OPERATION_DEPENDENCY_GRAPH_RT_CB)));
        this.aggregatedDeploymentCallTree.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_AGGREGATED_DEPLOYMENT_CALL_TREE)));
        this.aggregatedAssemblyCallTree.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_AGGREGATED_ASSEMBLY_CALL_TREE)));
        this.callTrees.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_CALL_TREES)));
        this.assemblyComponentDependencyGraphResponseTimeComboBox.setEnabled(this.assemblyComponentDependencyGraphResponseTime.isSelected());
        this.assemblyOperationDependencyGraphResponseTimeComboBox.setEnabled(this.assemblyOperationDependencyGraphResponseTime.isSelected());
        this.deploymentComponentDependencyGraphResponseTimeComboBox.setEnabled(this.deploymentComponentDependencyGraphResponseTime.isSelected());
        this.deploymentOperationDependencyGraphResponseTimeComboBox.setEnabled(this.deploymentOperationDependencyGraphResponseTime.isSelected());
    }

    @Override
    public void loadDefaultConfiguration() {
        this.assemblyComponentDependencyGraph.setSelected(true);
        this.assemblyComponentDependencyGraphResponseTime.setSelected(true);
        this.assemblyComponentDependencyGraphResponseTimeComboBox.setSelectedIndex(2);
        this.assemblyComponentDependencyGraphResponseTimeComboBox.setEnabled(true);
        this.assemblyOperationDependencyGraph.setSelected(true);
        this.assemblyOperationDependencyGraphResponseTime.setSelected(true);
        this.assemblyOperationDependencyGraphResponseTimeComboBox.setSelectedIndex(2);
        this.assemblyOperationDependencyGraphResponseTimeComboBox.setEnabled(true);
        this.deploymentComponentDependencyGraph.setSelected(true);
        this.deploymentComponentDependencyGraphResponseTime.setSelected(true);
        this.deploymentComponentDependencyGraphResponseTimeComboBox.setSelectedIndex(2);
        this.deploymentComponentDependencyGraphResponseTimeComboBox.setEnabled(true);
        this.deploymentOperationDependencyGraph.setSelected(true);
        this.deploymentOperationDependencyGraphResponseTime.setSelected(true);
        this.deploymentOperationDependencyGraphResponseTimeComboBox.setSelectedIndex(2);
        this.deploymentOperationDependencyGraphResponseTimeComboBox.setEnabled(true);
    }
}

