/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.filter;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.tools.opad.model.IForecastMeasurementPair;
import kieker.tools.opad.record.StorableDetectionResult;

@Plugin(name="AnomalyScore Calculation Filter", outputPorts={@OutputPort(eventTypes={StorableDetectionResult.class}, name="anomalyscore")})
public class AnomalyScoreCalculationFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_CURRENT_FORECAST_PAIR = "currentforecast";
    public static final String OUTPUT_PORT_ANOMALY_SCORE = "anomalyscore";

    public AnomalyScoreCalculationFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }

    @InputPort(eventTypes={IForecastMeasurementPair.class}, name="currentforecast")
    public void inputForecastAndMeasurement(IForecastMeasurementPair fmp) {
        Double score = 0.0;
        if (null != fmp.getForecasted()) {
            double nextpredicted = fmp.getForecasted();
            double measuredValue = (Double)fmp.getValue();
            double difference = nextpredicted - measuredValue;
            double sum = nextpredicted + measuredValue;
            score = Double.isNaN(nextpredicted) && Double.isNaN(measuredValue) ? Double.valueOf(0.0) : (Double.isNaN(nextpredicted) || Double.isNaN(measuredValue) ? Double.valueOf(1.0) : Double.valueOf(Math.abs(difference / sum)));
        }
        StorableDetectionResult dr = new StorableDetectionResult(fmp.getName(), (Double)fmp.getValue(), fmp.getTime(), fmp.getForecasted(), score);
        super.deliver(OUTPUT_PORT_ANOMALY_SCORE, dr);
    }
}

