/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.bridge.connector.tcp;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentMap;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.tools.bridge.LookupEntity;
import kieker.tools.bridge.connector.AbstractConnector;
import kieker.tools.bridge.connector.ConnectorDataTransmissionException;
import kieker.tools.bridge.connector.ConnectorEndOfDataException;
import kieker.tools.bridge.connector.ConnectorProperty;

@ConnectorProperty(cmdName="tcp-client", name="TCP Client Connector", description="connector for remote TCP record sources.")
public class TCPClientConnector
extends AbstractConnector {
    public static final String HOSTNAME = TCPClientConnector.class.getCanonicalName() + ".hostname";
    public static final String PORT = TCPClientConnector.class.getCanonicalName() + ".port";
    private static final int BUF_LEN = 65536;
    private final int port;
    private final String hostname;
    private Socket socket;
    private final byte[] buffer = new byte[65536];
    private DataInputStream in;

    public TCPClientConnector(Configuration configuration, ConcurrentMap<Integer, LookupEntity> lookupEntityMap) {
        super(configuration, lookupEntityMap);
        this.hostname = this.configuration.getStringProperty(HOSTNAME);
        this.port = this.configuration.getIntProperty(PORT);
    }

    @Override
    public void initialize() throws ConnectorDataTransmissionException {
        try {
            this.socket = new Socket(this.hostname, this.port);
            this.in = new DataInputStream(this.socket.getInputStream());
        }
        catch (UnknownHostException e) {
            throw new ConnectorDataTransmissionException("The given host " + this.hostname + " could not be found.", e);
        }
        catch (IOException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws ConnectorDataTransmissionException {
        try {
            this.in.close();
            this.socket.close();
        }
        catch (IOException e) {
            throw new ConnectorDataTransmissionException("Error occured during socket close.", e);
        }
    }

    @Override
    public IMonitoringRecord deserializeNextRecord() throws ConnectorDataTransmissionException, ConnectorEndOfDataException {
        try {
            Integer id = this.in.readInt();
            LookupEntity recordProperty = (LookupEntity)this.lookupEntityMap.get(id);
            if (recordProperty != null) {
                Object[] values = new Object[recordProperty.getParameterTypes().length];
                for (int i = 0; i < recordProperty.getParameterTypes().length; ++i) {
                    Class<?> parameterType = recordProperty.getParameterTypes()[i];
                    if (Boolean.TYPE.equals(parameterType)) {
                        values[i] = this.in.readBoolean();
                        continue;
                    }
                    if (Boolean.class.equals(parameterType)) {
                        values[i] = this.in.readBoolean();
                        continue;
                    }
                    if (Byte.TYPE.equals(parameterType)) {
                        values[i] = this.in.readByte();
                        continue;
                    }
                    if (Byte.class.equals(parameterType)) {
                        values[i] = this.in.readByte();
                        continue;
                    }
                    if (Short.TYPE.equals(parameterType)) {
                        values[i] = this.in.readShort();
                        continue;
                    }
                    if (Short.class.equals(parameterType)) {
                        values[i] = this.in.readShort();
                        continue;
                    }
                    if (Integer.TYPE.equals(parameterType)) {
                        values[i] = this.in.readInt();
                        continue;
                    }
                    if (Integer.class.equals(parameterType)) {
                        values[i] = this.in.readInt();
                        continue;
                    }
                    if (Long.TYPE.equals(parameterType)) {
                        values[i] = this.in.readLong();
                        continue;
                    }
                    if (Long.class.equals(parameterType)) {
                        values[i] = this.in.readLong();
                        continue;
                    }
                    if (Float.TYPE.equals(parameterType)) {
                        values[i] = Float.valueOf(this.in.readFloat());
                        continue;
                    }
                    if (Float.class.equals(parameterType)) {
                        values[i] = Float.valueOf(this.in.readFloat());
                        continue;
                    }
                    if (Double.TYPE.equals(parameterType)) {
                        values[i] = this.in.readDouble();
                        continue;
                    }
                    if (Double.class.equals(parameterType)) {
                        values[i] = this.in.readDouble();
                        continue;
                    }
                    if (String.class.equals(parameterType)) {
                        int bufLen = this.in.readInt();
                        this.in.readFully(this.buffer, 0, bufLen);
                        values[i] = new String(this.buffer, 0, bufLen, "UTF-8");
                        continue;
                    }
                    throw new ConnectorDataTransmissionException("References are not yet supported.");
                }
                return recordProperty.getConstructor().newInstance(values);
            }
            throw new ConnectorDataTransmissionException("Record type " + id + " is not registered.");
        }
        catch (SocketException e) {
            throw new ConnectorEndOfDataException("End of stream", e);
        }
        catch (EOFException e) {
            throw new ConnectorEndOfDataException("End of stream during an read operation", e);
        }
        catch (IOException e) {
            throw new ConnectorDataTransmissionException("Read error", e);
        }
        catch (InstantiationException e) {
            throw new ConnectorDataTransmissionException("Instantiation error", e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectorDataTransmissionException("Access to fields are restricted", e);
        }
        catch (IllegalArgumentException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
    }
}

