/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.bridge.connector.jms;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentMap;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.tools.bridge.LookupEntity;
import kieker.tools.bridge.connector.AbstractConnector;
import kieker.tools.bridge.connector.ConnectorDataTransmissionException;
import kieker.tools.bridge.connector.ConnectorEndOfDataException;
import kieker.tools.bridge.connector.ConnectorProperty;

@ConnectorProperty(cmdName="jms-client", name="JMS Client Connector", description="JMS Client to receive records from a JMS queue.")
public class JMSClientConnector
extends AbstractConnector {
    public static final String USERNAME = JMSClientConnector.class.getCanonicalName() + ".username";
    public static final String PASSWORD = JMSClientConnector.class.getCanonicalName() + ".password";
    public static final String URI = JMSClientConnector.class.getCanonicalName() + ".uri";
    public static final String FACTORY_LOOKUP_NAME = JMSClientConnector.class.getCanonicalName() + ".jmsFactoryLookupName";
    public static final String KIEKER_DATA_BRIDGE_READ_QUEUE = "kieker.tools.bridge";
    private static final int BUF_LEN = 65536;
    protected final String username;
    protected final String password;
    private final String uri;
    private MessageConsumer consumer;
    private final byte[] buffer = new byte[65536];
    private Connection connection;
    private final String jmsFactoryLookupName;

    public JMSClientConnector(Configuration configuration, ConcurrentMap<Integer, LookupEntity> lookupEntityMap) {
        super(configuration, lookupEntityMap);
        this.username = this.configuration.getStringProperty(USERNAME);
        this.password = this.configuration.getStringProperty(PASSWORD);
        this.uri = this.configuration.getStringProperty(URI);
        this.jmsFactoryLookupName = this.configuration.getStringProperty(FACTORY_LOOKUP_NAME);
    }

    @Override
    public void initialize() throws ConnectorDataTransmissionException {
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("java.naming.factory.initial", this.jmsFactoryLookupName);
            properties.put("java.naming.provider.url", this.uri);
            InitialContext context = new InitialContext(properties);
            ConnectionFactory factory = (ConnectionFactory)context.lookup("ConnectionFactory");
            this.connection = factory.createConnection();
            Session session = this.connection.createSession(false, 1);
            Queue destination = session.createQueue(KIEKER_DATA_BRIDGE_READ_QUEUE);
            this.consumer = session.createConsumer((Destination)destination);
            this.connection.start();
        }
        catch (NamingException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
        catch (JMSException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public void close() throws ConnectorDataTransmissionException {
        try {
            this.connection.stop();
        }
        catch (JMSException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public IMonitoringRecord deserializeNextRecord() throws ConnectorDataTransmissionException, ConnectorEndOfDataException {
        try {
            Message message = this.consumer.receive();
            if (message != null) {
                if (message instanceof BytesMessage) {
                    return this.deserialize((BytesMessage)message);
                }
                if (message instanceof TextMessage) {
                    return this.deserialize(((TextMessage)message).getText().split(";"));
                }
                throw new ConnectorDataTransmissionException("Unsupported message type " + message.getClass().getCanonicalName());
            }
            throw new ConnectorEndOfDataException("No more records in the queue");
        }
        catch (JMSException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private IMonitoringRecord deserialize(BytesMessage message) throws ConnectorDataTransmissionException, ConnectorEndOfDataException {
        try {
            Integer id = message.readInt();
            LookupEntity recordProperty = (LookupEntity)this.lookupEntityMap.get(id);
            if (recordProperty != null) {
                Object[] values = new Object[recordProperty.getParameterTypes().length];
                for (int i = 0; i < recordProperty.getParameterTypes().length; ++i) {
                    Class<?> parameterType = recordProperty.getParameterTypes()[i];
                    if (Boolean.TYPE.equals(parameterType)) {
                        values[i] = message.readBoolean();
                        continue;
                    }
                    if (Boolean.class.equals(parameterType)) {
                        values[i] = message.readBoolean();
                        continue;
                    }
                    if (Byte.TYPE.equals(parameterType)) {
                        values[i] = message.readByte();
                        continue;
                    }
                    if (Byte.class.equals(parameterType)) {
                        values[i] = message.readByte();
                        continue;
                    }
                    if (Short.TYPE.equals(parameterType)) {
                        values[i] = message.readShort();
                        continue;
                    }
                    if (Short.class.equals(parameterType)) {
                        values[i] = message.readShort();
                        continue;
                    }
                    if (Integer.TYPE.equals(parameterType)) {
                        values[i] = message.readInt();
                        continue;
                    }
                    if (Integer.class.equals(parameterType)) {
                        values[i] = message.readInt();
                        continue;
                    }
                    if (Long.TYPE.equals(parameterType)) {
                        values[i] = message.readLong();
                        continue;
                    }
                    if (Long.class.equals(parameterType)) {
                        values[i] = message.readLong();
                        continue;
                    }
                    if (Float.TYPE.equals(parameterType)) {
                        values[i] = Float.valueOf(message.readFloat());
                        continue;
                    }
                    if (Float.class.equals(parameterType)) {
                        values[i] = Float.valueOf(message.readFloat());
                        continue;
                    }
                    if (Double.TYPE.equals(parameterType)) {
                        values[i] = message.readDouble();
                        continue;
                    }
                    if (Double.class.equals(parameterType)) {
                        values[i] = message.readDouble();
                        continue;
                    }
                    if (String.class.equals(parameterType)) {
                        int bufLen = message.readInt();
                        int resultLen = message.readBytes(this.buffer, bufLen);
                        if (resultLen == bufLen) {
                            values[i] = new String(this.buffer, 0, bufLen, "UTF-8");
                            continue;
                        }
                        throw new ConnectorDataTransmissionException(bufLen + " bytes expected, but only " + resultLen + " bytes received.");
                    }
                    throw new ConnectorDataTransmissionException("References are not yet supported.");
                }
                return recordProperty.getConstructor().newInstance(values);
            }
            throw new ConnectorDataTransmissionException("Record type " + id + " is not registered.");
        }
        catch (JMSException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new ConnectorDataTransmissionException("Expected a string value in UTF-8", e);
        }
        catch (InstantiationException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
    }

    private IMonitoringRecord deserialize(String[] attributes) throws ConnectorDataTransmissionException, ConnectorEndOfDataException {
        if (attributes.length > 0) {
            Integer id = Integer.parseInt(attributes[0]);
            LookupEntity recordProperty = (LookupEntity)this.lookupEntityMap.get(id);
            if (recordProperty != null) {
                Object[] values = new Object[recordProperty.getParameterTypes().length];
                for (int i = 0; i < recordProperty.getParameterTypes().length; ++i) {
                    Class<?> parameterType = recordProperty.getParameterTypes()[i];
                    if (Boolean.TYPE.equals(parameterType)) {
                        values[i] = "t".equals(attributes[i + 1]);
                        continue;
                    }
                    if (parameterType.equals(Boolean.class)) {
                        values[i] = "t".equals(attributes[i + 1]);
                        continue;
                    }
                    if (Byte.TYPE.equals(parameterType)) {
                        values[i] = Byte.parseByte(attributes[i + 1]);
                        continue;
                    }
                    if (Byte.class.equals(parameterType)) {
                        values[i] = Byte.parseByte(attributes[i + 1]);
                        continue;
                    }
                    if (Short.TYPE.equals(parameterType)) {
                        values[i] = Short.parseShort(attributes[i + 1]);
                        continue;
                    }
                    if (Short.class.equals(parameterType)) {
                        values[i] = Short.parseShort(attributes[i + 1]);
                        continue;
                    }
                    if (Integer.TYPE.equals(parameterType)) {
                        values[i] = Integer.parseInt(attributes[i + 1]);
                        continue;
                    }
                    if (Integer.class.equals(parameterType)) {
                        values[i] = Integer.parseInt(attributes[i + 1]);
                        continue;
                    }
                    if (Long.TYPE.equals(parameterType)) {
                        values[i] = Long.parseLong(attributes[i + 1]);
                        continue;
                    }
                    if (Long.class.equals(parameterType)) {
                        values[i] = Long.parseLong(attributes[i + 1]);
                        continue;
                    }
                    if (Float.TYPE.equals(parameterType)) {
                        values[i] = Float.valueOf(Float.parseFloat(attributes[i + 1]));
                        continue;
                    }
                    if (Float.class.equals(parameterType)) {
                        values[i] = Float.valueOf(Float.parseFloat(attributes[i + 1]));
                        continue;
                    }
                    if (Double.TYPE.equals(parameterType)) {
                        values[i] = Double.parseDouble(attributes[i + 1]);
                        continue;
                    }
                    if (Double.class.equals(parameterType)) {
                        values[i] = Double.parseDouble(attributes[i + 1]);
                        continue;
                    }
                    if (String.class.equals(parameterType)) {
                        values[i] = attributes[i + 1];
                        continue;
                    }
                    throw new ConnectorDataTransmissionException("References are not yet supported.");
                }
                try {
                    return recordProperty.getConstructor().newInstance(values);
                }
                catch (InstantiationException e) {
                    throw new ConnectorDataTransmissionException(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new ConnectorDataTransmissionException(e.getMessage(), e);
                }
                catch (IllegalArgumentException e) {
                    throw new ConnectorDataTransmissionException(e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ConnectorDataTransmissionException(e.getMessage(), e);
                }
            }
            throw new ConnectorDataTransmissionException("Record type " + id + " is not registered.");
        }
        throw new ConnectorDataTransmissionException("Record structure is corrupt");
    }
}

