/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.tcp;

import kieker.common.configuration.Configuration;
import kieker.monitoring.writer.AbstractAsyncWriter;
import kieker.monitoring.writer.tcp.TCPWriterThread;

public final class TCPWriter
extends AbstractAsyncWriter {
    private static final String PREFIX = TCPWriter.class.getName() + ".";
    public static final String CONFIG_HOSTNAME = PREFIX + "hostname";
    public static final String CONFIG_PORT1 = PREFIX + "port1";
    public static final String CONFIG_PORT2 = PREFIX + "port2";
    public static final String CONFIG_BUFFERSIZE = PREFIX + "bufferSize";
    public static final String CONFIG_FLUSH = PREFIX + "flush";
    private final String hostname;
    private final int port1;
    private final int port2;
    private final int bufferSize;
    private final boolean flush;

    public TCPWriter(Configuration configuration) {
        super(configuration);
        this.hostname = configuration.getStringProperty(CONFIG_HOSTNAME);
        this.port1 = configuration.getIntProperty(CONFIG_PORT1);
        this.port2 = configuration.getIntProperty(CONFIG_PORT2);
        this.bufferSize = configuration.getIntProperty(CONFIG_BUFFERSIZE);
        this.flush = configuration.getBooleanProperty(CONFIG_FLUSH);
    }

    @Override
    protected void init() throws Exception {
        this.addWorker(new TCPWriterThread(this.monitoringController, this.blockingQueue, this.hostname, this.port1, this.bufferSize, this.flush));
        this.addWorker(new TCPWriterThread(this.monitoringController, this.prioritizedBlockingQueue, this.hostname, this.port2, this.bufferSize, this.flush));
    }
}

