/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;

public class ResourceUtilizationRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    public static final int SIZE = 24;
    private static final long serialVersionUID = 2644828043690936993L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Double.TYPE};
    public static final long TIMESTAMP = 0L;
    public static final String HOSTNAME = "";
    public static final String RESOURCE_NAME = "";
    public static final double UTILIZATION = 0.0;
    private final long timestamp;
    private final String hostname;
    private final String resourceName;
    private final double utilization;

    public ResourceUtilizationRecord(long timestamp, String hostname, String resourceName, double utilization) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? "" : hostname;
        this.resourceName = resourceName == null ? "" : resourceName;
        this.utilization = utilization;
    }

    public ResourceUtilizationRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.timestamp = (Long)values[0];
        this.hostname = (String)values[1];
        this.resourceName = (String)values[2];
        this.utilization = (Double)values[3];
    }

    protected ResourceUtilizationRecord(Object[] values, Class<?>[] valueTypes) {
        AbstractMonitoringRecord.checkArray(values, valueTypes);
        this.timestamp = (Long)values[0];
        this.hostname = (String)values[1];
        this.resourceName = (String)values[2];
        this.utilization = (Double)values[3];
    }

    public ResourceUtilizationRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.timestamp = buffer.getLong();
        this.hostname = stringRegistry.get(buffer.getInt());
        this.resourceName = stringRegistry.get(buffer.getInt());
        this.utilization = buffer.getDouble();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getHostname(), this.getResourceName(), this.getUtilization()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putInt(stringRegistry.get(this.getResourceName()));
        buffer.putDouble(this.getUtilization());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 24;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getResourceName() {
        return this.resourceName;
    }

    public final double getUtilization() {
        return this.utilization;
    }
}

