/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;

public abstract class AbstractJVMRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    private static final long serialVersionUID = 3817833790306987100L;
    private final long timestamp;
    private final String hostname;
    private final String vmName;

    public AbstractJVMRecord(long timestamp, String hostname, String vmName) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? "" : hostname;
        this.vmName = vmName == null ? "" : vmName;
    }

    protected AbstractJVMRecord(Object[] values, Class<?>[] valueTypes) {
        AbstractMonitoringRecord.checkArray(values, valueTypes);
        this.timestamp = (Long)values[0];
        this.hostname = (String)values[1];
        this.vmName = (String)values[2];
    }

    public AbstractJVMRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.timestamp = buffer.getLong();
        this.hostname = stringRegistry.get(buffer.getInt());
        this.vmName = stringRegistry.get(buffer.getInt());
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getVmName() {
        return this.vmName;
    }
}

