/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.filesystem;

import java.io.File;
import java.util.PriorityQueue;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.plugin.reader.filesystem.FSDirectoryReader;
import kieker.analysis.plugin.reader.filesystem.FSZipReader;
import kieker.analysis.plugin.reader.filesystem.IMonitoringRecordReceiver;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.EmptyRecord;

@Plugin(description="A file system reader which reads records from multiple directories", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output Port of the FSReader")}, configuration={@Property(name="inputDirs", defaultValue=".", description="The name of the input dirs used to read data (multiple dirs are separated by |)."), @Property(name="ignoreUnknownRecordTypes", defaultValue="false", description="Ignore unknown records? Aborts if encountered and value is false.")})
public class FSReader
extends AbstractReaderPlugin
implements IMonitoringRecordReceiver {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_NAME_INPUTDIRS = "inputDirs";
    public static final String CONFIG_PROPERTY_NAME_IGNORE_UNKNOWN_RECORD_TYPES = "ignoreUnknownRecordTypes";
    public static final IMonitoringRecord EOF = new EmptyRecord();
    private final boolean ignoreUnknownRecordTypes;
    private final String[] inputDirs = this.configuration.getStringArrayProperty("inputDirs");
    private final PriorityQueue<IMonitoringRecord> recordQueue;
    private volatile boolean running = true;

    public FSReader(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        int nDirs = this.inputDirs.length;
        for (int i = 0; i < nDirs; ++i) {
            if (".".equals(this.inputDirs[i])) continue;
            this.inputDirs[i] = Configuration.convertToPath(this.inputDirs[i]);
        }
        if (nDirs == 0) {
            this.log.warn("The list of input dirs passed to the " + FSReader.class.getSimpleName() + " is empty");
            nDirs = 1;
        }
        this.recordQueue = new PriorityQueue(nDirs);
        this.ignoreUnknownRecordTypes = this.configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_IGNORE_UNKNOWN_RECORD_TYPES);
    }

    @Override
    public void terminate(boolean error) {
        this.log.info("Shutting down reader.");
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean read() {
        int notInitializesReaders = 0;
        for (String inputDirFn : this.inputDirs) {
            Thread readerThread;
            File inputDir = new File(inputDirFn);
            if (inputDir.isDirectory()) {
                readerThread = new Thread(new FSDirectoryReader(inputDir, this, this.ignoreUnknownRecordTypes));
            } else if (inputDir.isFile() && inputDirFn.endsWith(".zip")) {
                readerThread = new Thread(new FSZipReader(inputDir, this, this.ignoreUnknownRecordTypes));
            } else {
                this.log.warn("Invalid Directory or filename (no Kieker log): " + inputDirFn);
                ++notInitializesReaders;
                continue;
            }
            readerThread.setDaemon(true);
            readerThread.start();
        }
        int readingReaders = this.inputDirs.length - notInitializesReaders;
        while (readingReaders > 0) {
            IMonitoringRecord record;
            PriorityQueue<IMonitoringRecord> len$ = this.recordQueue;
            synchronized (len$) {
                while (this.recordQueue.size() < readingReaders) {
                    try {
                        this.recordQueue.wait();
                    }
                    catch (InterruptedException ex) {}
                }
            }
            IMonitoringRecord iMonitoringRecord = record = (IMonitoringRecord)this.recordQueue.remove();
            synchronized (iMonitoringRecord) {
                record.notifyAll();
            }
            if (record == EOF) {
                --readingReaders;
                continue;
            }
            super.deliver(OUTPUT_PORT_NAME_RECORDS, record);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean newMonitoringRecord(IMonitoringRecord record) {
        IMonitoringRecord iMonitoringRecord = record;
        synchronized (iMonitoringRecord) {
            PriorityQueue<IMonitoringRecord> priorityQueue = this.recordQueue;
            synchronized (priorityQueue) {
                this.recordQueue.add(record);
                this.recordQueue.notifyAll();
            }
            try {
                record.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.running;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_INPUTDIRS, Configuration.toProperty(this.inputDirs));
        configuration.setProperty(CONFIG_PROPERTY_NAME_IGNORE_UNKNOWN_RECORD_TYPES, Boolean.toString(this.ignoreUnknownRecordTypes));
        return configuration;
    }
}

