/*
 * Decompiled with CFR 0.152.
 */
package kieker.examples.userguide.ch3and4bookstore;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.examples.userguide.ch3and4bookstore.MyResponseTimeRecord;

@Plugin(name="Reponse time printer", description="Prints the response time on the standard output", configuration={@Property(name="validOutput", defaultValue="true")})
public class MyResponseTimeOutputPrinter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "newEvent";
    public static final String CONFIG_PROPERTY_NAME_VALID_OUTPUT = "validOutput";
    private final boolean validOutput;

    public MyResponseTimeOutputPrinter(Configuration configuration, IProjectContext iProjectContext) {
        super(configuration, iProjectContext);
        this.validOutput = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_VALID_OUTPUT);
    }

    @InputPort(name="newEvent", eventTypes={MyResponseTimeRecord.class})
    public void newEvent(Object object) {
        if (object instanceof MyResponseTimeRecord) {
            MyResponseTimeRecord myResponseTimeRecord = (MyResponseTimeRecord)((Object)object);
            String string = this.validOutput ? "[Valid] " : "[Invalid] ";
            string = string + myResponseTimeRecord.getLoggingTimestamp() + ": " + myResponseTimeRecord.getClassName() + ", " + myResponseTimeRecord.getMethodName() + ", " + myResponseTimeRecord.getResponseTimeNanos();
            System.out.println(string);
        }
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_VALID_OUTPUT, Boolean.toString(this.validOutput));
        return configuration;
    }
}

