# Contributing

We love pull requests from everyone and we want to keep it as easy as possible
to contribute to the project!

## Getting Started

* Make sure you have a [Jira account](https://inspectit-performance.atlassian.net/wiki/display/CONTRIBUTE/Sign+Up).
* Make sure you have a [GitHub account](https://inspectit-performance.atlassian.net/wiki/display/DEV/Setup+GitHub).
* [Submit a ticket](https://inspectit-performance.atlassian.net/wiki/display/CONTRIBUTE/Add+feature+requests)
  in Jira for your issue, assuming one does not already exist.
  * Clearly describe the issue including steps to reproduce when it is a [bug](https://inspectit-performance.atlassian.net/wiki/display/CONTRIBUTE/Contribute+a+bug+report).
  * Make sure you fill in the earliest version that you know has the issue.
* Fork the repository on GitHub.
* Setup your development environment with our automatic [Oomph setup](https://inspectit-performance.atlassian.net/wiki/display/DEV/Development+Environment)
  for Eclipse.

## Making Changes

* Create a [topic branch](https://inspectit-performance.atlassian.net/wiki/display/DEV/Feature+branches)
  from the latest **master** branch.
* Make sure your [commit messages](https://inspectit-performance.atlassian.net/wiki/display/DEV/Create+a+pull+request)
  are in the proper format.
* Make sure you have added the necessary tests for your changes.
* Run _all_ the tests to assure nothing else was accidentally broken.

## Submitting Changes

* Push your changes to a topic branch in your fork of the repository.
* Submit a [pull request](https://inspectit-performance.atlassian.net/wiki/display/DEV/Create+a+pull+request)
  to the repository in the inspectIT organization.
* Update your Jira ticket to mark that you have submitted code and are ready for
  it to be reviewed (Status: Integration Needed).
  * Include a link to the pull request in the ticket.
* Sign the [Contributor License Agreement](https://inspectit-performance.atlassian.net/wiki/display/CONTRIBUTE/Contribution+Agreement)
  (there is a link in the Pull Request to sign it).
* After [feedback](https://inspectit-performance.atlassian.net/wiki/display/DEV/Commenting+on+pull+request)
  has been given we expect responses within four weeks. After four weeks we may
  close the pull request if it isn't showing any activity.

## Additional Resources

* [Bug tracker (Jira)](https://inspectit-performance.atlassian.net)
* [Contribution Documentation](https://inspectit-performance.atlassian.net/wiki/display/CONTRIBUTE/)
* [Contributor License Agreement](https://inspectit-performance.atlassian.net/wiki/display/CONTRIBUTE/Contribution+Agreement)
* [General GitHub documentation](https://help.github.com/)
* [GitHub pull request documentation](https://help.github.com/send-pull-requests/)
* [Gitter Chat](https://gitter.im/inspectIT/chat?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
