package info.novatec.inspectit.agent.config.impl;

/**
 * Container for the values of a sensor type configuration. Stores all the values defined in a
 * config file for later access.
 * 
 * @author Alfred Krauss
 */
public class JmxSensorTypeConfig extends AbstractSensorTypeConfig {

	/**
	 * The name of the sensor type.
	 */
	private String name;

	/**
	 * Gets {@link #name}.
	 * 
	 * @return {@link #name}
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets {@link #name}.
	 * 
	 * @param name
	 *            New value for {@link #name}
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * {@inheritDoc}
	 */
	public String toString() {
		return getId() + " :: name: " + name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		JmxSensorTypeConfig other = (JmxSensorTypeConfig) obj;
		if (name == null) {
			if (other.name != null) {
				return false;
			}
		} else if (!name.equals(other.name)) {
			return false;
		}
		return true;
	}

}
