/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.SystemSensorData;
import java.sql.Timestamp;
import javax.persistence.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class ThreadInformationData
extends SystemSensorData
implements IAggregatedData<ThreadInformationData> {
    private static final long serialVersionUID = -4782628082344900101L;
    private int count = 0;
    private int minDaemonThreadCount = Integer.MAX_VALUE;
    private int maxDaemonThreadCount = 0;
    private int totalDaemonThreadCount = 0;
    private int minPeakThreadCount = Integer.MAX_VALUE;
    private int maxPeakThreadCount = 0;
    private int totalPeakThreadCount = 0;
    private int minThreadCount = Integer.MAX_VALUE;
    private int maxThreadCount = 0;
    private int totalThreadCount = 0;
    private long minTotalStartedThreadCount = Long.MAX_VALUE;
    private long maxTotalStartedThreadCount = 0L;
    private long totalTotalStartedThreadCount = 0L;

    public ThreadInformationData() {
    }

    public ThreadInformationData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public void addPeakThreadCount(int peakThreadCount) {
        this.totalPeakThreadCount += peakThreadCount;
    }

    public void addDaemonThreadCount(int daemonThreadCount) {
        this.totalDaemonThreadCount += daemonThreadCount;
    }

    public void addThreadCount(int threadCount) {
        this.totalThreadCount += threadCount;
    }

    public int getMinDaemonThreadCount() {
        return this.minDaemonThreadCount;
    }

    public void setMinDaemonThreadCount(int minDaemonThreadCount) {
        this.minDaemonThreadCount = minDaemonThreadCount;
    }

    public int getMaxDaemonThreadCount() {
        return this.maxDaemonThreadCount;
    }

    public void setMaxDaemonThreadCount(int maxDaemonThreadCount) {
        this.maxDaemonThreadCount = maxDaemonThreadCount;
    }

    public int getTotalDaemonThreadCount() {
        return this.totalDaemonThreadCount;
    }

    public void setTotalDaemonThreadCount(int totalDaemonThreadCount) {
        this.totalDaemonThreadCount = totalDaemonThreadCount;
    }

    public int getMinPeakThreadCount() {
        return this.minPeakThreadCount;
    }

    public void setMinPeakThreadCount(int minPeakThreadCount) {
        this.minPeakThreadCount = minPeakThreadCount;
    }

    public int getMaxPeakThreadCount() {
        return this.maxPeakThreadCount;
    }

    public void setMaxPeakThreadCount(int maxPeakThreadCount) {
        this.maxPeakThreadCount = maxPeakThreadCount;
    }

    public int getTotalPeakThreadCount() {
        return this.totalPeakThreadCount;
    }

    public void setTotalPeakThreadCount(int totalPeakThreadCount) {
        this.totalPeakThreadCount = totalPeakThreadCount;
    }

    public int getMinThreadCount() {
        return this.minThreadCount;
    }

    public void setMinThreadCount(int minThreadCount) {
        this.minThreadCount = minThreadCount;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public int getTotalThreadCount() {
        return this.totalThreadCount;
    }

    public void setTotalThreadCount(int totalThreadCount) {
        this.totalThreadCount = totalThreadCount;
    }

    public void addTotalStartedThreadCount(long totalStartedThreadCount) {
        this.totalTotalStartedThreadCount += totalStartedThreadCount;
    }

    public long getMinTotalStartedThreadCount() {
        return this.minTotalStartedThreadCount;
    }

    public void setMinTotalStartedThreadCount(long minTotalStartedThreadCount) {
        this.minTotalStartedThreadCount = minTotalStartedThreadCount;
    }

    public long getMaxTotalStartedThreadCount() {
        return this.maxTotalStartedThreadCount;
    }

    public void setMaxTotalStartedThreadCount(long maxTotalStartedThreadCount) {
        this.maxTotalStartedThreadCount = maxTotalStartedThreadCount;
    }

    public long getTotalTotalStartedThreadCount() {
        return this.totalTotalStartedThreadCount;
    }

    public void setTotalTotalStartedThreadCount(long totalTotalStartedThreadCount) {
        this.totalTotalStartedThreadCount = totalTotalStartedThreadCount;
    }

    @Override
    public void aggregate(ThreadInformationData other) {
        this.count += other.count;
        this.minDaemonThreadCount = Math.min(other.getMinDaemonThreadCount(), this.minDaemonThreadCount);
        this.minPeakThreadCount = Math.min(other.getMinPeakThreadCount(), this.minPeakThreadCount);
        this.minThreadCount = Math.min(other.getMinThreadCount(), this.minThreadCount);
        this.minTotalStartedThreadCount = Math.min(other.getMinTotalStartedThreadCount(), this.minTotalStartedThreadCount);
        this.maxDaemonThreadCount = Math.max(other.getMaxDaemonThreadCount(), this.maxDaemonThreadCount);
        this.maxPeakThreadCount = Math.max(other.getMaxPeakThreadCount(), this.maxPeakThreadCount);
        this.maxThreadCount = Math.max(other.getMaxThreadCount(), this.maxThreadCount);
        this.maxTotalStartedThreadCount = Math.max(other.getMaxTotalStartedThreadCount(), this.maxTotalStartedThreadCount);
        this.totalDaemonThreadCount += other.getTotalDaemonThreadCount();
        this.totalPeakThreadCount += other.getTotalPeakThreadCount();
        this.totalThreadCount += other.getTotalThreadCount();
        this.totalTotalStartedThreadCount += other.getTotalTotalStartedThreadCount();
    }

    @Override
    public ThreadInformationData getData() {
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.count;
        result = 31 * result + this.maxDaemonThreadCount;
        result = 31 * result + this.maxPeakThreadCount;
        result = 31 * result + this.maxThreadCount;
        result = 31 * result + (int)(this.maxTotalStartedThreadCount ^ this.maxTotalStartedThreadCount >>> 32);
        result = 31 * result + this.minDaemonThreadCount;
        result = 31 * result + this.minPeakThreadCount;
        result = 31 * result + this.minThreadCount;
        result = 31 * result + (int)(this.minTotalStartedThreadCount ^ this.minTotalStartedThreadCount >>> 32);
        result = 31 * result + this.totalDaemonThreadCount;
        result = 31 * result + this.totalPeakThreadCount;
        result = 31 * result + this.totalThreadCount;
        result = 31 * result + (int)(this.totalTotalStartedThreadCount ^ this.totalTotalStartedThreadCount >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadInformationData other = (ThreadInformationData)obj;
        if (this.count != other.count) {
            return false;
        }
        if (this.maxDaemonThreadCount != other.maxDaemonThreadCount) {
            return false;
        }
        if (this.maxPeakThreadCount != other.maxPeakThreadCount) {
            return false;
        }
        if (this.maxThreadCount != other.maxThreadCount) {
            return false;
        }
        if (this.maxTotalStartedThreadCount != other.maxTotalStartedThreadCount) {
            return false;
        }
        if (this.minDaemonThreadCount != other.minDaemonThreadCount) {
            return false;
        }
        if (this.minPeakThreadCount != other.minPeakThreadCount) {
            return false;
        }
        if (this.minThreadCount != other.minThreadCount) {
            return false;
        }
        if (this.minTotalStartedThreadCount != other.minTotalStartedThreadCount) {
            return false;
        }
        if (this.totalDaemonThreadCount != other.totalDaemonThreadCount) {
            return false;
        }
        if (this.totalPeakThreadCount != other.totalPeakThreadCount) {
            return false;
        }
        if (this.totalThreadCount != other.totalThreadCount) {
            return false;
        }
        return this.totalTotalStartedThreadCount == other.totalTotalStartedThreadCount;
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(0, 0, 10, 0, 3, 0);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }
}

