/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.SystemSensorData;
import info.novatec.inspectit.communication.data.VmArgumentData;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="SystemInformationData.findAllForPlatformId", query="SELECT s FROM SystemInformationData s WHERE s.platformIdent=:platformIdent"), @NamedQuery(name="SystemInformationData.findLatestForPlatformIds", query="SELECT s FROM SystemInformationData s WHERE s.id IN (SELECT MAX(sd.id) FROM SystemInformationData sd WHERE sd.platformIdent IN (:platformIdents) GROUP BY sd.platformIdent)")})
public class SystemInformationData
extends SystemSensorData {
    private static final long serialVersionUID = -8294531858844656994L;
    public static final String FIND_ALL_FOR_PLATFORM_ID = "SystemInformationData.findAllForPlatformId";
    public static final String FIND_LATEST_FOR_PLATFORM_IDS = "SystemInformationData.findLatestForPlatformIds";
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<VmArgumentData> vmSet = new HashSet<VmArgumentData>();
    private long totalPhysMemory = 0L;
    private long totalSwapSpace = 0L;
    private String jitCompilerName;
    private String architecture;
    private String osName;
    private String osVersion;
    @Column(length=10000)
    private String classPath;
    @Column(length=10000)
    private String bootClassPath;
    @Column(length=10000)
    private String libraryPath;
    private String vmVendor;
    private String vmName;
    private String vmSpecName;
    private String vmVersion;
    private long initHeapMemorySize = 0L;
    private long maxHeapMemorySize = 0L;
    private long initNonHeapMemorySize = 0L;
    private long maxNonHeapMemorySize = 0L;
    private int availableProcessors = 0;

    public SystemInformationData() {
    }

    public SystemInformationData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent);
    }

    public Set<VmArgumentData> getVmSet() {
        return this.vmSet;
    }

    public void setVmSet(Set<VmArgumentData> vmSet) {
        this.vmSet = vmSet;
    }

    public long getTotalPhysMemory() {
        return this.totalPhysMemory;
    }

    public void setTotalPhysMemory(long totalPhysMemory) {
        this.totalPhysMemory = totalPhysMemory;
    }

    public long getTotalSwapSpace() {
        return this.totalSwapSpace;
    }

    public void setTotalSwapSpace(long totalSwapSpace) {
        this.totalSwapSpace = totalSwapSpace;
    }

    public String getJitCompilerName() {
        return this.jitCompilerName;
    }

    public void setJitCompilerName(String jitCompilerName) {
        this.jitCompilerName = jitCompilerName;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public void setAvailableProcessors(int availableProcessors) {
        this.availableProcessors = availableProcessors;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getBootClassPath() {
        return this.bootClassPath;
    }

    public void setBootClassPath(String bootClassPath) {
        this.bootClassPath = bootClassPath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public void setLibraryPath(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public void setVmVendor(String vmVendor) {
        this.vmVendor = vmVendor;
    }

    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public String getVmSpecName() {
        return this.vmSpecName;
    }

    public void setVmSpecName(String vmSpecName) {
        this.vmSpecName = vmSpecName;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public void setVmVersion(String vmVersion) {
        this.vmVersion = vmVersion;
    }

    public long getInitHeapMemorySize() {
        return this.initHeapMemorySize;
    }

    public void setInitHeapMemorySize(long initHeapMemorySize) {
        this.initHeapMemorySize = initHeapMemorySize;
    }

    public long getMaxHeapMemorySize() {
        return this.maxHeapMemorySize;
    }

    public void setMaxHeapMemorySize(long maxHeapMemorySize) {
        this.maxHeapMemorySize = maxHeapMemorySize;
    }

    public long getInitNonHeapMemorySize() {
        return this.initNonHeapMemorySize;
    }

    public void setInitNonHeapMemorySize(long initNonHeapMemorySize) {
        this.initNonHeapMemorySize = initNonHeapMemorySize;
    }

    public long getMaxNonHeapMemorySize() {
        return this.maxNonHeapMemorySize;
    }

    public void setMaxNonHeapMemorySize(long maxNonHeapMemorySize) {
        this.maxNonHeapMemorySize = maxNonHeapMemorySize;
    }

    public void addVMArguments(String vmArgumentName, String vmArgumentValue) {
        VmArgumentData vmArg = new VmArgumentData(vmArgumentName, vmArgumentValue);
        this.vmSet.add(vmArg);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.architecture == null ? 0 : this.architecture.hashCode());
        result = 31 * result + this.availableProcessors;
        result = 31 * result + (this.bootClassPath == null ? 0 : this.bootClassPath.hashCode());
        result = 31 * result + (this.classPath == null ? 0 : this.classPath.hashCode());
        result = 31 * result + (int)(this.initHeapMemorySize ^ this.initHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.initNonHeapMemorySize ^ this.initNonHeapMemorySize >>> 32);
        result = 31 * result + (this.jitCompilerName == null ? 0 : this.jitCompilerName.hashCode());
        result = 31 * result + (this.libraryPath == null ? 0 : this.libraryPath.hashCode());
        result = 31 * result + (int)(this.maxHeapMemorySize ^ this.maxHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.maxNonHeapMemorySize ^ this.maxNonHeapMemorySize >>> 32);
        result = 31 * result + (this.osName == null ? 0 : this.osName.hashCode());
        result = 31 * result + (this.osVersion == null ? 0 : this.osVersion.hashCode());
        result = 31 * result + (int)(this.totalPhysMemory ^ this.totalPhysMemory >>> 32);
        result = 31 * result + (int)(this.totalSwapSpace ^ this.totalSwapSpace >>> 32);
        result = 31 * result + (this.vmName == null ? 0 : this.vmName.hashCode());
        result = 31 * result + (this.vmSet == null ? 0 : this.vmSet.hashCode());
        result = 31 * result + (this.vmSpecName == null ? 0 : this.vmSpecName.hashCode());
        result = 31 * result + (this.vmVendor == null ? 0 : this.vmVendor.hashCode());
        result = 31 * result + (this.vmVersion == null ? 0 : this.vmVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemInformationData other = (SystemInformationData)obj;
        if (this.architecture == null ? other.architecture != null : !this.architecture.equals(other.architecture)) {
            return false;
        }
        if (this.availableProcessors != other.availableProcessors) {
            return false;
        }
        if (this.bootClassPath == null ? other.bootClassPath != null : !this.bootClassPath.equals(other.bootClassPath)) {
            return false;
        }
        if (this.classPath == null ? other.classPath != null : !this.classPath.equals(other.classPath)) {
            return false;
        }
        if (this.initHeapMemorySize != other.initHeapMemorySize) {
            return false;
        }
        if (this.initNonHeapMemorySize != other.initNonHeapMemorySize) {
            return false;
        }
        if (this.jitCompilerName == null ? other.jitCompilerName != null : !this.jitCompilerName.equals(other.jitCompilerName)) {
            return false;
        }
        if (this.libraryPath == null ? other.libraryPath != null : !this.libraryPath.equals(other.libraryPath)) {
            return false;
        }
        if (this.maxHeapMemorySize != other.maxHeapMemorySize) {
            return false;
        }
        if (this.maxNonHeapMemorySize != other.maxNonHeapMemorySize) {
            return false;
        }
        if (this.osName == null ? other.osName != null : !this.osName.equals(other.osName)) {
            return false;
        }
        if (this.osVersion == null ? other.osVersion != null : !this.osVersion.equals(other.osVersion)) {
            return false;
        }
        if (this.totalPhysMemory != other.totalPhysMemory) {
            return false;
        }
        if (this.totalSwapSpace != other.totalSwapSpace) {
            return false;
        }
        if (this.vmName == null ? other.vmName != null : !this.vmName.equals(other.vmName)) {
            return false;
        }
        if (this.vmSet == null ? other.vmSet != null : !this.vmSet.equals(other.vmSet)) {
            return false;
        }
        if (this.vmSpecName == null ? other.vmSpecName != null : !this.vmSpecName.equals(other.vmSpecName)) {
            return false;
        }
        if (this.vmVendor == null ? other.vmVendor != null : !this.vmVendor.equals(other.vmVendor)) {
            return false;
        }
        return !(this.vmVersion == null ? other.vmVersion != null : !this.vmVersion.equals(other.vmVersion));
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(12, 0, 1, 0, 6, 0);
        size += objectSizes.getSizeOf(this.architecture);
        size += objectSizes.getSizeOf(this.bootClassPath);
        size += objectSizes.getSizeOf(this.classPath);
        size += objectSizes.getSizeOf(this.jitCompilerName);
        size += objectSizes.getSizeOf(this.libraryPath);
        size += objectSizes.getSizeOf(this.osName);
        size += objectSizes.getSizeOf(this.osVersion);
        size += objectSizes.getSizeOf(this.vmName);
        size += objectSizes.getSizeOf(this.vmSpecName);
        size += objectSizes.getSizeOf(this.vmVendor);
        size += objectSizes.getSizeOf(this.vmVersion);
        if (null != this.vmSet) {
            size += objectSizes.getSizeOfHashSet(this.vmSet.size());
            for (VmArgumentData vmArgumentData : this.vmSet) {
                size += objectSizes.getSizeOf(vmArgumentData);
            }
        }
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }
}

