/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.SystemSensorData;
import java.sql.Timestamp;
import javax.persistence.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class MemoryInformationData
extends SystemSensorData
implements IAggregatedData<MemoryInformationData> {
    private static final long serialVersionUID = -8065956301565979083L;
    private int count = 0;
    private long minFreePhysMemory = Long.MAX_VALUE;
    private long maxFreePhysMemory = 0L;
    private long totalFreePhysMemory = 0L;
    private long minFreeSwapSpace = Long.MAX_VALUE;
    private long maxFreeSwapSpace = 0L;
    private long totalFreeSwapSpace = 0L;
    private long minComittedVirtualMemSize = Long.MAX_VALUE;
    private long maxComittedVirtualMemSize = 0L;
    private long totalComittedVirtualMemSize = 0L;
    private long minUsedHeapMemorySize = Long.MAX_VALUE;
    private long maxUsedHeapMemorySize = 0L;
    private long totalUsedHeapMemorySize = 0L;
    private long minComittedHeapMemorySize = Long.MAX_VALUE;
    private long maxComittedHeapMemorySize = 0L;
    private long totalComittedHeapMemorySize = 0L;
    private long minUsedNonHeapMemorySize = Long.MAX_VALUE;
    private long maxUsedNonHeapMemorySize = 0L;
    private long totalUsedNonHeapMemorySize = 0L;
    private long minComittedNonHeapMemorySize = Long.MAX_VALUE;
    private long maxComittedNonHeapMemorySize = 0L;
    private long totalComittedNonHeapMemorySize = 0L;

    public MemoryInformationData() {
    }

    public MemoryInformationData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public void addFreePhysMemory(long freePhysMemory) {
        this.totalFreePhysMemory += freePhysMemory;
    }

    public long getMinFreePhysMemory() {
        return this.minFreePhysMemory;
    }

    public void setMinFreePhysMemory(long minFreePhysMemory) {
        this.minFreePhysMemory = minFreePhysMemory;
    }

    public long getMaxFreePhysMemory() {
        return this.maxFreePhysMemory;
    }

    public void setMaxFreePhysMemory(long maxFreePhysMemory) {
        this.maxFreePhysMemory = maxFreePhysMemory;
    }

    public long getTotalFreePhysMemory() {
        return this.totalFreePhysMemory;
    }

    public void setTotalFreePhysMemory(long totalFreePhysMemory) {
        this.totalFreePhysMemory = totalFreePhysMemory;
    }

    public void addFreeSwapSpace(long freeSwapSpace) {
        this.totalFreeSwapSpace += freeSwapSpace;
    }

    public long getMinFreeSwapSpace() {
        return this.minFreeSwapSpace;
    }

    public void setMinFreeSwapSpace(long minFreeSwapSpace) {
        this.minFreeSwapSpace = minFreeSwapSpace;
    }

    public long getMaxFreeSwapSpace() {
        return this.maxFreeSwapSpace;
    }

    public void setMaxFreeSwapSpace(long maxFreeSwapSpace) {
        this.maxFreeSwapSpace = maxFreeSwapSpace;
    }

    public long getTotalFreeSwapSpace() {
        return this.totalFreeSwapSpace;
    }

    public void setTotalFreeSwapSpace(long totalFreeSwapSpace) {
        this.totalFreeSwapSpace = totalFreeSwapSpace;
    }

    public void addComittedVirtualMemSize(long comittedVirtualMemSize) {
        this.totalComittedVirtualMemSize += comittedVirtualMemSize;
    }

    public long getMinComittedVirtualMemSize() {
        return this.minComittedVirtualMemSize;
    }

    public void setMinComittedVirtualMemSize(long minComittedVirtualMemSize) {
        this.minComittedVirtualMemSize = minComittedVirtualMemSize;
    }

    public long getMaxComittedVirtualMemSize() {
        return this.maxComittedVirtualMemSize;
    }

    public void setMaxComittedVirtualMemSize(long maxComittedVirtualMemSize) {
        this.maxComittedVirtualMemSize = maxComittedVirtualMemSize;
    }

    public long getTotalComittedVirtualMemSize() {
        return this.totalComittedVirtualMemSize;
    }

    public void setTotalComittedVirtualMemSize(long totalComittedVirtualMemSize) {
        this.totalComittedVirtualMemSize = totalComittedVirtualMemSize;
    }

    public void addUsedHeapMemorySize(long usedHeapMemorySize) {
        this.totalUsedHeapMemorySize += usedHeapMemorySize;
    }

    public long getMinUsedHeapMemorySize() {
        return this.minUsedHeapMemorySize;
    }

    public void setMinUsedHeapMemorySize(long minUsedHeapMemorySize) {
        this.minUsedHeapMemorySize = minUsedHeapMemorySize;
    }

    public long getMaxUsedHeapMemorySize() {
        return this.maxUsedHeapMemorySize;
    }

    public void setMaxUsedHeapMemorySize(long maxUsedHeapMemorySize) {
        this.maxUsedHeapMemorySize = maxUsedHeapMemorySize;
    }

    public long getTotalUsedHeapMemorySize() {
        return this.totalUsedHeapMemorySize;
    }

    public void setTotalUsedHeapMemorySize(long totalUsedHeapMemorySize) {
        this.totalUsedHeapMemorySize = totalUsedHeapMemorySize;
    }

    public void addComittedHeapMemorySize(long comittedHeapMemorySize) {
        this.totalComittedHeapMemorySize += comittedHeapMemorySize;
    }

    public long getMinComittedHeapMemorySize() {
        return this.minComittedHeapMemorySize;
    }

    public void setMinComittedHeapMemorySize(long minComittedHeapMemorySize) {
        this.minComittedHeapMemorySize = minComittedHeapMemorySize;
    }

    public long getMaxComittedHeapMemorySize() {
        return this.maxComittedHeapMemorySize;
    }

    public void setMaxComittedHeapMemorySize(long maxComittedHeapMemorySize) {
        this.maxComittedHeapMemorySize = maxComittedHeapMemorySize;
    }

    public long getTotalComittedHeapMemorySize() {
        return this.totalComittedHeapMemorySize;
    }

    public void setTotalComittedHeapMemorySize(long totalComittedHeapMemorySize) {
        this.totalComittedHeapMemorySize = totalComittedHeapMemorySize;
    }

    public void addUsedNonHeapMemorySize(long usedNonHeapMemorySize) {
        this.totalUsedNonHeapMemorySize += usedNonHeapMemorySize;
    }

    public long getMinUsedNonHeapMemorySize() {
        return this.minUsedNonHeapMemorySize;
    }

    public void setMinUsedNonHeapMemorySize(long minUsedNonHeapMemorySize) {
        this.minUsedNonHeapMemorySize = minUsedNonHeapMemorySize;
    }

    public long getMaxUsedNonHeapMemorySize() {
        return this.maxUsedNonHeapMemorySize;
    }

    public void setMaxUsedNonHeapMemorySize(long maxUsedNonHeapMemorySize) {
        this.maxUsedNonHeapMemorySize = maxUsedNonHeapMemorySize;
    }

    public long getTotalUsedNonHeapMemorySize() {
        return this.totalUsedNonHeapMemorySize;
    }

    public void setTotalUsedNonHeapMemorySize(long totalUsedNonHeapMemorySize) {
        this.totalUsedNonHeapMemorySize = totalUsedNonHeapMemorySize;
    }

    public void addComittedNonHeapMemorySize(long comittedNonHeapMemorySize) {
        this.totalComittedNonHeapMemorySize += comittedNonHeapMemorySize;
    }

    public long getMinComittedNonHeapMemorySize() {
        return this.minComittedNonHeapMemorySize;
    }

    public void setMinComittedNonHeapMemorySize(long minComittedNonHeapMemorySize) {
        this.minComittedNonHeapMemorySize = minComittedNonHeapMemorySize;
    }

    public long getMaxComittedNonHeapMemorySize() {
        return this.maxComittedNonHeapMemorySize;
    }

    public void setMaxComittedNonHeapMemorySize(long maxComittedNonHeapMemorySize) {
        this.maxComittedNonHeapMemorySize = maxComittedNonHeapMemorySize;
    }

    public long getTotalComittedNonHeapMemorySize() {
        return this.totalComittedNonHeapMemorySize;
    }

    public void setTotalComittedNonHeapMemorySize(long totalComittedNonHeapMemorySize) {
        this.totalComittedNonHeapMemorySize = totalComittedNonHeapMemorySize;
    }

    @Override
    public void aggregate(MemoryInformationData other) {
        this.count += other.count;
        this.minComittedHeapMemorySize = Math.min(this.minComittedHeapMemorySize, other.minComittedHeapMemorySize);
        this.maxComittedHeapMemorySize = Math.max(this.maxComittedHeapMemorySize, other.maxComittedHeapMemorySize);
        this.totalComittedHeapMemorySize += other.totalComittedHeapMemorySize;
        this.minComittedNonHeapMemorySize = Math.min(this.minComittedNonHeapMemorySize, other.minComittedNonHeapMemorySize);
        this.maxComittedNonHeapMemorySize = Math.max(this.maxComittedNonHeapMemorySize, other.maxComittedNonHeapMemorySize);
        this.totalComittedNonHeapMemorySize += other.totalComittedNonHeapMemorySize;
        this.minComittedVirtualMemSize = Math.min(this.minComittedVirtualMemSize, other.minComittedVirtualMemSize);
        this.maxComittedVirtualMemSize = Math.max(this.maxComittedVirtualMemSize, other.maxComittedVirtualMemSize);
        this.totalComittedVirtualMemSize += other.totalComittedVirtualMemSize;
        this.minFreePhysMemory = Math.min(this.minFreePhysMemory, other.minFreePhysMemory);
        this.maxFreePhysMemory = Math.max(this.maxFreePhysMemory, other.maxFreePhysMemory);
        this.totalFreePhysMemory += other.totalFreePhysMemory;
        this.minFreeSwapSpace = Math.min(this.minFreeSwapSpace, other.minFreeSwapSpace);
        this.maxFreeSwapSpace = Math.max(this.maxFreeSwapSpace, other.maxFreeSwapSpace);
        this.totalFreeSwapSpace += other.totalFreeSwapSpace;
        this.minUsedHeapMemorySize = Math.min(this.minUsedHeapMemorySize, other.minUsedHeapMemorySize);
        this.maxUsedHeapMemorySize = Math.max(this.maxUsedHeapMemorySize, other.maxUsedHeapMemorySize);
        this.totalUsedHeapMemorySize += other.totalUsedHeapMemorySize;
        this.minUsedNonHeapMemorySize = Math.min(this.minUsedNonHeapMemorySize, other.minUsedNonHeapMemorySize);
        this.maxUsedNonHeapMemorySize = Math.max(this.maxUsedNonHeapMemorySize, other.maxUsedNonHeapMemorySize);
        this.totalUsedNonHeapMemorySize += other.totalUsedNonHeapMemorySize;
    }

    @Override
    public MemoryInformationData getData() {
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.count;
        result = 31 * result + (int)(this.maxComittedHeapMemorySize ^ this.maxComittedHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.maxComittedNonHeapMemorySize ^ this.maxComittedNonHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.maxComittedVirtualMemSize ^ this.maxComittedVirtualMemSize >>> 32);
        result = 31 * result + (int)(this.maxFreePhysMemory ^ this.maxFreePhysMemory >>> 32);
        result = 31 * result + (int)(this.maxFreeSwapSpace ^ this.maxFreeSwapSpace >>> 32);
        result = 31 * result + (int)(this.maxUsedHeapMemorySize ^ this.maxUsedHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.maxUsedNonHeapMemorySize ^ this.maxUsedNonHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.minComittedHeapMemorySize ^ this.minComittedHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.minComittedNonHeapMemorySize ^ this.minComittedNonHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.minComittedVirtualMemSize ^ this.minComittedVirtualMemSize >>> 32);
        result = 31 * result + (int)(this.minFreePhysMemory ^ this.minFreePhysMemory >>> 32);
        result = 31 * result + (int)(this.minFreeSwapSpace ^ this.minFreeSwapSpace >>> 32);
        result = 31 * result + (int)(this.minUsedHeapMemorySize ^ this.minUsedHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.minUsedNonHeapMemorySize ^ this.minUsedNonHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.totalComittedHeapMemorySize ^ this.totalComittedHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.totalComittedNonHeapMemorySize ^ this.totalComittedNonHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.totalComittedVirtualMemSize ^ this.totalComittedVirtualMemSize >>> 32);
        result = 31 * result + (int)(this.totalFreePhysMemory ^ this.totalFreePhysMemory >>> 32);
        result = 31 * result + (int)(this.totalFreeSwapSpace ^ this.totalFreeSwapSpace >>> 32);
        result = 31 * result + (int)(this.totalUsedHeapMemorySize ^ this.totalUsedHeapMemorySize >>> 32);
        result = 31 * result + (int)(this.totalUsedNonHeapMemorySize ^ this.totalUsedNonHeapMemorySize >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryInformationData other = (MemoryInformationData)obj;
        if (this.count != other.count) {
            return false;
        }
        if (this.maxComittedHeapMemorySize != other.maxComittedHeapMemorySize) {
            return false;
        }
        if (this.maxComittedNonHeapMemorySize != other.maxComittedNonHeapMemorySize) {
            return false;
        }
        if (this.maxComittedVirtualMemSize != other.maxComittedVirtualMemSize) {
            return false;
        }
        if (this.maxFreePhysMemory != other.maxFreePhysMemory) {
            return false;
        }
        if (this.maxFreeSwapSpace != other.maxFreeSwapSpace) {
            return false;
        }
        if (this.maxUsedHeapMemorySize != other.maxUsedHeapMemorySize) {
            return false;
        }
        if (this.maxUsedNonHeapMemorySize != other.maxUsedNonHeapMemorySize) {
            return false;
        }
        if (this.minComittedHeapMemorySize != other.minComittedHeapMemorySize) {
            return false;
        }
        if (this.minComittedNonHeapMemorySize != other.minComittedNonHeapMemorySize) {
            return false;
        }
        if (this.minComittedVirtualMemSize != other.minComittedVirtualMemSize) {
            return false;
        }
        if (this.minFreePhysMemory != other.minFreePhysMemory) {
            return false;
        }
        if (this.minFreeSwapSpace != other.minFreeSwapSpace) {
            return false;
        }
        if (this.minUsedHeapMemorySize != other.minUsedHeapMemorySize) {
            return false;
        }
        if (this.minUsedNonHeapMemorySize != other.minUsedNonHeapMemorySize) {
            return false;
        }
        if (this.totalComittedHeapMemorySize != other.totalComittedHeapMemorySize) {
            return false;
        }
        if (this.totalComittedNonHeapMemorySize != other.totalComittedNonHeapMemorySize) {
            return false;
        }
        if (this.totalComittedVirtualMemSize != other.totalComittedVirtualMemSize) {
            return false;
        }
        if (this.totalFreePhysMemory != other.totalFreePhysMemory) {
            return false;
        }
        if (this.totalFreeSwapSpace != other.totalFreeSwapSpace) {
            return false;
        }
        if (this.totalUsedHeapMemorySize != other.totalUsedHeapMemorySize) {
            return false;
        }
        return this.totalUsedNonHeapMemorySize == other.totalUsedNonHeapMemorySize;
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(0, 0, 1, 0, 21, 0);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }
}

