/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.comparator;

import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.InvocationSequenceDataHelper;
import info.novatec.inspectit.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InvocationSequenceDataComparatorEnum implements IDataComparator<InvocationSequenceData>
{
    CHILD_COUNT,
    DURATION,
    NESTED_DATA,
    URI,
    USE_CASE;


    @Override
    public int compare(InvocationSequenceData o1, InvocationSequenceData o2, ICachedDataService cachedDataService) {
        switch (this) {
            case CHILD_COUNT: {
                return Long.valueOf(o1.getChildCount()).compareTo(o2.getChildCount());
            }
            case DURATION: {
                if (InvocationSequenceDataHelper.hasTimerData(o1) && InvocationSequenceDataHelper.hasTimerData(o2)) {
                    return Double.compare(o1.getTimerData().getDuration(), o2.getTimerData().getDuration());
                }
                return Double.compare(o1.getDuration(), o2.getDuration());
            }
            case NESTED_DATA: {
                int invNested1 = 0;
                if (InvocationSequenceDataHelper.hasNestedSqlStatements(o1)) {
                    invNested1 += 2;
                }
                if (InvocationSequenceDataHelper.hasNestedExceptions(o1)) {
                    ++invNested1;
                }
                int invNested2 = 0;
                if (InvocationSequenceDataHelper.hasNestedSqlStatements(o2)) {
                    invNested2 += 2;
                }
                if (InvocationSequenceDataHelper.hasNestedExceptions(o2)) {
                    ++invNested2;
                }
                return invNested1 - invNested2;
            }
            case URI: {
                if (InvocationSequenceDataHelper.hasHttpTimerData(o1) && InvocationSequenceDataHelper.hasHttpTimerData(o2)) {
                    String uri1 = ((HttpTimerData)o1.getTimerData()).getHttpInfo().getUri();
                    String uri2 = ((HttpTimerData)o2.getTimerData()).getHttpInfo().getUri();
                    return ObjectUtils.compare(uri1, uri2);
                }
                if (InvocationSequenceDataHelper.hasHttpTimerData(o1)) {
                    return 1;
                }
                if (InvocationSequenceDataHelper.hasHttpTimerData(o2)) {
                    return -1;
                }
                return 0;
            }
            case USE_CASE: {
                if (InvocationSequenceDataHelper.hasHttpTimerData(o1) && InvocationSequenceDataHelper.hasHttpTimerData(o2)) {
                    String useCase1 = ((HttpTimerData)o1.getTimerData()).getHttpInfo().getInspectItTaggingHeaderValue();
                    String useCase2 = ((HttpTimerData)o2.getTimerData()).getHttpInfo().getInspectItTaggingHeaderValue();
                    return ObjectUtils.compare(useCase1, useCase2);
                }
                if (InvocationSequenceDataHelper.hasHttpTimerData(o1)) {
                    return 1;
                }
                if (InvocationSequenceDataHelper.hasHttpTimerData(o2)) {
                    return -1;
                }
                return 0;
            }
        }
        return 0;
    }
}

