/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class ProcessBuilder {
    private List<String> command;
    private File directory;
    private Map<String, String> environment;
    private boolean redirectErrorStream;
    private Redirect[] redirects;

    public ProcessBuilder(List<String> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.command = list;
    }

    public ProcessBuilder(String ... stringArray) {
        this.command = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            this.command.add(string);
        }
    }

    public ProcessBuilder command(List<String> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.command = list;
        return this;
    }

    public ProcessBuilder command(String ... stringArray) {
        this.command = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            this.command.add(string);
        }
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public Map<String, String> environment() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv.*"));
        }
        if (this.environment == null) {
            this.environment = ProcessEnvironment.environment();
        }
        assert (this.environment != null);
        return this.environment;
    }

    ProcessBuilder environment(String[] stringArray) {
        assert (this.environment == null);
        if (stringArray != null) {
            this.environment = ProcessEnvironment.emptyEnvironment(stringArray.length);
            assert (this.environment != null);
            for (String string : stringArray) {
                int n;
                if (string.indexOf(0) != -1) {
                    string = string.replaceFirst("\u0000.*", "");
                }
                if ((n = string.indexOf(61, 1)) == -1) continue;
                this.environment.put(string.substring(0, n), string.substring(n + 1));
            }
        }
        return this;
    }

    public File directory() {
        return this.directory;
    }

    public ProcessBuilder directory(File file) {
        this.directory = file;
        return this;
    }

    private Redirect[] redirects() {
        if (this.redirects == null) {
            this.redirects = new Redirect[]{Redirect.PIPE, Redirect.PIPE, Redirect.PIPE};
        }
        return this.redirects;
    }

    public ProcessBuilder redirectInput(Redirect redirect) {
        if (redirect.type() == Redirect.Type.WRITE || redirect.type() == Redirect.Type.APPEND) {
            throw new IllegalArgumentException("Redirect invalid for reading: " + redirect);
        }
        this.redirects()[0] = redirect;
        return this;
    }

    public ProcessBuilder redirectOutput(Redirect redirect) {
        if (redirect.type() == Redirect.Type.READ) {
            throw new IllegalArgumentException("Redirect invalid for writing: " + redirect);
        }
        this.redirects()[1] = redirect;
        return this;
    }

    public ProcessBuilder redirectError(Redirect redirect) {
        if (redirect.type() == Redirect.Type.READ) {
            throw new IllegalArgumentException("Redirect invalid for writing: " + redirect);
        }
        this.redirects()[2] = redirect;
        return this;
    }

    public ProcessBuilder redirectInput(File file) {
        return this.redirectInput(Redirect.from(file));
    }

    public ProcessBuilder redirectOutput(File file) {
        return this.redirectOutput(Redirect.to(file));
    }

    public ProcessBuilder redirectError(File file) {
        return this.redirectError(Redirect.to(file));
    }

    public Redirect redirectInput() {
        return this.redirects == null ? Redirect.PIPE : this.redirects[0];
    }

    public Redirect redirectOutput() {
        return this.redirects == null ? Redirect.PIPE : this.redirects[1];
    }

    public Redirect redirectError() {
        return this.redirects == null ? Redirect.PIPE : this.redirects[2];
    }

    public ProcessBuilder inheritIO() {
        Arrays.fill(this.redirects(), Redirect.INHERIT);
        return this;
    }

    public boolean redirectErrorStream() {
        return this.redirectErrorStream;
    }

    public ProcessBuilder redirectErrorStream(boolean bl) {
        this.redirectErrorStream = bl;
        return this;
    }

    public Process start() throws IOException {
        String[] stringArray = this.command.toArray(new String[this.command.size()]);
        for (String i : stringArray = (String[])stringArray.clone()) {
            if (i != null) continue;
            throw new NullPointerException();
        }
        String string = stringArray[0];
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec(string);
        }
        String string2 = this.directory == null ? null : this.directory.toString();
        for (int exception = 1; exception < stringArray.length; ++exception) {
            if (stringArray[exception].indexOf(0) < 0) continue;
            throw new IOException("invalid null character in command");
        }
        try {
            return ProcessImpl.start(stringArray, this.environment, string2, this.redirects, this.redirectErrorStream);
        }
        catch (IOException | IllegalArgumentException exception) {
            String string3 = ": " + exception.getMessage();
            Exception exception2 = exception;
            if (exception instanceof IOException && securityManager != null) {
                try {
                    securityManager.checkRead(string);
                }
                catch (AccessControlException accessControlException) {
                    string3 = "";
                    exception2 = accessControlException;
                }
            }
            throw new IOException("Cannot run program \"" + string + "\"" + (string2 == null ? "" : " (in directory \"" + string2 + "\")") + string3, exception2);
        }
    }

    public static abstract class Redirect {
        public static final Redirect PIPE = new Redirect(){

            @Override
            public Type type() {
                return Type.PIPE;
            }

            public String toString() {
                return this.type().toString();
            }
        };
        public static final Redirect INHERIT = new Redirect(){

            @Override
            public Type type() {
                return Type.INHERIT;
            }

            public String toString() {
                return this.type().toString();
            }
        };

        public abstract Type type();

        public File file() {
            return null;
        }

        boolean append() {
            throw new UnsupportedOperationException();
        }

        public static Redirect from(final File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            return new Redirect(){

                @Override
                public Type type() {
                    return Type.READ;
                }

                @Override
                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to read from file \"" + file + "\"";
                }
            };
        }

        public static Redirect to(final File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            return new Redirect(){

                @Override
                public Type type() {
                    return Type.WRITE;
                }

                @Override
                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to write to file \"" + file + "\"";
                }

                @Override
                boolean append() {
                    return false;
                }
            };
        }

        public static Redirect appendTo(final File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            return new Redirect(){

                @Override
                public Type type() {
                    return Type.APPEND;
                }

                @Override
                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to append to file \"" + file + "\"";
                }

                @Override
                boolean append() {
                    return true;
                }
            };
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Redirect)) {
                return false;
            }
            Redirect redirect = (Redirect)object;
            if (redirect.type() != this.type()) {
                return false;
            }
            assert (this.file() != null);
            return this.file().equals(redirect.file());
        }

        public int hashCode() {
            File file = this.file();
            if (file == null) {
                return super.hashCode();
            }
            return file.hashCode();
        }

        private Redirect() {
        }

        public static enum Type {
            PIPE,
            INHERIT,
            READ,
            WRITE,
            APPEND;

        }
    }

    static class NullOutputStream
    extends OutputStream {
        static final NullOutputStream INSTANCE = new NullOutputStream();

        private NullOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            throw new IOException("Stream closed");
        }
    }

    static class NullInputStream
    extends InputStream {
        static final NullInputStream INSTANCE = new NullInputStream();

        private NullInputStream() {
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }
}

