/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.query.factory.impl;

import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.query.factory.AbstractQueryFactory;
import info.novatec.inspectit.indexing.restriction.impl.IndexQueryRestrictionFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class InvocationSequenceDataQueryFactory<E extends IIndexQuery>
extends AbstractQueryFactory<E> {
    public E getInvocationSequenceOverview(long platformId, long methodId, int limit, Date fromDate, Date toDate) {
        Object query = this.getIndexQueryProvider().getIndexQuery();
        query.setPlatformIdent(platformId);
        query.setMethodIdent(methodId);
        ArrayList<Class<InvocationSequenceData>> searchedClasses = new ArrayList<Class<InvocationSequenceData>>();
        searchedClasses.add(InvocationSequenceData.class);
        query.setObjectClasses(searchedClasses);
        if (fromDate != null) {
            query.setFromDate(new Timestamp(fromDate.getTime()));
        }
        if (toDate != null) {
            query.setToDate(new Timestamp(toDate.getTime()));
        }
        return query;
    }

    public E getInvocationSequenceOverview(long platformId, Collection<Long> invocationIdCollection, int limit) {
        Object query = this.getIndexQueryProvider().getIndexQuery();
        query.setPlatformIdent(platformId);
        ArrayList<Class<InvocationSequenceData>> searchedClasses = new ArrayList<Class<InvocationSequenceData>>();
        searchedClasses.add(InvocationSequenceData.class);
        query.setObjectClasses(searchedClasses);
        query.addIndexingRestriction(IndexQueryRestrictionFactory.isInCollection("id", invocationIdCollection));
        return query;
    }
}

