/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.query.factory.impl;

import info.novatec.inspectit.communication.data.AggregatedHttpTimerData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.query.factory.AbstractQueryFactory;
import info.novatec.inspectit.indexing.restriction.impl.IndexQueryRestrictionFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class HttpTimerDataQueryFactory<E extends IIndexQuery>
extends AbstractQueryFactory<E> {
    public E getFindAllHttpTimersQuery(HttpTimerData httpData, Date fromDate, Date toDate) {
        Object query = this.getIndexQueryProvider().getIndexQuery();
        query.setPlatformIdent(httpData.getPlatformIdent());
        ArrayList<Class> classesToSearch = new ArrayList<Class>();
        classesToSearch.add(HttpTimerData.class);
        classesToSearch.add(AggregatedHttpTimerData.class);
        query.setObjectClasses(classesToSearch);
        if (null != fromDate) {
            query.setFromDate(new Timestamp(fromDate.getTime()));
        }
        if (null != toDate) {
            query.setToDate(new Timestamp(toDate.getTime()));
        }
        return query;
    }

    public E getFindAllTaggedHttpTimersQuery(HttpTimerData httpData, Date fromDate, Date toDate) {
        Object query = this.getIndexQueryProvider().getIndexQuery();
        query.setPlatformIdent(httpData.getPlatformIdent());
        ArrayList<Class> classesToSearch = new ArrayList<Class>();
        classesToSearch.add(HttpTimerData.class);
        classesToSearch.add(AggregatedHttpTimerData.class);
        query.setObjectClasses(classesToSearch);
        query.addIndexingRestriction(IndexQueryRestrictionFactory.isNotNull("httpInfo.inspectItTaggingHeaderValue"));
        if (null != fromDate) {
            query.setFromDate(new Timestamp(fromDate.getTime()));
        }
        if (null != toDate) {
            query.setToDate(new Timestamp(toDate.getTime()));
        }
        return query;
    }
}

