/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.aggregation.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.data.AggregatedExceptionSensorData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import java.io.Serializable;

public class ExceptionDataAggregator
implements IAggregator<ExceptionSensorData>,
Serializable {
    private static final long serialVersionUID = 3605008873889674596L;
    private ExceptionAggregationType exceptionAggregationType;

    public ExceptionDataAggregator() {
    }

    public ExceptionDataAggregator(ExceptionAggregationType exceptionAggregationType) {
        this.exceptionAggregationType = exceptionAggregationType;
    }

    @Override
    public void aggregate(IAggregatedData<ExceptionSensorData> aggregatedObject, ExceptionSensorData objectToAdd) {
        aggregatedObject.aggregate((DefaultData)objectToAdd);
        if (null != objectToAdd.getChild()) {
            this.aggregate(aggregatedObject, objectToAdd.getChild());
        }
    }

    @Override
    public IAggregatedData<ExceptionSensorData> getClone(ExceptionSensorData exceptionData) {
        AggregatedExceptionSensorData clone = new AggregatedExceptionSensorData();
        clone.setPlatformIdent(exceptionData.getPlatformIdent());
        clone.setSensorTypeIdent(exceptionData.getSensorTypeIdent());
        clone.setThrowableType(exceptionData.getThrowableType());
        if (this.exceptionAggregationType == ExceptionAggregationType.GROUP_EXCEPTION_OVERVIEW || this.exceptionAggregationType == ExceptionAggregationType.DISTINCT_STACK_TRACES) {
            clone.setErrorMessage(exceptionData.getErrorMessage());
        }
        if (this.exceptionAggregationType == ExceptionAggregationType.DISTINCT_STACK_TRACES) {
            clone.setStackTrace(this.getCorrectStackTrace(exceptionData.getStackTrace()));
        }
        return clone;
    }

    @Override
    public Object getAggregationKey(ExceptionSensorData exceptionSensorData) {
        int prime = 31;
        if (this.exceptionAggregationType == ExceptionAggregationType.THROWABLE_TYPE) {
            int result = 0;
            result = 31 * result + (exceptionSensorData.getThrowableType() == null ? 0 : exceptionSensorData.getThrowableType().hashCode());
            return result;
        }
        if (this.exceptionAggregationType == ExceptionAggregationType.GROUP_EXCEPTION_OVERVIEW) {
            int result = 0;
            result = 31 * result + (exceptionSensorData.getThrowableType() == null ? 0 : exceptionSensorData.getThrowableType().hashCode());
            result = 31 * result + (exceptionSensorData.getErrorMessage() == null ? 0 : exceptionSensorData.getErrorMessage().hashCode());
            return result;
        }
        if (this.exceptionAggregationType == ExceptionAggregationType.DISTINCT_STACK_TRACES) {
            int result = 0;
            result = 31 * result + (exceptionSensorData.getErrorMessage() == null ? 0 : exceptionSensorData.getErrorMessage().hashCode());
            result = 31 * result + (exceptionSensorData.getStackTrace() == null ? 0 : this.getCorrectStackTrace(exceptionSensorData.getStackTrace()).hashCode());
            return result;
        }
        return 0;
    }

    private String getCorrectStackTrace(String stackTrace) {
        if (null == stackTrace) {
            return null;
        }
        int index = stackTrace.indexOf("\n\tat");
        if (index >= 0) {
            return stackTrace.substring(index + 1);
        }
        return stackTrace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exceptionAggregationType == null ? 0 : this.exceptionAggregationType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionDataAggregator other = (ExceptionDataAggregator)obj;
        return this.exceptionAggregationType == other.exceptionAggregationType;
    }

    public static enum ExceptionAggregationType {
        GROUP_EXCEPTION_OVERVIEW,
        DISTINCT_STACK_TRACES,
        THROWABLE_TYPE;

    }
}

